/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.settings;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.settings.ProxyType;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class ProxySettings {
    public static final String HTTP_DOT_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_DOT_PROXY_PORT = "http.proxyPort";
    public static final String SOCKS_PROXY_HOST = "socksProxyHost";
    public static final String SOCKS_PROXY_PORT = "socksProxyPort";
    public static final String DEPLOYMENT_PROXY_HTTP_HOST = "deployment.proxy.http.host";
    public static final String DEPLOYMENT_PROXY_HTTP_PORT = "deployment.proxy.http.port";
    public static final String DEPLOYMENT_PROXY_SOCKS_HOST = "deployment.proxy.socks.host";
    public static final String DEPLOYMENT_PROXY_SOCKS_PORT = "deployment.proxy.socks.port";
    public static final String PROXY_PORT = "proxyPort";
    public static final String PROXY_HOST = "proxyHost";
    private static final Log logger = LogFactory.getLog(ProxySettings.class);
    private static ProxySettings instance;
    private static final String PROXY_TYPE_KEY = "ProxyType";
    private static final String PROXY_USER_KEY = "ProxyUser";
    private static final String PROXY_PASSWORD_KEY = "ProxyPassword";
    private static final String USE_SOCKS_PROXY_KEY = "UseSocksProxy";
    private Preferences preferences = Preferences.userRoot().node("org/pentaho/reporting/designer/core/settings/proxy-settings");

    public static synchronized ProxySettings getInstance() {
        if (instance == null) {
            instance = new ProxySettings();
        }
        return instance;
    }

    public void installAuthenticator() {
        Authenticator.setDefault(new SettingsAuthenticator());
    }

    public ProxyType getProxyType() {
        String unitText = this.preferences.get(PROXY_TYPE_KEY, ProxyType.AUTO_DETECT_PROXY.toString());
        try {
            return ProxyType.valueOf(unitText);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setProxyType(ProxyType proxyType) {
        if (proxyType == null) {
            throw new IllegalArgumentException("proxyType must not be null");
        }
        this.preferences.put(PROXY_TYPE_KEY, String.valueOf((Object)proxyType));
    }

    public String getHTTPProxyHost() {
        return this.preferences.get(HTTP_DOT_PROXY_HOST, System.getProperty(HTTP_DOT_PROXY_HOST));
    }

    public void setHTTPProxyHost(String httpProxyHost) {
        if (httpProxyHost == null) {
            this.preferences.remove(HTTP_DOT_PROXY_HOST);
        } else {
            this.preferences.put(HTTP_DOT_PROXY_HOST, httpProxyHost);
        }
    }

    public int getHTTPProxyPort() {
        return this.preferences.getInt(HTTP_DOT_PROXY_PORT, ParserUtil.parseInt((String)System.getProperty(HTTP_DOT_PROXY_PORT), (int)-1));
    }

    public void setHTTPProxyPort(int httpProxyPort) {
        this.preferences.putInt(HTTP_DOT_PROXY_PORT, httpProxyPort);
    }

    public String getProxyUser() {
        return this.preferences.get(PROXY_USER_KEY, "");
    }

    public void setProxyUser(String proxyUser) {
        this.preferences.put(PROXY_USER_KEY, proxyUser);
    }

    public String getProxyPassword() {
        return this.preferences.get(PROXY_PASSWORD_KEY, "");
    }

    public void setProxyPassword(String proxyPassword) {
        this.preferences.put(PROXY_PASSWORD_KEY, proxyPassword);
    }

    public boolean isUseSocksProxy() {
        return this.preferences.getBoolean(USE_SOCKS_PROXY_KEY, false);
    }

    public void setUseSocksProxy(boolean useSocksProxy) {
        this.preferences.putBoolean(USE_SOCKS_PROXY_KEY, useSocksProxy);
    }

    public int getSocksProxyPort() {
        return this.preferences.getInt(SOCKS_PROXY_PORT, ParserUtil.parseInt((String)System.getProperty(SOCKS_PROXY_PORT), (int)-1));
    }

    public void setSocksProxyPort(int socksProxyPort) {
        this.preferences.putInt(SOCKS_PROXY_PORT, socksProxyPort);
    }

    public String getSocksProxyHost() {
        return this.preferences.get(SOCKS_PROXY_HOST, System.getProperty(SOCKS_PROXY_HOST));
    }

    public void setSocksProxyHost(String socksProxyHost) {
        if (socksProxyHost == null) {
            this.preferences.remove(SOCKS_PROXY_HOST);
        } else {
            this.preferences.put(SOCKS_PROXY_HOST, socksProxyHost);
        }
    }

    public void applySettings() {
        try {
            System.setProperty(HTTP_DOT_PROXY_HOST, "");
            System.setProperty(HTTP_DOT_PROXY_PORT, "");
            System.setProperty(SOCKS_PROXY_HOST, "");
            System.setProperty(SOCKS_PROXY_PORT, "");
            switch (this.getProxyType()) {
                case AUTO_DETECT_PROXY: {
                    String socksPort;
                    String port;
                    String host = ProxySettings.getWebstartHTTPProxyHost();
                    boolean httpProxySet = false;
                    if (host != null && host.trim().length() > 0) {
                        System.setProperty(HTTP_DOT_PROXY_HOST, host);
                        httpProxySet = true;
                    }
                    if ((port = ProxySettings.getWebstartHTTPProxyPort()) != null) {
                        System.setProperty(HTTP_DOT_PROXY_PORT, port);
                    }
                    if (httpProxySet) break;
                    String socksHost = ProxySettings.getWebstartSOCKSProxyHost();
                    if (!StringUtils.isEmpty((String)socksHost, (boolean)true)) {
                        System.setProperty(SOCKS_PROXY_HOST, socksHost);
                    }
                    if (!StringUtils.isEmpty((String)(socksPort = ProxySettings.getWebstartSOCKSProxyPort()), (boolean)true)) {
                        System.setProperty(SOCKS_PROXY_PORT, socksPort);
                    }
                    break;
                }
                case NO_PROXY: {
                    break;
                }
                case USER_PROXY: {
                    int port;
                    if (this.isUseSocksProxy()) {
                        int port2;
                        System.setProperty(HTTP_DOT_PROXY_HOST, "");
                        System.setProperty(HTTP_DOT_PROXY_PORT, "");
                        String host = this.getSocksProxyHost();
                        if (!StringUtils.isEmpty((String)host)) {
                            System.setProperty(SOCKS_PROXY_HOST, host);
                        }
                        if ((port2 = this.getSocksProxyPort()) != -1) {
                            System.setProperty(SOCKS_PROXY_PORT, String.valueOf(port2));
                        }
                        break;
                    }
                    String host = this.getHTTPProxyHost();
                    if (!StringUtils.isEmpty((String)host)) {
                        System.setProperty(HTTP_DOT_PROXY_HOST, host);
                    }
                    if ((port = this.getHTTPProxyPort()) != -1) {
                        System.setProperty(HTTP_DOT_PROXY_PORT, String.valueOf(port));
                    }
                    System.setProperty(SOCKS_PROXY_HOST, "");
                    System.setProperty(SOCKS_PROXY_PORT, "");
                }
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Failed to configure proxy settings.", t);
        }
        this.printProxyConfiguration();
    }

    private void printProxyConfiguration() {
        logger.info((Object)(HTTP_DOT_PROXY_HOST + System.getProperty(HTTP_DOT_PROXY_HOST, "<undefined>")));
        logger.info((Object)(HTTP_DOT_PROXY_PORT + System.getProperty(HTTP_DOT_PROXY_PORT, "<undefined>")));
        logger.info((Object)(SOCKS_PROXY_HOST + System.getProperty(SOCKS_PROXY_HOST, "<undefined>")));
        logger.info((Object)(SOCKS_PROXY_PORT + System.getProperty(SOCKS_PROXY_PORT, "<undefined>")));
    }

    private static String getWebstartHTTPProxyHost() {
        String host = System.getProperty(DEPLOYMENT_PROXY_HTTP_HOST);
        if (host != null) {
            return host;
        }
        return System.getProperty(PROXY_HOST);
    }

    private static String getWebstartHTTPProxyPort() {
        String port = System.getProperty(DEPLOYMENT_PROXY_HTTP_PORT);
        if (port != null) {
            return port;
        }
        return System.getProperty(PROXY_PORT);
    }

    private static String getWebstartSOCKSProxyHost() {
        return System.getProperty(DEPLOYMENT_PROXY_SOCKS_HOST);
    }

    private static String getWebstartSOCKSProxyPort() {
        return System.getProperty(DEPLOYMENT_PROXY_SOCKS_PORT);
    }

    public void flush() {
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    private class SettingsAuthenticator
    extends Authenticator {
        private SettingsAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(ProxySettings.this.getProxyUser(), ProxySettings.this.getProxyPassword().toCharArray());
        }
    }
}

