/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.settings.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.settings.ProxySettings;
import org.pentaho.reporting.designer.core.settings.ProxyType;
import org.pentaho.reporting.designer.core.settings.SettingsMessages;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.settings.ui.PasswordExceptionsDialog;
import org.pentaho.reporting.designer.core.settings.ui.SettingsPlugin;
import org.pentaho.reporting.designer.core.settings.ui.ShowPasswordsDialog;
import org.pentaho.reporting.designer.core.settings.ui.ValidationMessage;
import org.pentaho.reporting.designer.core.settings.ui.ValidationResult;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class NetworkSettingsPanel
extends JPanel
implements SettingsPlugin {
    private JRadioButton radioButtonNoProxy;
    private JRadioButton radioButtonAutoDetectProxy;
    private JRadioButton radioButtonUserProxy;
    private JTextField proxyHostTextField;
    private JTextField proxyPortTextField;
    private JLabel proxyHostLabel;
    private JLabel proxyPortLabel;
    private JLabel userLabel;
    private JLabel passwordLabel;
    private JTextField userTextField;
    private JPasswordField passwordField;
    private JCheckBox socksCheckBox;
    private ButtonGroup buttonGroup;
    private JCheckBox offlineMode;
    private JCheckBox rememberPasswordsBox;
    private EditExceptionsAction editExceptionsAction = new EditExceptionsAction();
    private ReportDesignerContext reportDesignerContext;

    public NetworkSettingsPanel() {
        this.offlineMode = new JCheckBox(SettingsMessages.getInstance().getString("ProxySettingsPanel.OfflineMode"));
        this.offlineMode.setSelected(WorkspaceSettings.getInstance().isOfflineMode());
        this.rememberPasswordsBox = new JCheckBox(SettingsMessages.getInstance().getString("ProxySettingsPanel.RememberPasswords"));
        this.rememberPasswordsBox.setSelected(WorkspaceSettings.getInstance().isRememberPasswords());
        this.rememberPasswordsBox.addChangeListener(new EnableTextFieldsHandler());
        this.radioButtonNoProxy = new JRadioButton(SettingsMessages.getInstance().getString("ProxySettingsPanel.noProxy"));
        this.radioButtonNoProxy.addChangeListener(new EnableTextFieldsHandler());
        this.radioButtonAutoDetectProxy = new JRadioButton(SettingsMessages.getInstance().getString("ProxySettingsPanel.autoDetectProxy"));
        this.radioButtonAutoDetectProxy.addChangeListener(new EnableTextFieldsHandler());
        this.radioButtonUserProxy = new JRadioButton(SettingsMessages.getInstance().getString("ProxySettingsPanel.userProxy"));
        this.radioButtonUserProxy.addChangeListener(new EnableTextFieldsHandler());
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.radioButtonNoProxy);
        this.buttonGroup.add(this.radioButtonAutoDetectProxy);
        this.buttonGroup.add(this.radioButtonUserProxy);
        this.proxyHostTextField = new JTextField(null, 0);
        this.proxyPortTextField = new JTextField(null, 0);
        this.socksCheckBox = new JCheckBox(SettingsMessages.getInstance().getString("ProxySettingsPanel.socks"));
        this.proxyHostLabel = new JLabel(SettingsMessages.getInstance().getString("ProxySettingsPanel.proxyHost"));
        this.proxyPortLabel = new JLabel(SettingsMessages.getInstance().getString("ProxySettingsPanel.proxyPort"));
        this.userLabel = new JLabel(SettingsMessages.getInstance().getString("ProxySettingsPanel.user"));
        this.passwordLabel = new JLabel(SettingsMessages.getInstance().getString("ProxySettingsPanel.password"));
        this.userTextField = new JTextField(null, 0);
        this.passwordField = new JPasswordField();
        this.passwordField.setPreferredSize(this.userTextField.getPreferredSize());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        contentPanel.add((Component)this.createProxySettingsPanel(), c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.insets = new Insets(5, 0, 0, 0);
        c.fill = 2;
        contentPanel.add((Component)this.createNetworkPanel(), c);
        this.setLayout(new BorderLayout());
        this.add((Component)contentPanel, "North");
        this.reset();
    }

    private JPanel createNetworkPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(SettingsMessages.getInstance().getString("ProxySettingsPanel.NetworkSettings")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 4, 4);
        panel.add((Component)this.offlineMode, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 4, 4);
        panel.add((Component)this.rememberPasswordsBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 4, 4);
        panel.add((Component)new JButton(this.editExceptionsAction), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 4, 4);
        panel.add((Component)new JButton(new ShowPasswordsAction()), gbc);
        return panel;
    }

    private JPanel createProxySettingsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(SettingsMessages.getInstance().getString("ProxySettingsPanel.ProxySettings")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 4, 4);
        panel.add((Component)this.radioButtonNoProxy, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 4, 4, 4);
        gbc.anchor = 17;
        gbc.fill = 2;
        panel.add((Component)this.radioButtonAutoDetectProxy, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 4, 4, 4);
        gbc.anchor = 17;
        gbc.fill = 2;
        panel.add((Component)this.radioButtonUserProxy, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 4, 4);
        panel.add((Component)this.proxyHostLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 4, 4);
        panel.add((Component)this.proxyHostTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 4, 4, 4);
        panel.add((Component)this.proxyPortLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 4, 4, 4);
        panel.add((Component)this.proxyPortTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 4, 4, 4);
        panel.add((Component)this.socksCheckBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 4, 4);
        panel.add((Component)this.userLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 4, 4);
        panel.add((Component)this.userTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 4, 4, 4);
        panel.add((Component)this.passwordLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 4, 4, 4);
        panel.add((Component)this.passwordField, gbc);
        return panel;
    }

    protected void updateState() {
        this.editExceptionsAction.setEnabled(this.rememberPasswordsBox.isSelected());
        if (this.radioButtonNoProxy.isSelected()) {
            this.enableProxyFields(false);
            this.enableAuthenticationFields(false);
        } else if (this.radioButtonAutoDetectProxy.isSelected()) {
            this.enableProxyFields(false);
            this.enableAuthenticationFields(true);
        } else {
            this.enableProxyFields(true);
            this.enableAuthenticationFields(true);
        }
    }

    private void enableProxyFields(boolean enable) {
        this.proxyHostTextField.setEnabled(enable);
        this.proxyPortTextField.setEnabled(enable);
        this.proxyHostLabel.setEnabled(enable);
        this.proxyPortLabel.setEnabled(enable);
        this.socksCheckBox.setEnabled(enable);
    }

    private void enableAuthenticationFields(boolean enable) {
        this.userLabel.setEnabled(enable);
        this.userTextField.setEnabled(enable);
        this.passwordLabel.setEnabled(enable);
        this.passwordField.setEnabled(enable);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getNetworkIcon32();
    }

    @Override
    public String getTitle() {
        return SettingsMessages.getInstance().getString("SettingsDialog.Proxy");
    }

    @Override
    public ValidationResult validate(ValidationResult result) {
        if (this.radioButtonUserProxy.isSelected() && !NetworkSettingsPanel.isValidPortNumber(this.proxyPortTextField.getText().trim())) {
            ValidationMessage validationMessage = new ValidationMessage(ValidationMessage.Severity.ERROR, SettingsMessages.getInstance().getString("ProxySettingsPanel.invalidPortFormat"));
            result.addValidationMessage(validationMessage);
        }
        return result;
    }

    private static boolean isValidPortNumber(String s) {
        try {
            int port = Integer.parseInt(s);
            return port > 0 && port < 65536;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void apply() {
        WorkspaceSettings.getInstance().setOfflineMode(this.offlineMode.isSelected());
        WorkspaceSettings.getInstance().setRememberPasswords(this.rememberPasswordsBox.isSelected());
        ProxySettings proxySettings = ProxySettings.getInstance();
        if (this.radioButtonNoProxy.isSelected()) {
            proxySettings.setProxyType(ProxyType.NO_PROXY);
        } else if (this.radioButtonAutoDetectProxy.isSelected()) {
            proxySettings.setProxyType(ProxyType.AUTO_DETECT_PROXY);
        } else if (this.radioButtonUserProxy.isSelected()) {
            proxySettings.setProxyType(ProxyType.USER_PROXY);
            proxySettings.setUseSocksProxy(this.socksCheckBox.isSelected());
            if (this.socksCheckBox.isSelected()) {
                proxySettings.setSocksProxyHost(this.proxyHostTextField.getText().trim());
                proxySettings.setSocksProxyPort(ParserUtil.parseInt((String)this.proxyPortTextField.getText().trim(), (int)-1));
            } else {
                proxySettings.setHTTPProxyHost(this.proxyHostTextField.getText().trim());
                proxySettings.setHTTPProxyPort(ParserUtil.parseInt((String)this.proxyPortTextField.getText().trim(), (int)-1));
            }
        }
        proxySettings.setProxyUser(this.userTextField.getText());
        proxySettings.setProxyPassword(new String(this.passwordField.getPassword()));
        proxySettings.applySettings();
    }

    @Override
    public void reset() {
        this.offlineMode.setSelected(WorkspaceSettings.getInstance().isOfflineMode());
        this.rememberPasswordsBox.setSelected(WorkspaceSettings.getInstance().isRememberPasswords());
        ProxySettings proxySettings = ProxySettings.getInstance();
        String httpProxyHost = proxySettings.getHTTPProxyHost();
        String proxyHost = proxySettings.getSocksProxyHost();
        switch (proxySettings.getProxyType()) {
            case NO_PROXY: {
                this.buttonGroup.setSelected(this.radioButtonNoProxy.getModel(), true);
                this.proxyHostTextField.setText("");
                this.proxyPortTextField.setText("");
                this.userTextField.setText("");
                this.passwordField.setText("");
                this.enableProxyFields(false);
                this.enableAuthenticationFields(false);
                break;
            }
            case AUTO_DETECT_PROXY: {
                this.buttonGroup.setSelected(this.radioButtonAutoDetectProxy.getModel(), true);
                if (httpProxyHost != null && httpProxyHost.trim().length() > 0) {
                    this.proxyHostTextField.setText(httpProxyHost);
                    this.proxyPortTextField.setText(String.valueOf(proxySettings.getHTTPProxyPort()));
                    this.socksCheckBox.setSelected(false);
                } else if (proxyHost != null && proxyHost.trim().length() > 0) {
                    this.proxyHostTextField.setText(proxyHost);
                    this.proxyPortTextField.setText(String.valueOf(proxySettings.getSocksProxyPort()));
                    this.socksCheckBox.setSelected(true);
                } else {
                    this.proxyHostTextField.setText("");
                    this.proxyPortTextField.setText("");
                    this.socksCheckBox.setSelected(false);
                }
                this.enableProxyFields(false);
                this.userTextField.setText("");
                this.passwordField.setText("");
                this.enableAuthenticationFields(true);
                break;
            }
            case USER_PROXY: {
                this.buttonGroup.setSelected(this.radioButtonUserProxy.getModel(), true);
                if (proxySettings.isUseSocksProxy()) {
                    this.proxyHostTextField.setText(proxyHost);
                    this.proxyPortTextField.setText(String.valueOf(proxySettings.getSocksProxyPort()));
                } else {
                    this.proxyHostTextField.setText(httpProxyHost);
                    this.proxyPortTextField.setText(String.valueOf(proxySettings.getHTTPProxyPort()));
                }
                this.socksCheckBox.setSelected(proxySettings.isUseSocksProxy());
                this.enableProxyFields(true);
                this.enableAuthenticationFields(true);
                this.userTextField.setText(proxySettings.getProxyUser());
                this.passwordField.setText(proxySettings.getProxyPassword());
            }
        }
        this.userTextField.setText(proxySettings.getProxyUser());
        this.passwordField.setText(proxySettings.getProxyPassword());
    }

    public ReportDesignerContext getReportDesignerContext() {
        return this.reportDesignerContext;
    }

    public void setReportDesignerContext(ReportDesignerContext reportDesignerContext) {
        this.reportDesignerContext = reportDesignerContext;
    }

    private class EnableTextFieldsHandler
    implements ChangeListener {
        private EnableTextFieldsHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            NetworkSettingsPanel.this.updateState();
        }
    }

    private class ShowPasswordsAction
    extends AbstractAction {
        private ShowPasswordsAction() {
            this.putValue("Name", SettingsMessages.getInstance().getString("ProxySettingsPanel.ShowPasswords"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReportDesignerContext context = NetworkSettingsPanel.this.getReportDesignerContext();
            if (context == null) {
                throw new IllegalStateException();
            }
            Window window = LibSwingUtil.getWindowAncestor((Component)NetworkSettingsPanel.this);
            ShowPasswordsDialog showPasswordsDialog = window instanceof Dialog ? new ShowPasswordsDialog((Dialog)window) : (window instanceof Frame ? new ShowPasswordsDialog((Frame)window) : new ShowPasswordsDialog());
            showPasswordsDialog.showDialog(context.getGlobalAuthenticationStore());
        }
    }

    private class EditExceptionsAction
    extends AbstractAction {
        private EditExceptionsAction() {
            this.putValue("Name", SettingsMessages.getInstance().getString("ProxySettingsPanel.Exceptions"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Window window = LibSwingUtil.getWindowAncestor((Component)NetworkSettingsPanel.this);
            PasswordExceptionsDialog showPasswordsDialog = window instanceof Dialog ? new PasswordExceptionsDialog((Dialog)window) : (window instanceof Frame ? new PasswordExceptionsDialog((Frame)window) : new PasswordExceptionsDialog());
            showPasswordsDialog.performEdit();
        }
    }
}

