/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.status;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.inspections.InspectionResult;
import org.pentaho.reporting.designer.core.inspections.InspectionResultListener;
import org.pentaho.reporting.designer.core.util.IconLoader;

public class MessagesStatusGadget
extends JLabel
implements InspectionResultListener {
    private boolean firstTime;
    private ImageIcon errorIcon;
    private ImageIcon noErrorIcon;
    private ReportDesignerContext designerContext;

    public MessagesStatusGadget(ReportDesignerContext designerContext) {
        this.designerContext = designerContext;
        this.firstTime = true;
        this.errorIcon = IconLoader.getInstance().getWarningIcon();
        this.noErrorIcon = IconLoader.getInstance().getNoErrorIcon();
        this.setHorizontalAlignment(0);
        this.setIcon(this.noErrorIcon);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseSelectionHandler());
        ActiveContextChangeListener changeHandler = new ActiveContextChangeListener();
        designerContext.addPropertyChangeListener("activeContext", changeHandler);
        this.updateActiveContext(null, designerContext.getActiveContext());
    }

    private void updateActiveContext(ReportDocumentContext oldContext, ReportDocumentContext activeContext) {
        if (oldContext != null) {
            oldContext.removeInspectionListener(this);
        }
        if (activeContext != null) {
            activeContext.addInspectionListener(this);
        }
    }

    protected void handleExceptionClick() {
        this.setIcon(IconLoader.getInstance().getNoErrorIcon());
        this.designerContext.getView().setMessagesVisible(true);
    }

    private JLabel createPopup() {
        JLabel label = new JLabel(Messages.getString("StatusBar.Inspection.Message", new Object[0]));
        label.setForeground(new Color(0, 0, 0));
        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.YELLOW), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        label.setBackground(new Color(255, 255, 0, 125));
        label.setOpaque(true);
        Timer t = new Timer(5000, new ClearWarningMessageAction(label));
        t.setRepeats(false);
        t.start();
        return label;
    }

    @Override
    public void notifyInspectionStarted() {
    }

    @Override
    public void notifyInspectionResult(InspectionResult result) {
        if (this.firstTime) {
            Container rootPane;
            this.firstTime = false;
            for (rootPane = this.getParent(); rootPane != null && !(rootPane instanceof JRootPane); rootPane = rootPane.getParent()) {
            }
            if (rootPane != null) {
                JRootPane jRootPane = (JRootPane)rootPane;
                JLabel errorPopup = this.createPopup();
                JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
                jLayeredPane.add((Component)errorPopup, JLayeredPane.POPUP_LAYER);
                Rectangle rectangle = SwingUtilities.convertRectangle(this.getParent(), this.getBounds(), jRootPane.getLayeredPane());
                Dimension dimension = errorPopup.getPreferredSize();
                errorPopup.setBounds((int)(rectangle.getX() - (double)dimension.width), (int)(rectangle.getY() - (double)dimension.height), dimension.width, dimension.height);
                jRootPane.getLayeredPane().revalidate();
                jRootPane.getLayeredPane().repaint();
            }
        }
        if (this.getIcon() == this.noErrorIcon) {
            this.setIcon(this.errorIcon);
        }
        this.repaint();
    }

    private class MouseSelectionHandler
    extends MouseAdapter {
        private MouseSelectionHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent ex) {
            MessagesStatusGadget.this.handleExceptionClick();
        }
    }

    private class ActiveContextChangeListener
    implements PropertyChangeListener {
        private ActiveContextChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ReportRenderContext oldContext = (ReportRenderContext)evt.getOldValue();
            ReportRenderContext activeContext = (ReportRenderContext)evt.getNewValue();
            MessagesStatusGadget.this.updateActiveContext(oldContext, activeContext);
        }
    }

    private static class ClearWarningMessageAction
    implements ActionListener {
        private final JLabel label;

        private ClearWarningMessageAction(JLabel label) {
            this.label = label;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Container container = this.label.getParent();
            if (container != null) {
                container.remove(this.label);
                container.repaint();
            }
        }
    }
}

