/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTMLDocument;
import org.pentaho.reporting.designer.core.util.GUIUtils;
import org.pentaho.reporting.designer.core.util.UtilMessages;
import org.pentaho.reporting.designer.core.util.dnd.ClipboardManager;
import org.pentaho.reporting.libraries.base.util.SystemInformation;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.xmlns.writer.CharacterEntityParser;
import org.pentaho.reporting.libraries.xmlns.writer.HtmlCharacterEntities;

public class SystemInformationDialog
extends CommonDialog {
    private JEditorPane editorPane;

    public SystemInformationDialog() throws HeadlessException {
        this.init();
    }

    public SystemInformationDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public SystemInformationDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    protected void init() {
        this.setTitle(UtilMessages.getInstance().getString("SystemInformationDialog.Title"));
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        this.editorPane.setText(this.getSystemInformationAsHTML());
        HTMLDocument htmlDocument = (HTMLDocument)this.editorPane.getDocument();
        htmlDocument.getStyleSheet().addRule("body { font-family:sans-serif; }");
        this.editorPane.setCaretPosition(0);
        super.init();
        this.getConfirmAction().putValue("Name", UtilMessages.getInstance().getString("SystemInformationDialog.Close"));
    }

    protected void performInitialResize() {
        this.pack();
        GUIUtils.ensureMinimumDialogSize((Dialog)((Object)this), 400, 300);
        GUIUtils.ensureMaximumDialogSize((Dialog)((Object)this), 800, 600);
        LibSwingUtil.centerDialogInParent((Dialog)((Object)this));
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.SystemInformation";
    }

    public void performShow() {
        super.performEdit();
    }

    protected Component createContentPane() {
        return new JScrollPane(this.editorPane);
    }

    protected Action[] getExtraActions() {
        return new Action[]{new CopyAction()};
    }

    protected boolean hasCancelButton() {
        return false;
    }

    private String getSystemInformationAsHTML() {
        CharacterEntityParser cep = HtmlCharacterEntities.getEntityParser();
        StringBuilder sb = new StringBuilder(10000);
        sb.append("<html><body>\n");
        sb.append("<h1>");
        sb.append(cep.encodeEntities(UtilMessages.getInstance().getString("SystemInformationDialog.SystemProperties.Title")));
        sb.append("</h1>");
        this.formatMap(cep, sb, new TreeMap<Object, Object>(System.getProperties()));
        sb.append("<br>");
        sb.append("<h1>");
        sb.append(cep.encodeEntities(UtilMessages.getInstance().getString("SystemInformationDialog.Environment.Title")));
        sb.append("</h1>");
        this.formatMap(cep, sb, new TreeMap<String, String>(System.getenv()));
        sb.append("<br>");
        sb.append("<h1>");
        sb.append(cep.encodeEntities(UtilMessages.getInstance().getString("SystemInformationDialog.Other.Title")));
        sb.append("</h1>");
        this.formatMap(cep, sb, SystemInformation.getOtherProperties());
        sb.append("</body></html>\n");
        return sb.toString();
    }

    private String getSystemInformationAsText() {
        CharacterEntityParser cep = HtmlCharacterEntities.getEntityParser();
        StringBuilder sb = new StringBuilder(10000);
        String sysPropTitle = UtilMessages.getInstance().getString("SystemInformationDialog.SystemProperties.Title");
        sb.append(sysPropTitle);
        sb.append("\n");
        sb.append(this.printUnderline(sysPropTitle.length()));
        sb.append("\n");
        sb.append("\n");
        this.formatMapText(cep, sb, new TreeMap<Object, Object>(System.getProperties()));
        sb.append("\n");
        sb.append("\n");
        String envTitle = UtilMessages.getInstance().getString("SystemInformationDialog.Environment.Title");
        sb.append(envTitle);
        sb.append("\n");
        sb.append(this.printUnderline(envTitle.length()));
        sb.append("\n");
        sb.append("\n");
        this.formatMapText(cep, sb, new TreeMap<String, String>(System.getenv()));
        sb.append("\n");
        sb.append("\n");
        String otherTitle = UtilMessages.getInstance().getString("SystemInformationDialog.Other.Title");
        sb.append(otherTitle);
        sb.append("\n");
        sb.append(this.printUnderline(otherTitle.length()));
        sb.append("\n");
        sb.append("\n");
        this.formatMapText(cep, sb, SystemInformation.getOtherProperties());
        sb.append("\n");
        return sb.toString();
    }

    private String printUnderline(int length) {
        StringBuilder b = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            b.append("=");
        }
        return b.toString();
    }

    private void formatMapText(CharacterEntityParser cep, StringBuilder sb, Map environmentMap) {
        if (environmentMap.isEmpty()) {
            return;
        }
        Iterator i$ = environmentMap.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entryRaw;
            Map.Entry entry = entryRaw = i$.next();
            String key = String.valueOf(entry.getKey());
            String value = (String)entry.getValue();
            if (value != null) {
                value = cep.encodeEntities(value);
                value = value.replace("\n", "\\n");
                value = value.replace("\f", "\\f");
                if ((value = value.replace("\r", "\\r")).length() > 80) {
                    value = value.replace(File.pathSeparator, File.pathSeparator + "\n          ");
                }
            }
            sb.append(key);
            sb.append("=");
            sb.append(value);
            sb.append("\n");
        }
    }

    private void formatMap(CharacterEntityParser cep, StringBuilder sb, Map environmentMap) {
        if (environmentMap.isEmpty()) {
            return;
        }
        sb.append("<table>\n");
        Iterator i$ = environmentMap.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entryRaw;
            Map.Entry entry = entryRaw = i$.next();
            String key = String.valueOf(entry.getKey());
            String value = (String)entry.getValue();
            if (value != null) {
                value = cep.encodeEntities(value);
                value = value.replace("\n", "\\n");
                value = value.replace("\f", "\\f");
                if ((value = value.replace("\r", "\\r")).length() > 80) {
                    value = value.replace(File.pathSeparator, File.pathSeparator + "<br>\n");
                }
            }
            sb.append("<tr valign=\"top\"><td>");
            sb.append(cep.encodeEntities(key));
            sb.append("</td><td>");
            sb.append(value);
            sb.append("</td></tr>\n");
        }
        sb.append("</table>");
    }

    private class CopyAction
    extends AbstractAction {
        private CopyAction() {
            this.putValue("Name", UtilMessages.getInstance().getString("SystemInformationDialog.CopyToClipboard"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClipboardManager.getManager().setRawContent(new StringSelection(SystemInformationDialog.this.getSystemInformationAsText()));
        }
    }
}

