/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.exceptions;

import java.awt.EventQueue;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;

public class ThrowableHandler
implements Thread.UncaughtExceptionHandler {
    private static final ThrowableHandler instance = new ThrowableHandler();

    public static ThrowableHandler getInstance() {
        return instance;
    }

    public void handle(Throwable throwable) {
        UncaughtExceptionsModel.getInstance().addException(throwable);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (!EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeLater(new HandleExceptionTask(e));
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        } else {
            this.handle(e);
        }
    }

    private class HandleExceptionTask
    implements Runnable {
        private final Throwable e;

        private HandleExceptionTask(Throwable e) {
            this.e = e;
        }

        @Override
        public void run() {
            try {
                ThrowableHandler.this.handle(this.e);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

