/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.kettle;

import java.math.BigDecimal;
import java.util.Date;
import javax.swing.table.TableModel;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;

public class TableProducer
implements RowListener {
    private TypedTableModel tableModel;
    private int rowsWritten;
    private RowMetaInterface rowMeta;
    private int queryLimit;
    private boolean stopOnError;
    private boolean firstCall;
    private boolean error;

    public TableProducer(RowMetaInterface rowMeta, int queryLimit, boolean stopOnError) {
        this.rowMeta = rowMeta;
        this.queryLimit = queryLimit;
        this.stopOnError = stopOnError;
        this.firstCall = true;
    }

    public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        if (this.firstCall) {
            this.tableModel = this.createTableModel(rowMeta);
            this.firstCall = false;
        }
        if (this.queryLimit > 0 && this.rowsWritten > this.queryLimit) {
            return;
        }
        try {
            ++this.rowsWritten;
            int count = this.tableModel.getColumnCount();
            Object[] dataRow = new Object[count];
            block13: for (int columnNo = 0; columnNo < count; ++columnNo) {
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(columnNo);
                switch (valueMeta.getType()) {
                    case 6: {
                        dataRow[columnNo] = rowMeta.getBigNumber(row, columnNo);
                        continue block13;
                    }
                    case 4: {
                        dataRow[columnNo] = rowMeta.getBoolean(row, columnNo);
                        continue block13;
                    }
                    case 3: {
                        dataRow[columnNo] = rowMeta.getDate(row, columnNo);
                        continue block13;
                    }
                    case 5: {
                        dataRow[columnNo] = rowMeta.getInteger(row, columnNo);
                        continue block13;
                    }
                    case 0: {
                        dataRow[columnNo] = rowMeta.getString(row, columnNo);
                        continue block13;
                    }
                    case 1: {
                        dataRow[columnNo] = rowMeta.getNumber(row, columnNo);
                        continue block13;
                    }
                    case 2: {
                        dataRow[columnNo] = rowMeta.getString(row, columnNo);
                        continue block13;
                    }
                    case 8: {
                        dataRow[columnNo] = rowMeta.getBinary(row, columnNo);
                        continue block13;
                    }
                    default: {
                        dataRow[columnNo] = rowMeta.getString(row, columnNo);
                    }
                }
            }
            this.tableModel.addRow(dataRow);
        }
        catch (KettleValueException kve) {
            throw new KettleStepException((Throwable)kve);
        }
        catch (Exception e) {
            throw new KettleStepException((Throwable)e);
        }
    }

    protected TypedTableModel createTableModel(RowMetaInterface rowMeta) {
        int colCount = rowMeta.size();
        String[] fieldNames = new String[colCount];
        Class[] fieldTypes = new Class[colCount];
        block10: for (int columnNo = 0; columnNo < colCount; ++columnNo) {
            ValueMetaInterface valueMeta = rowMeta.getValueMeta(columnNo);
            fieldNames[columnNo] = valueMeta.getName();
            switch (valueMeta.getType()) {
                case 6: {
                    fieldTypes[columnNo] = BigDecimal.class;
                    continue block10;
                }
                case 4: {
                    fieldTypes[columnNo] = Boolean.class;
                    continue block10;
                }
                case 3: {
                    fieldTypes[columnNo] = Date.class;
                    continue block10;
                }
                case 5: {
                    fieldTypes[columnNo] = Integer.class;
                    continue block10;
                }
                case 0: {
                    fieldTypes[columnNo] = String.class;
                    continue block10;
                }
                case 1: {
                    fieldTypes[columnNo] = Double.class;
                    continue block10;
                }
                case 2: {
                    fieldTypes[columnNo] = String.class;
                    continue block10;
                }
                case 8: {
                    fieldTypes[columnNo] = byte[].class;
                    continue block10;
                }
                default: {
                    fieldTypes[columnNo] = String.class;
                }
            }
        }
        return new TypedTableModel(fieldNames, fieldTypes);
    }

    public void rowReadEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
    }

    public void errorRowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        if (this.stopOnError) {
            throw new KettleStepException("Aborting transformation due to error detected");
        }
        this.error = true;
    }

    public TableModel getTableModel() throws ReportDataFactoryException {
        if (this.stopOnError && this.error) {
            throw new ReportDataFactoryException("Transformation produced an error.");
        }
        if (this.tableModel == null) {
            return this.createTableModel(this.rowMeta);
        }
        return this.tableModel;
    }
}

