/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.sampledata;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaDataParser;
import org.pentaho.reporting.engine.classic.extensions.datasources.sampledata.SampleDataModule;
import org.pentaho.reporting.libraries.base.boot.ModuleInitializeException;
import org.pentaho.reporting.libraries.base.boot.ModuleInitializer;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class SampleDataModuleInitializer
implements ModuleInitializer {
    private static final Log logger = LogFactory.getLog(SampleDataModuleInitializer.class);

    public void performInit() throws ModuleInitializeException {
        try {
            Driver driver = (Driver)ObjectUtilities.loadAndInstantiate((String)"org.hsqldb.jdbcDriver", SampleDataModuleInitializer.class, Driver.class);
            this.populateDatabase(driver);
        }
        catch (Exception e) {
            throw new ModuleInitializeException("Failed to load the HSQL-DB driver", (Throwable)e);
        }
        ElementMetaDataParser.initializeOptionalDataFactoryMetaData((String)"org/pentaho/reporting/engine/classic/extensions/datasources/sampledata/meta-datafactory.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateDatabase(Driver driver) throws SQLException, IOException {
        Properties p = new Properties();
        p.setProperty("user", "sa");
        p.setProperty("password", "");
        Connection connection = driver.connect("jdbc:hsqldb:mem:SampleData", p);
        connection.setAutoCommit(false);
        try {
            Configuration config = ClassicEngineBoot.getInstance().getGlobalConfig();
            String location = config.getConfigProperty("org.pentaho.reporting.engine.classic.extensions.datasources.sampledata.SampleDataLocation");
            InputStream in = SampleDataModule.class.getResourceAsStream(location);
            if (in == null) {
                logger.warn((Object)("Invalid database init-script specified. Sample database will be empty. [" + location + "]"));
                return;
            }
            InputStreamReader inReader = new InputStreamReader(in);
            BufferedReader bin = new BufferedReader(inReader);
            try {
                Statement statement = connection.createStatement();
                try {
                    String line;
                    while ((line = bin.readLine()) != null) {
                        if (line.startsWith("CREATE SCHEMA ") || line.startsWith("CREATE USER SA ") || line.startsWith("GRANT DBA TO SA")) continue;
                        statement.addBatch(StringEscapeUtils.unescapeJava((String)line));
                    }
                    statement.executeBatch();
                }
                finally {
                    statement.close();
                }
            }
            finally {
                bin.close();
            }
            connection.commit();
        }
        finally {
            connection.close();
        }
    }
}

