/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableMap;
import java.util.UUID;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.protobuf.ReplicationProtbufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationHLogReaderManager;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSinkManager;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSyncUp;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Private
public class ReplicationSource
extends Thread
implements ReplicationSourceInterface {
    public static final Log LOG = LogFactory.getLog(ReplicationSource.class);
    private PriorityBlockingQueue<Path> queue;
    private HConnection conn;
    private ReplicationQueues replicationQueues;
    private ReplicationPeers replicationPeers;
    private Configuration conf;
    private ReplicationQueueInfo replicationQueueInfo;
    private String peerId;
    private ReplicationSourceManager manager;
    private Stoppable stopper;
    private long sleepForRetries;
    private long replicationQueueSizeCapacity;
    private int replicationQueueNbCapacity;
    private HLog.Reader reader;
    private long lastLoggedPosition = -1L;
    private volatile Path currentPath;
    private FileSystem fs;
    private UUID clusterId;
    private UUID peerClusterId;
    private long totalReplicatedEdits = 0L;
    private long totalReplicatedOperations = 0L;
    private String peerClusterZnode;
    private int maxRetriesMultiplier;
    private int socketTimeoutMultiplier;
    private int currentNbOperations = 0;
    private int currentSize = 0;
    private volatile boolean running = true;
    private MetricsSource metrics;
    private ReplicationHLogReaderManager repLogReader;
    private ReplicationSinkManager replicationSinkMgr;
    private int logQueueWarnThreshold;

    @Override
    public void init(Configuration conf, FileSystem fs, ReplicationSourceManager manager, ReplicationQueues replicationQueues, ReplicationPeers replicationPeers, Stoppable stopper, String peerClusterZnode, UUID clusterId) throws IOException {
        this.stopper = stopper;
        this.conf = HBaseConfiguration.create((Configuration)conf);
        this.decorateConf();
        this.replicationQueueSizeCapacity = this.conf.getLong("replication.source.size.capacity", 0x4000000L);
        this.replicationQueueNbCapacity = this.conf.getInt("replication.source.nb.capacity", 25000);
        this.maxRetriesMultiplier = this.conf.getInt("replication.source.maxretriesmultiplier", 10);
        this.socketTimeoutMultiplier = this.conf.getInt("replication.source.socketTimeoutMultiplier", this.maxRetriesMultiplier * this.maxRetriesMultiplier);
        this.queue = new PriorityBlockingQueue<Path>(this.conf.getInt("hbase.regionserver.maxlogs", 32), new LogsComparator());
        this.conn = HConnectionManager.getConnection((Configuration)this.conf);
        this.replicationQueues = replicationQueues;
        this.replicationPeers = replicationPeers;
        this.manager = manager;
        this.sleepForRetries = this.conf.getLong("replication.source.sleepforretries", 1000L);
        this.fs = fs;
        this.metrics = new MetricsSource(peerClusterZnode);
        this.repLogReader = new ReplicationHLogReaderManager(this.fs, this.conf);
        this.clusterId = clusterId;
        this.peerClusterZnode = peerClusterZnode;
        this.replicationQueueInfo = new ReplicationQueueInfo(peerClusterZnode);
        this.peerId = this.replicationQueueInfo.getPeerId();
        this.replicationSinkMgr = new ReplicationSinkManager(this.conn, this.peerId, replicationPeers, this.conf);
        this.logQueueWarnThreshold = this.conf.getInt("replication.source.log.queue.warn", 2);
    }

    private void decorateConf() {
        String replicationCodec = this.conf.get("hbase.replication.rpc.codec");
        if (StringUtils.isNotEmpty((String)replicationCodec)) {
            this.conf.set("hbase.client.rpc.codec", replicationCodec);
        }
    }

    @Override
    public void enqueueLog(Path log) {
        this.queue.put(log);
        int queueSize = this.queue.size();
        this.metrics.setSizeOfLogQueue(queueSize);
        if (queueSize > this.logQueueWarnThreshold) {
            LOG.warn((Object)("Queue size: " + queueSize + " exceeds value of replication.source.log.queue.warn: " + this.logQueueWarnThreshold));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.connectToPeers();
        if (!this.isActive()) {
            this.metrics.clear();
            return;
        }
        int sleepMultiplier = 1;
        while (this.peerClusterId == null) {
            this.peerClusterId = this.replicationPeers.getPeerUUID(this.peerId);
            if (this.peerClusterId != null || !this.sleepForRetries("Cannot contact the peer's zk ensemble", sleepMultiplier)) continue;
            ++sleepMultiplier;
        }
        sleepMultiplier = 1;
        if (this.clusterId.equals(this.peerClusterId)) {
            this.terminate("ClusterId " + this.clusterId + " is replicating to itself: peerClusterId " + this.peerClusterId);
        }
        LOG.info((Object)("Replicating " + this.clusterId + " -> " + this.peerClusterId));
        if (this.replicationQueueInfo.isQueueRecovered()) {
            try {
                this.repLogReader.setPosition(this.replicationQueues.getLogPosition(this.peerClusterZnode, this.queue.peek().getName()));
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Recovered queue started with log " + this.queue.peek() + " at position " + this.repLogReader.getPosition()));
                }
            }
            catch (ReplicationException e) {
                this.terminate("Couldn't get the position of this recovered queue " + this.peerClusterZnode, (Exception)((Object)e));
            }
        }
        while (this.isActive()) {
            ArrayList<HLog.Entry> entries;
            boolean gotIOE;
            boolean currentWALisBeingWrittenTo;
            block41: {
                if (!this.isPeerEnabled()) {
                    if (!this.sleepForRetries("Replication is disabled", sleepMultiplier)) continue;
                    ++sleepMultiplier;
                    continue;
                }
                Path oldPath = this.getCurrentPath();
                boolean hasCurrentPath = this.getNextPath();
                if (this.getCurrentPath() != null && oldPath == null) {
                    sleepMultiplier = 1;
                }
                if (!hasCurrentPath) {
                    if (!this.sleepForRetries("No log to process", sleepMultiplier)) continue;
                    ++sleepMultiplier;
                    continue;
                }
                currentWALisBeingWrittenTo = false;
                if (!this.replicationQueueInfo.isQueueRecovered() && this.queue.size() == 0) {
                    currentWALisBeingWrittenTo = true;
                }
                if (!this.openReader(sleepMultiplier)) {
                    sleepMultiplier = 1;
                    continue;
                }
                if (this.reader == null) {
                    if (!this.sleepForRetries("Unable to open a reader", sleepMultiplier)) continue;
                    ++sleepMultiplier;
                    continue;
                }
                gotIOE = false;
                this.currentNbOperations = 0;
                entries = new ArrayList<HLog.Entry>(1);
                this.currentSize = 0;
                try {
                    if (this.readAllEntriesToReplicateOrNextFile(currentWALisBeingWrittenTo, entries)) {
                        continue;
                    }
                }
                catch (IOException ioe) {
                    LOG.warn((Object)(this.peerClusterZnode + " Got: "), (Throwable)ioe);
                    gotIOE = true;
                    if (!(ioe.getCause() instanceof EOFException)) break block41;
                    boolean considerDumping = false;
                    if (this.replicationQueueInfo.isQueueRecovered()) {
                        try {
                            FileStatus stat = this.fs.getFileStatus(this.currentPath);
                            if (stat.getLen() == 0L) {
                                LOG.warn((Object)(this.peerClusterZnode + " Got EOF and the file was empty"));
                            }
                            considerDumping = true;
                        }
                        catch (IOException e) {
                            LOG.warn((Object)(this.peerClusterZnode + " Got while getting file size: "), (Throwable)e);
                        }
                    }
                    if (considerDumping && sleepMultiplier == this.maxRetriesMultiplier && this.processEndOfFile()) {
                        continue;
                    }
                }
                finally {
                    try {
                        this.reader = null;
                        this.repLogReader.closeReader();
                    }
                    catch (IOException e) {
                        gotIOE = true;
                        LOG.warn((Object)"Unable to finalize the tailing of a file", (Throwable)e);
                    }
                    continue;
                }
            }
            if (this.isActive() && (gotIOE || entries.isEmpty())) {
                if (this.lastLoggedPosition != this.repLogReader.getPosition()) {
                    this.manager.logPositionAndCleanOldLogs(this.currentPath, this.peerClusterZnode, this.repLogReader.getPosition(), this.replicationQueueInfo.isQueueRecovered(), currentWALisBeingWrittenTo);
                    this.lastLoggedPosition = this.repLogReader.getPosition();
                }
                if (!gotIOE) {
                    sleepMultiplier = 1;
                }
                if (!this.sleepForRetries("Nothing to replicate", sleepMultiplier)) continue;
                ++sleepMultiplier;
                continue;
            }
            sleepMultiplier = 1;
            this.shipEdits(currentWALisBeingWrittenTo, entries);
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (IOException e) {
                LOG.debug((Object)"Attempt to close connection failed", (Throwable)e);
            }
        }
        LOG.debug((Object)("Source exiting " + this.peerId));
        this.metrics.clear();
    }

    protected boolean readAllEntriesToReplicateOrNextFile(boolean currentWALisBeingWrittenTo, List<HLog.Entry> entries) throws IOException {
        long seenEntries = 0L;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Seeking in " + this.currentPath + " at position " + this.repLogReader.getPosition()));
        }
        this.repLogReader.seek();
        long positionBeforeRead = this.repLogReader.getPosition();
        HLog.Entry entry = this.repLogReader.readNextAndSetPosition();
        while (entry != null) {
            WALEdit edit = entry.getEdit();
            this.metrics.incrLogEditsRead();
            ++seenEntries;
            HLogKey logKey = entry.getKey();
            if (!logKey.getClusterIds().contains(this.peerClusterId)) {
                this.removeNonReplicableEdits(entry);
                if (!logKey.getTablename().equals((Object)TableName.META_TABLE_NAME) && edit.size() != 0) {
                    logKey.addClusterId(this.clusterId);
                    this.currentNbOperations += this.countDistinctRowKeys(edit);
                    entries.add(entry);
                    this.currentSize = (int)((long)this.currentSize + entry.getEdit().heapSize());
                } else {
                    this.metrics.incrLogEditsFiltered();
                }
            }
            if ((long)this.currentSize >= this.replicationQueueSizeCapacity || entries.size() >= this.replicationQueueNbCapacity) break;
            try {
                entry = this.repLogReader.readNextAndSetPosition();
            }
            catch (IOException ie) {
                LOG.debug((Object)("Break on IOE: " + ie.getMessage()));
                break;
            }
        }
        this.metrics.incrLogReadInBytes(this.repLogReader.getPosition() - positionBeforeRead);
        if (currentWALisBeingWrittenTo) {
            return false;
        }
        return seenEntries == 0L && this.processEndOfFile();
    }

    private void connectToPeers() {
        int sleepMultiplier = 1;
        while (this.isActive() && this.replicationSinkMgr.getSinks().size() == 0) {
            this.replicationSinkMgr.chooseSinks();
            if (!this.isActive() || this.replicationSinkMgr.getSinks().size() != 0 || !this.sleepForRetries("Waiting for peers", sleepMultiplier)) continue;
            ++sleepMultiplier;
        }
    }

    protected boolean getNextPath() {
        try {
            if (this.currentPath == null) {
                this.currentPath = this.queue.poll(this.sleepForRetries, TimeUnit.MILLISECONDS);
                this.metrics.setSizeOfLogQueue(this.queue.size());
                if (this.currentPath != null) {
                    this.manager.cleanOldLogs(this.currentPath.getName(), this.peerId, this.replicationQueueInfo.isQueueRecovered());
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("New log: " + this.currentPath));
                    }
                }
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Interrupted while reading edits", (Throwable)e);
        }
        return this.currentPath != null;
    }

    protected boolean openReader(int sleepMultiplier) {
        block14: {
            try {
                try {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Opening log " + this.currentPath));
                    }
                    this.reader = this.repLogReader.openReader(this.currentPath);
                }
                catch (FileNotFoundException fnfe) {
                    if (this.replicationQueueInfo.isQueueRecovered()) {
                        List deadRegionServers = this.replicationQueueInfo.getDeadRegionServers();
                        LOG.info((Object)("NB dead servers : " + deadRegionServers.size()));
                        for (String curDeadServerName : deadRegionServers) {
                            Path[] locs;
                            Path deadRsDirectory = new Path(this.manager.getLogDir().getParent(), curDeadServerName);
                            for (Path possibleLogLocation : locs = new Path[]{new Path(deadRsDirectory, this.currentPath.getName()), new Path(deadRsDirectory.suffix("-splitting"), this.currentPath.getName())}) {
                                LOG.info((Object)("Possible location " + possibleLogLocation.toUri().toString()));
                                if (!this.manager.getFs().exists(possibleLogLocation)) continue;
                                LOG.info((Object)("Log " + this.currentPath + " still exists at " + possibleLogLocation));
                                return true;
                            }
                        }
                        if (this.stopper instanceof ReplicationSyncUp.DummyServer) {
                            FileStatus[] rss;
                            for (FileStatus rs : rss = this.fs.listStatus(this.manager.getLogDir())) {
                                FileStatus[] logs;
                                Path p = rs.getPath();
                                for (FileStatus log : logs = this.fs.listStatus(p)) {
                                    if (!(p = new Path(p, log.getPath().getName())).getName().equals(this.currentPath.getName())) continue;
                                    this.currentPath = p;
                                    LOG.info((Object)("Log " + this.currentPath + " exists under " + this.manager.getLogDir()));
                                    this.openReader(sleepMultiplier);
                                    return true;
                                }
                            }
                        }
                        throw new IOException("File from recovered queue is nowhere to be found", fnfe);
                    }
                    Path archivedLogLocation = new Path(this.manager.getOldLogDir(), this.currentPath.getName());
                    if (this.manager.getFs().exists(archivedLogLocation)) {
                        this.currentPath = archivedLogLocation;
                        LOG.info((Object)("Log " + this.currentPath + " was moved to " + archivedLogLocation));
                        this.openReader(sleepMultiplier);
                    }
                }
            }
            catch (IOException ioe) {
                if (ioe instanceof EOFException && this.isCurrentLogEmpty()) {
                    return true;
                }
                LOG.warn((Object)(this.peerClusterZnode + " Got: "), (Throwable)ioe);
                this.reader = null;
                if (ioe.getCause() instanceof NullPointerException) {
                    LOG.warn((Object)"Got NPE opening reader, will retry.");
                }
                if (sleepMultiplier != this.maxRetriesMultiplier) break block14;
                LOG.warn((Object)"Waited too long for this file, considering dumping");
                return !this.processEndOfFile();
            }
        }
        return true;
    }

    private boolean isCurrentLogEmpty() {
        return this.repLogReader.getPosition() == 0L && !this.replicationQueueInfo.isQueueRecovered() && this.queue.size() == 0;
    }

    protected boolean sleepForRetries(String msg, int sleepMultiplier) {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(msg + ", sleeping " + this.sleepForRetries + " times " + sleepMultiplier));
            }
            Thread.sleep(this.sleepForRetries * (long)sleepMultiplier);
        }
        catch (InterruptedException e) {
            LOG.debug((Object)"Interrupted while sleeping between retries");
        }
        return sleepMultiplier < this.maxRetriesMultiplier;
    }

    protected void removeNonReplicableEdits(HLog.Entry entry) {
        NavigableMap<byte[], Integer> scopes = entry.getKey().getScopes();
        ArrayList<KeyValue> kvs = entry.getEdit().getKeyValues();
        int size = kvs.size();
        for (int i = size - 1; i >= 0; --i) {
            KeyValue kv = kvs.get(i);
            if (scopes != null && scopes.containsKey(kv.getFamily())) continue;
            kvs.remove(i);
        }
        if (kvs.size() < size / 2) {
            kvs.trimToSize();
        }
    }

    private int countDistinctRowKeys(WALEdit edit) {
        ArrayList<KeyValue> kvs = edit.getKeyValues();
        int distinctRowKeys = 1;
        KeyValue lastKV = (KeyValue)kvs.get(0);
        for (int i = 0; i < edit.size(); ++i) {
            if (((KeyValue)kvs.get(i)).matchingRow(lastKV)) continue;
            ++distinctRowKeys;
        }
        return distinctRowKeys;
    }

    protected void shipEdits(boolean currentWALisBeingWrittenTo, List<HLog.Entry> entries) {
        int sleepMultiplier = 1;
        if (entries.isEmpty()) {
            LOG.warn((Object)"Was given 0 edits to ship");
            return;
        }
        while (this.isActive()) {
            if (!this.isPeerEnabled()) {
                if (!this.sleepForRetries("Replication is disabled", sleepMultiplier)) continue;
                ++sleepMultiplier;
                continue;
            }
            ReplicationSinkManager.SinkPeer sinkPeer = null;
            try {
                sinkPeer = this.replicationSinkMgr.getReplicationSink();
                AdminProtos.AdminService.BlockingInterface rrs = sinkPeer.getRegionServer();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Replicating " + entries.size() + " entries of total size " + this.currentSize));
                }
                ReplicationProtbufUtil.replicateWALEntry(rrs, entries.toArray(new HLog.Entry[entries.size()]));
                if (this.lastLoggedPosition != this.repLogReader.getPosition()) {
                    this.manager.logPositionAndCleanOldLogs(this.currentPath, this.peerClusterZnode, this.repLogReader.getPosition(), this.replicationQueueInfo.isQueueRecovered(), currentWALisBeingWrittenTo);
                    this.lastLoggedPosition = this.repLogReader.getPosition();
                }
                this.totalReplicatedEdits += (long)entries.size();
                this.totalReplicatedOperations += (long)this.currentNbOperations;
                this.metrics.shipBatch(this.currentNbOperations);
                this.metrics.setAgeOfLastShippedOp(entries.get(entries.size() - 1).getKey().getWriteTime());
                if (!LOG.isTraceEnabled()) break;
                LOG.trace((Object)("Replicated " + this.totalReplicatedEdits + " entries in total, or " + this.totalReplicatedOperations + " operations"));
                break;
            }
            catch (IOException ioe) {
                this.metrics.refreshAgeOfLastShippedOp();
                if (ioe instanceof RemoteException) {
                    ioe = ((RemoteException)ioe).unwrapRemoteException();
                    LOG.warn((Object)"Can't replicate because of an error on the remote cluster: ", (Throwable)ioe);
                    if (ioe instanceof TableNotFoundException && this.sleepForRetries("A table is missing in the peer cluster. Replication cannot proceed without losing data.", sleepMultiplier)) {
                        ++sleepMultiplier;
                    }
                } else if (ioe instanceof SocketTimeoutException) {
                    this.sleepForRetries("Encountered a SocketTimeoutException. Since the call to the remote cluster timed out, which is usually caused by a machine failure or a massive slowdown", this.socketTimeoutMultiplier);
                } else if (ioe instanceof ConnectException) {
                    LOG.warn((Object)"Peer is unavailable, rechecking all sinks: ", (Throwable)ioe);
                    this.replicationSinkMgr.chooseSinks();
                } else {
                    LOG.warn((Object)"Can't replicate because of a local or network error: ", (Throwable)ioe);
                }
                if (sinkPeer != null) {
                    this.replicationSinkMgr.reportBadSink(sinkPeer);
                }
                if (!this.sleepForRetries("Since we are unable to replicate", sleepMultiplier)) continue;
                ++sleepMultiplier;
            }
        }
    }

    protected boolean isPeerEnabled() {
        return this.replicationPeers.getStatusOfConnectedPeer(this.peerId);
    }

    protected boolean processEndOfFile() {
        if (this.queue.size() != 0) {
            if (LOG.isTraceEnabled()) {
                String filesize = "N/A";
                try {
                    FileStatus stat = this.fs.getFileStatus(this.currentPath);
                    filesize = stat.getLen() + "";
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                LOG.trace((Object)("Reached the end of a log, stats: " + this.getStats() + ", and the length of the file is " + filesize));
            }
            this.currentPath = null;
            this.repLogReader.finishCurrentFile();
            this.reader = null;
            return true;
        }
        if (this.replicationQueueInfo.isQueueRecovered()) {
            this.manager.closeRecoveredQueue(this);
            LOG.info((Object)("Finished recovering the queue with the following stats " + this.getStats()));
            this.running = false;
            return true;
        }
        return false;
    }

    @Override
    public void startup() {
        String n = Thread.currentThread().getName();
        Thread.UncaughtExceptionHandler handler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOG.error((Object)("Unexpected exception in ReplicationSource, currentPath=" + ReplicationSource.this.currentPath), e);
            }
        };
        Threads.setDaemonThreadRunning((Thread)this, (String)(n + ".replicationSource," + this.peerClusterZnode), (Thread.UncaughtExceptionHandler)handler);
    }

    @Override
    public void terminate(String reason) {
        this.terminate(reason, null);
    }

    @Override
    public void terminate(String reason, Exception cause) {
        if (cause == null) {
            LOG.info((Object)("Closing source " + this.peerClusterZnode + " because: " + reason));
        } else {
            LOG.error((Object)("Closing source " + this.peerClusterZnode + " because an error occurred: " + reason), (Throwable)cause);
        }
        this.running = false;
        Threads.shutdown((Thread)this, (long)this.sleepForRetries);
    }

    @Override
    public String getPeerClusterZnode() {
        return this.peerClusterZnode;
    }

    @Override
    public String getPeerClusterId() {
        return this.peerId;
    }

    @Override
    public Path getCurrentPath() {
        return this.currentPath;
    }

    private boolean isActive() {
        return !this.stopper.isStopped() && this.running;
    }

    @Override
    public String getStats() {
        long position = this.repLogReader.getPosition();
        return "Total replicated edits: " + this.totalReplicatedEdits + ", currently replicating from: " + this.currentPath + " at position: " + position;
    }

    public static class LogsComparator
    implements Comparator<Path> {
        @Override
        public int compare(Path o1, Path o2) {
            return Long.valueOf(this.getTS(o1)).compareTo(this.getTS(o2));
        }

        private long getTS(Path p) {
            String[] parts = p.getName().split("\\.");
            return Long.parseLong(parts[parts.length - 1]);
        }
    }
}

