/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public class DeletionAwareConstantScoreQuery
extends ConstantScoreQuery {
    public DeletionAwareConstantScoreQuery(Filter filter) {
        super(filter);
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new DeletionConstantWeight(searcher);
    }

    protected class DeletionConstantScorer
    extends ConstantScoreQuery.ConstantScorer {
        private final IndexReader reader;
        private int doc;

        public DeletionConstantScorer(IndexReader reader, Similarity similarity, DocIdSetIterator docIdSetIterator, Weight w) throws IOException {
            super((ConstantScoreQuery)DeletionAwareConstantScoreQuery.this, similarity, docIdSetIterator, w);
            this.doc = -1;
            this.reader = reader;
        }

        public int nextDoc() throws IOException {
            while ((this.doc = this.docIdSetIterator.nextDoc()) != Integer.MAX_VALUE) {
                if (this.reader.isDeleted(this.doc)) continue;
                return this.doc;
            }
            return this.doc;
        }

        public int docID() {
            return this.doc;
        }

        public int advance(int target) throws IOException {
            this.doc = this.docIdSetIterator.advance(target);
            if (this.doc != Integer.MAX_VALUE) {
                if (!this.reader.isDeleted(this.doc)) {
                    return this.doc;
                }
                while ((this.doc = this.docIdSetIterator.nextDoc()) != Integer.MAX_VALUE) {
                    if (this.reader.isDeleted(this.doc)) continue;
                    return this.doc;
                }
                return this.doc;
            }
            return this.doc;
        }
    }

    protected class DeletionConstantWeight
    extends ConstantScoreQuery.ConstantWeight {
        private final Similarity similarity;

        public DeletionConstantWeight(Searcher searcher) throws IOException {
            super((ConstantScoreQuery)DeletionAwareConstantScoreQuery.this, searcher);
            this.similarity = DeletionAwareConstantScoreQuery.this.getSimilarity(searcher);
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            DocIdSet dis = DeletionAwareConstantScoreQuery.this.filter.getDocIdSet(reader);
            if (dis == null) {
                return null;
            }
            DocIdSetIterator disi = dis.iterator();
            if (disi == null) {
                return null;
            }
            return new DeletionConstantScorer(reader, this.similarity, disi, (Weight)this);
        }
    }
}

