/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;

public class Actions {
    public static ActionRequestValidationException addValidationError(String error, ActionRequestValidationException validationException) {
        if (validationException == null) {
            validationException = new ActionRequestValidationException();
        }
        validationException.addValidationError(error);
        return validationException;
    }

    public static boolean isAllNodes(String ... nodesIds) {
        return nodesIds == null || nodesIds.length == 0 || nodesIds.length == 1 && nodesIds[0].equals("_all");
    }

    public static String[] buildNodesIds(DiscoveryNodes nodes, String ... nodesIds) {
        if (Actions.isAllNodes(nodesIds)) {
            int index = 0;
            nodesIds = new String[nodes.size()];
            for (DiscoveryNode node : nodes) {
                nodesIds[index++] = node.id();
            }
            return nodesIds;
        }
        String[] resolvedNodesIds = new String[nodesIds.length];
        for (int i = 0; i < nodesIds.length; ++i) {
            resolvedNodesIds[i] = nodesIds[i].equals("_local") ? nodes.localNodeId() : (nodesIds[i].equals("_master") ? nodes.masterNodeId() : nodesIds[i]);
        }
        return resolvedNodesIds;
    }
}

