/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.delete;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.Actions;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public class DeleteIndexTemplateRequest
extends MasterNodeOperationRequest {
    private String name;
    private TimeValue timeout = TimeValue.timeValueSeconds(10L);

    DeleteIndexTemplateRequest() {
    }

    public DeleteIndexTemplateRequest(String name) {
        this.name = name;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.name == null) {
            validationException = Actions.addValidationError("name is missing", validationException);
        }
        return validationException;
    }

    String name() {
        return this.name;
    }

    TimeValue timeout() {
        return this.timeout;
    }

    public DeleteIndexTemplateRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public DeleteIndexTemplateRequest timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue(timeout, null));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.name = in.readUTF();
        this.timeout = TimeValue.readTimeValue(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeUTF(this.name);
        this.timeout.writeTo(out);
    }
}

