/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.BaseAction;
import org.elasticsearch.action.support.replication.IndexReplicationOperationRequest;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.action.support.replication.TransportShardReplicationOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportService;

public abstract class TransportIndexReplicationOperationAction<Request extends IndexReplicationOperationRequest, Response extends ActionResponse, ShardRequest extends ShardReplicationOperationRequest, ShardResponse extends ActionResponse>
extends BaseAction<Request, Response> {
    protected final ClusterService clusterService;
    protected final TransportShardReplicationOperationAction<ShardRequest, ShardResponse> shardAction;

    @Inject
    public TransportIndexReplicationOperationAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, TransportShardReplicationOperationAction<ShardRequest, ShardResponse> shardAction) {
        super(settings, threadPool);
        this.clusterService = clusterService;
        this.shardAction = shardAction;
        transportService.registerHandler(this.transportAction(), new TransportHandler());
    }

    @Override
    protected void doExecute(Request request, final ActionListener<Response> listener) {
        GroupShardsIterator groups;
        ClusterState clusterState = this.clusterService.state();
        ((IndexReplicationOperationRequest)request).index(clusterState.metaData().concreteIndex(((IndexReplicationOperationRequest)request).index()));
        this.checkBlock(request, clusterState);
        try {
            groups = this.shards(request);
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        final AtomicInteger indexCounter = new AtomicInteger();
        final AtomicInteger completionCounter = new AtomicInteger(groups.size());
        final AtomicReferenceArray shardsResponses = new AtomicReferenceArray(groups.size());
        for (ShardIterator shardIt : groups) {
            ShardRequest shardRequest = this.newShardRequestInstance(request, shardIt.shardId().id());
            ((ShardReplicationOperationRequest)shardRequest).beforeLocalFork();
            ((ShardReplicationOperationRequest)shardRequest).operationThreaded(true);
            ((ShardReplicationOperationRequest)shardRequest).listenerThreaded(false);
            this.shardAction.execute(shardRequest, new ActionListener<ShardResponse>((IndexReplicationOperationRequest)request){
                final /* synthetic */ IndexReplicationOperationRequest val$request;
                {
                    this.val$request = indexReplicationOperationRequest;
                }

                @Override
                public void onResponse(ShardResponse result) {
                    shardsResponses.set(indexCounter.getAndIncrement(), result);
                    if (completionCounter.decrementAndGet() == 0) {
                        listener.onResponse(TransportIndexReplicationOperationAction.this.newResponseInstance(this.val$request, shardsResponses));
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    int index = indexCounter.getAndIncrement();
                    if (TransportIndexReplicationOperationAction.this.accumulateExceptions()) {
                        shardsResponses.set(index, e);
                    }
                    if (completionCounter.decrementAndGet() == 0) {
                        listener.onResponse(TransportIndexReplicationOperationAction.this.newResponseInstance(this.val$request, shardsResponses));
                    }
                }
            });
        }
    }

    protected abstract Request newRequestInstance();

    protected abstract Response newResponseInstance(Request var1, AtomicReferenceArray var2);

    protected abstract String transportAction();

    protected abstract GroupShardsIterator shards(Request var1) throws ElasticSearchException;

    protected abstract ShardRequest newShardRequestInstance(Request var1, int var2);

    protected abstract boolean accumulateExceptions();

    protected void checkBlock(Request request, ClusterState state) {
    }

    private class TransportHandler
    extends BaseTransportRequestHandler<Request> {
        private TransportHandler() {
        }

        @Override
        public Request newInstance() {
            return TransportIndexReplicationOperationAction.this.newRequestInstance();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            ((IndexReplicationOperationRequest)request).listenerThreaded(false);
            TransportIndexReplicationOperationAction.this.execute(request, new ActionListener<Response>((IndexReplicationOperationRequest)request){
                final /* synthetic */ IndexReplicationOperationRequest val$request;
                {
                    this.val$request = indexReplicationOperationRequest;
                }

                @Override
                public void onResponse(Response result) {
                    try {
                        channel.sendResponse((Streamable)result);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportIndexReplicationOperationAction.this.logger.warn("Failed to send error response for action [" + TransportIndexReplicationOperationAction.this.transportAction() + "] and request [" + this.val$request + "]", e1, new Object[0]);
                    }
                }
            });
        }
    }
}

