/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.NodeAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class ClusterRebalanceNodeAllocation
extends NodeAllocation {
    private final ClusterRebalanceType type;

    @Inject
    public ClusterRebalanceNodeAllocation(Settings settings) {
        super(settings);
        String allowRebalance = this.componentSettings.get("allow_rebalance", "indices_all_active");
        if ("always".equalsIgnoreCase(allowRebalance)) {
            this.type = ClusterRebalanceType.ALWAYS;
        } else if ("indices_primaries_active".equalsIgnoreCase(allowRebalance) || "indicesPrimariesActive".equalsIgnoreCase(allowRebalance)) {
            this.type = ClusterRebalanceType.INDICES_PRIMARIES_ACTIVE;
        } else if ("indices_all_active".equalsIgnoreCase(allowRebalance) || "indicesAllActive".equalsIgnoreCase(allowRebalance)) {
            this.type = ClusterRebalanceType.INDICES_ALL_ACTIVE;
        } else {
            this.logger.warn("[cluster.routing.allocation.allow_rebalance] has a wrong value {}, defaulting to 'indices_all_active'", allowRebalance);
            this.type = ClusterRebalanceType.INDICES_ALL_ACTIVE;
        }
        this.logger.debug("using [allow_rebalance] with [{}]", this.type.toString().toLowerCase());
    }

    @Override
    public boolean canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        if (this.type == ClusterRebalanceType.INDICES_PRIMARIES_ACTIVE) {
            for (MutableShardRouting shard : allocation.routingNodes().unassigned()) {
                if (!shard.primary()) continue;
                return false;
            }
            for (RoutingNode node : allocation.routingNodes()) {
                for (MutableShardRouting shard : node) {
                    if (!shard.primary() || shard.active()) continue;
                    return false;
                }
            }
            return true;
        }
        if (this.type == ClusterRebalanceType.INDICES_ALL_ACTIVE) {
            if (!allocation.routingNodes().unassigned().isEmpty()) {
                return false;
            }
            for (RoutingNode node : allocation.routingNodes()) {
                for (MutableShardRouting shard : node) {
                    if (shard.active()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static enum ClusterRebalanceType {
        ALWAYS,
        INDICES_PRIMARIES_ACTIVE,
        INDICES_ALL_ACTIVE;

    }
}

