/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.aopalliance.intercept.MethodInterceptor;
import org.elasticsearch.common.inject.internal.Preconditions;
import org.elasticsearch.common.inject.matcher.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodAspect {
    final Matcher<? super Class<?>> classMatcher;
    final Matcher<? super Method> methodMatcher;
    final List<MethodInterceptor> interceptors;

    MethodAspect(Matcher<? super Class<?>> classMatcher, Matcher<? super Method> methodMatcher, List<MethodInterceptor> interceptors) {
        this.classMatcher = Preconditions.checkNotNull(classMatcher, "class matcher");
        this.methodMatcher = Preconditions.checkNotNull(methodMatcher, "method matcher");
        this.interceptors = Preconditions.checkNotNull(interceptors, "interceptors");
    }

    MethodAspect(Matcher<? super Class<?>> classMatcher, Matcher<? super Method> methodMatcher, MethodInterceptor ... interceptors) {
        this(classMatcher, methodMatcher, Arrays.asList(interceptors));
    }

    boolean matches(Class<?> clazz) {
        return this.classMatcher.matches(clazz);
    }

    boolean matches(Method method) {
        return this.methodMatcher.matches(method);
    }

    List<MethodInterceptor> interceptors() {
        return this.interceptors;
    }
}

