/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.DocSets;

public class FilteredCollector
extends Collector {
    private final Collector collector;
    private final Filter filter;
    private DocSet docSet;

    public FilteredCollector(Collector collector, Filter filter) {
        this.collector = collector;
        this.filter = filter;
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.collector.setScorer(scorer);
    }

    public void collect(int doc) throws IOException {
        if (this.docSet.get(doc)) {
            this.collector.collect(doc);
        }
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.collector.setNextReader(reader, docBase);
        this.docSet = DocSets.convert(reader, this.filter.getDocIdSet(reader));
    }

    public boolean acceptsDocsOutOfOrder() {
        return this.collector.acceptsDocsOutOfOrder();
    }
}

