/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.channel.local;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketAddress;
import org.elasticsearch.common.netty.channel.AbstractChannelSink;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelEvent;
import org.elasticsearch.common.netty.channel.ChannelException;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.ChannelState;
import org.elasticsearch.common.netty.channel.ChannelStateEvent;
import org.elasticsearch.common.netty.channel.Channels;
import org.elasticsearch.common.netty.channel.MessageEvent;
import org.elasticsearch.common.netty.channel.local.DefaultLocalChannel;
import org.elasticsearch.common.netty.channel.local.DefaultLocalServerChannel;
import org.elasticsearch.common.netty.channel.local.LocalAddress;
import org.elasticsearch.common.netty.channel.local.LocalChannelRegistry;
import org.elasticsearch.common.netty.logging.InternalLogger;
import org.elasticsearch.common.netty.logging.InternalLoggerFactory;

final class LocalClientChannelSink
extends AbstractChannelSink {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(LocalClientChannelSink.class);

    LocalClientChannelSink() {
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e;
            DefaultLocalChannel channel = (DefaultLocalChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            ChannelState state = event.getState();
            Object value = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    channel.closeNow(future);
                    break;
                }
                case BOUND: {
                    if (value != null) {
                        this.bind(channel, future, (LocalAddress)value);
                        break;
                    }
                    channel.closeNow(future);
                    break;
                }
                case CONNECTED: {
                    if (value != null) {
                        this.connect(channel, future, (LocalAddress)value);
                        break;
                    }
                    channel.closeNow(future);
                    break;
                }
                case INTEREST_OPS: {
                    future.setSuccess();
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            DefaultLocalChannel channel = (DefaultLocalChannel)event.getChannel();
            boolean offered = channel.writeBuffer.offer(event);
            assert (offered);
            channel.flushWriteBuffer();
        }
    }

    private void bind(DefaultLocalChannel channel, ChannelFuture future, LocalAddress localAddress) {
        try {
            if (!LocalChannelRegistry.register(localAddress, channel)) {
                throw new ChannelException("address already in use: " + localAddress);
            }
            channel.setBound();
            channel.localAddress = localAddress;
            future.setSuccess();
            Channels.fireChannelBound(channel, (SocketAddress)localAddress);
        }
        catch (Throwable t) {
            LocalChannelRegistry.unregister(localAddress);
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    private void connect(DefaultLocalChannel channel, ChannelFuture future, LocalAddress remoteAddress) {
        DefaultLocalChannel acceptedChannel;
        ChannelPipeline pipeline;
        Channel remoteChannel = LocalChannelRegistry.getChannel(remoteAddress);
        if (!(remoteChannel instanceof DefaultLocalServerChannel)) {
            future.setFailure(new ConnectException("connection refused"));
            return;
        }
        DefaultLocalServerChannel serverChannel = (DefaultLocalServerChannel)remoteChannel;
        try {
            pipeline = serverChannel.getConfig().getPipelineFactory().getPipeline();
        }
        catch (Exception e) {
            future.setFailure(e);
            Channels.fireExceptionCaught(channel, (Throwable)e);
            logger.warn("Failed to initialize an accepted socket.", e);
            return;
        }
        future.setSuccess();
        channel.pairedChannel = acceptedChannel = new DefaultLocalChannel(serverChannel, serverChannel.getFactory(), pipeline, this, channel);
        this.bind(channel, Channels.succeededFuture(channel), new LocalAddress("ephemeral"));
        channel.remoteAddress = serverChannel.getLocalAddress();
        channel.setConnected();
        Channels.fireChannelConnected(channel, (SocketAddress)serverChannel.getLocalAddress());
        acceptedChannel.localAddress = serverChannel.getLocalAddress();
        try {
            acceptedChannel.setBound();
        }
        catch (IOException e) {
            throw new Error(e);
        }
        Channels.fireChannelBound(acceptedChannel, (SocketAddress)channel.getRemoteAddress());
        acceptedChannel.remoteAddress = channel.getLocalAddress();
        acceptedChannel.setConnected();
        Channels.fireChannelConnected(acceptedChannel, (SocketAddress)channel.getLocalAddress());
        channel.flushWriteBuffer();
        acceptedChannel.flushWriteBuffer();
    }
}

