/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.channel.socket.http;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.SocketAddress;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelFactory;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.ChannelFutureListener;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.Channels;
import org.elasticsearch.common.netty.channel.ExceptionEvent;
import org.elasticsearch.common.netty.channel.MessageEvent;
import org.elasticsearch.common.netty.channel.SimpleChannelUpstreamHandler;
import org.elasticsearch.common.netty.channel.local.DefaultLocalClientChannelFactory;
import org.elasticsearch.common.netty.channel.local.LocalAddress;
import org.elasticsearch.common.netty.logging.InternalLogger;
import org.elasticsearch.common.netty.logging.InternalLoggerFactory;

public class HttpTunnelingServlet
extends HttpServlet {
    private static final long serialVersionUID = 4259910275899756070L;
    private static final String ENDPOINT = "endpoint";
    static final InternalLogger logger = InternalLoggerFactory.getInstance(HttpTunnelingServlet.class);
    private volatile SocketAddress remoteAddress;
    private volatile ChannelFactory channelFactory;

    public void init() throws ServletException {
        ServletConfig config = this.getServletConfig();
        String endpoint = config.getInitParameter(ENDPOINT);
        if (endpoint == null) {
            throw new ServletException("init-param 'endpoint' must be specified.");
        }
        try {
            this.remoteAddress = this.parseEndpoint(endpoint.trim());
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException("Failed to parse an endpoint.", (Throwable)e);
        }
        try {
            this.channelFactory = this.createChannelFactory(this.remoteAddress);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException("Failed to create a channel factory.", (Throwable)e);
        }
    }

    protected SocketAddress parseEndpoint(String endpoint) throws Exception {
        if (endpoint.startsWith("local:")) {
            return new LocalAddress(endpoint.substring(6).trim());
        }
        throw new ServletException("Invalid or unknown endpoint: " + endpoint);
    }

    protected ChannelFactory createChannelFactory(SocketAddress remoteAddress) throws Exception {
        if (remoteAddress instanceof LocalAddress) {
            return new DefaultLocalClientChannelFactory();
        }
        throw new ServletException("Unsupported remote address type: " + remoteAddress.getClass().getName());
    }

    public void destroy() {
        try {
            this.destroyChannelFactory(this.channelFactory);
        }
        catch (Exception e) {
            logger.warn("Failed to destroy a channel factory.", e);
        }
    }

    protected void destroyChannelFactory(ChannelFactory factory) throws Exception {
        factory.releaseExternalResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!"POST".equalsIgnoreCase(req.getMethod())) {
            logger.warn("Unallowed method: " + req.getMethod());
            res.sendError(405);
            return;
        }
        ChannelPipeline pipeline = Channels.pipeline();
        ServletOutputStream out = res.getOutputStream();
        OutboundConnectionHandler handler = new OutboundConnectionHandler(out);
        pipeline.addLast("handler", handler);
        Channel channel = this.channelFactory.newChannel(pipeline);
        ChannelFuture future = channel.connect(this.remoteAddress).awaitUninterruptibly();
        if (!future.isSuccess()) {
            Throwable cause = future.getCause();
            logger.warn("Endpoint unavailable: " + cause.getMessage(), cause);
            res.sendError(503);
            return;
        }
        ChannelFuture lastWriteFuture = null;
        try {
            res.setStatus(200);
            res.setHeader("Content-Type", "application/octet-stream");
            res.setHeader("Content-Transfer-Encoding", "binary");
            out.flush();
            PushbackInputStream in = new PushbackInputStream((InputStream)req.getInputStream());
            while (channel.isConnected()) {
                ChannelBuffer buffer;
                try {
                    buffer = HttpTunnelingServlet.read(in);
                }
                catch (EOFException e) {
                    break;
                }
                if (buffer == null) {
                    break;
                }
                lastWriteFuture = channel.write(buffer);
            }
        }
        finally {
            if (lastWriteFuture == null) {
                channel.close();
            } else {
                lastWriteFuture.addListener(ChannelFutureListener.CLOSE);
            }
        }
    }

    private static ChannelBuffer read(PushbackInputStream in) throws IOException {
        int readBytes;
        byte[] buf;
        int bytesToRead = in.available();
        if (bytesToRead > 0) {
            buf = new byte[bytesToRead];
            readBytes = in.read(buf);
        } else if (bytesToRead == 0) {
            int b = in.read();
            if (b < 0 || in.available() < 0) {
                return null;
            }
            in.unread(b);
            bytesToRead = in.available();
            buf = new byte[bytesToRead];
            readBytes = in.read(buf);
        } else {
            return null;
        }
        assert (readBytes > 0);
        ChannelBuffer buffer = readBytes == buf.length ? ChannelBuffers.wrappedBuffer(buf) : ChannelBuffers.wrappedBuffer(buf, 0, readBytes);
        return buffer;
    }

    private static final class OutboundConnectionHandler
    extends SimpleChannelUpstreamHandler {
        private final ServletOutputStream out;

        public OutboundConnectionHandler(ServletOutputStream out) {
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            ChannelBuffer buffer = (ChannelBuffer)e.getMessage();
            OutboundConnectionHandler outboundConnectionHandler = this;
            synchronized (outboundConnectionHandler) {
                buffer.readBytes((OutputStream)this.out, buffer.readableBytes());
                this.out.flush();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            logger.warn("Unexpected exception while HTTP tunneling", e.getCause());
            e.getChannel().close();
        }
    }
}

