/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.io.IOException;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.admin.cluster.node.info.TransportNodesInfoAction;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.path.PathTrie;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpServerAdapter;
import org.elasticsearch.http.HttpServerHandler;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.StringRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.support.RestUtils;
import org.elasticsearch.threadpool.ThreadPool;

public class HttpServer
extends AbstractLifecycleComponent<HttpServer> {
    private final HttpServerTransport transport;
    private final ThreadPool threadPool;
    private final RestController restController;
    private final TransportNodesInfoAction nodesInfoAction;
    private final PathTrie<HttpServerHandler> getHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<HttpServerHandler> postHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<HttpServerHandler> putHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<HttpServerHandler> deleteHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<HttpServerHandler> headHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<HttpServerHandler> optionsHandlers = new PathTrie(RestUtils.REST_DECODER);

    @Inject
    public HttpServer(Settings settings, HttpServerTransport transport, ThreadPool threadPool, RestController restController, TransportNodesInfoAction nodesInfoAction) {
        super(settings);
        this.transport = transport;
        this.threadPool = threadPool;
        this.restController = restController;
        this.nodesInfoAction = nodesInfoAction;
        transport.httpServerAdapter(new HttpServerAdapter(){

            @Override
            public void dispatchRequest(HttpRequest request, HttpChannel channel) {
                HttpServer.this.internalDispatchRequest(request, channel);
            }
        });
    }

    public void registerHandler(RestRequest.Method method, String path, HttpServerHandler handler) {
        if (method == RestRequest.Method.GET) {
            this.getHandlers.insert(path, handler);
        } else if (method == RestRequest.Method.POST) {
            this.postHandlers.insert(path, handler);
        } else if (method == RestRequest.Method.PUT) {
            this.putHandlers.insert(path, handler);
        } else if (method == RestRequest.Method.DELETE) {
            this.deleteHandlers.insert(path, handler);
        } else if (method == RestRequest.Method.HEAD) {
            this.headHandlers.insert(path, handler);
        } else if (method == RestRequest.Method.OPTIONS) {
            this.optionsHandlers.insert(path, handler);
        }
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        this.transport.start();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{}", this.transport.boundAddress());
        }
        this.nodesInfoAction.putNodeAttribute("http_address", this.transport.boundAddress().publishAddress().toString());
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        this.nodesInfoAction.removeNodeAttribute("http_address");
        this.transport.stop();
    }

    @Override
    protected void doClose() throws ElasticSearchException {
        this.transport.close();
    }

    void internalDispatchRequest(final HttpRequest request, final HttpChannel channel) {
        final HttpServerHandler httpHandler = this.getHandler(request);
        if (httpHandler == null) {
            if (!this.restController.dispatchRequest(request, channel)) {
                if (request.method() == RestRequest.Method.OPTIONS) {
                    StringRestResponse response = new StringRestResponse(RestStatus.OK);
                    channel.sendResponse(response);
                } else {
                    channel.sendResponse(new StringRestResponse(RestStatus.BAD_REQUEST, "No handler found for uri [" + request.uri() + "] and method [" + (Object)((Object)request.method()) + "]"));
                }
            }
        } else if (httpHandler.spawn()) {
            this.threadPool.cached().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        httpHandler.handleRequest(request, channel);
                    }
                    catch (Exception e) {
                        try {
                            channel.sendResponse(new XContentThrowableRestResponse((RestRequest)request, e));
                        }
                        catch (IOException e1) {
                            HttpServer.this.logger.error("Failed to send failure response for uri [" + request.uri() + "]", e1, new Object[0]);
                        }
                    }
                }
            });
        } else {
            try {
                httpHandler.handleRequest(request, channel);
            }
            catch (Exception e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse((RestRequest)request, e));
                }
                catch (IOException e1) {
                    this.logger.error("Failed to send failure response for uri [" + request.uri() + "]", e1, new Object[0]);
                }
            }
        }
    }

    private HttpServerHandler getHandler(HttpRequest request) {
        String path = this.getPath(request);
        RestRequest.Method method = request.method();
        if (method == RestRequest.Method.GET) {
            return this.getHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.POST) {
            return this.postHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.PUT) {
            return this.putHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.DELETE) {
            return this.deleteHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.HEAD) {
            return this.headHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.OPTIONS) {
            return this.optionsHandlers.retrieve(path, request.params());
        }
        return null;
    }

    private String getPath(HttpRequest request) {
        return request.rawPath();
    }
}

