/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.id.simple;

import org.elasticsearch.common.BytesWrap;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.index.cache.id.IdReaderCache;
import org.elasticsearch.index.cache.id.IdReaderTypeCache;
import org.elasticsearch.index.cache.id.simple.SimpleIdReaderTypeCache;

public class SimpleIdReaderCache
implements IdReaderCache {
    private final Object readerCacheKey;
    private final ImmutableMap<String, SimpleIdReaderTypeCache> types;

    public SimpleIdReaderCache(Object readerCacheKey, ImmutableMap<String, SimpleIdReaderTypeCache> types) {
        this.readerCacheKey = readerCacheKey;
        this.types = types;
    }

    @Override
    public Object readerCacheKey() {
        return this.readerCacheKey;
    }

    @Override
    public IdReaderTypeCache type(String type) {
        return this.types.get(type);
    }

    @Override
    public BytesWrap parentIdByDoc(String type, int docId) {
        SimpleIdReaderTypeCache typeCache = this.types.get(type);
        if (typeCache != null) {
            return typeCache.parentIdByDoc(docId);
        }
        return null;
    }

    @Override
    public int docById(String type, BytesWrap id) {
        SimpleIdReaderTypeCache typeCache = this.types.get(type);
        if (typeCache != null) {
            return typeCache.docById(id);
        }
        return -1;
    }

    public BytesWrap canReuse(BytesWrap id) {
        for (SimpleIdReaderTypeCache typeCache : this.types.values()) {
            BytesWrap wrap = typeCache.canReuse(id);
            if (wrap == null) continue;
            return wrap;
        }
        return null;
    }
}

