/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.support;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.util.StringHelper;
import org.elasticsearch.index.field.data.FieldData;

public class FieldDataLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends FieldData> T load(IndexReader reader, String field, TypeLoader<T> loader) throws IOException {
        ArrayList<int[]> ordinals;
        block13: {
            loader.init();
            field = StringHelper.intern((String)field);
            ordinals = new ArrayList<int[]>();
            ordinals.add(new int[reader.maxDoc()]);
            int t = 1;
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        loader.collectTerm(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            int doc = termDocs.doc();
                            boolean found = false;
                            for (int i = 0; i < ordinals.size(); ++i) {
                                int[] ordinal = (int[])ordinals.get(i);
                                if (ordinal[doc] != 0) continue;
                                ordinal[doc] = t;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            int[] ordinal = new int[reader.maxDoc()];
                            ordinals.add(ordinal);
                            ordinal[doc] = t;
                        }
                        ++t;
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            catch (RuntimeException e) {
                if (e.getClass().getName().endsWith("StopFillCacheException")) {
                    break block13;
                }
                throw e;
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
        }
        if (ordinals.size() == 1) {
            return loader.buildSingleValue(field, (int[])ordinals.get(0));
        }
        int[][] nativeOrdinals = new int[ordinals.size()][];
        for (int i = 0; i < nativeOrdinals.length; ++i) {
            nativeOrdinals[i] = (int[])ordinals.get(i);
        }
        return loader.buildMultiValue(field, nativeOrdinals);
    }

    public static abstract class FreqsTypeLoader<T extends FieldData>
    implements TypeLoader<T> {
        protected FreqsTypeLoader() {
        }

        @Override
        public void init() {
        }
    }

    public static interface TypeLoader<T extends FieldData> {
        public void init();

        public void collectTerm(String var1);

        public T buildSingleValue(String var1, int[] var2);

        public T buildMultiValue(String var1, int[][] var2);
    }
}

