/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import java.util.HashSet;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.MoreLikeThisQuery;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.query.xcontent.QueryParseContext;
import org.elasticsearch.index.query.xcontent.XContentQueryParser;
import org.elasticsearch.index.settings.IndexSettings;

public class MoreLikeThisFieldQueryParser
extends AbstractIndexComponent
implements XContentQueryParser {
    public static final String NAME = "mlt_field";

    @Inject
    public MoreLikeThisFieldQueryParser(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "more_like_this_field", Strings.toCamelCase(NAME), "moreLikeThisField"};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.nextToken();
        assert (token == XContentParser.Token.FIELD_NAME);
        String fieldName = parser.currentName();
        token = parser.nextToken();
        assert (token == XContentParser.Token.START_OBJECT);
        MoreLikeThisQuery mltQuery = new MoreLikeThisQuery();
        mltQuery.setSimilarity(parseContext.searchSimilarity());
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("like_text".equals(currentFieldName)) {
                    mltQuery.setLikeText(parser.text());
                    continue;
                }
                if ("min_term_freq".equals(currentFieldName) || "minTermFreq".equals(currentFieldName)) {
                    mltQuery.setMinTermFrequency(parser.intValue());
                    continue;
                }
                if ("max_query_terms".equals(currentFieldName) || "maxQueryTerms".equals(currentFieldName)) {
                    mltQuery.setMaxQueryTerms(parser.intValue());
                    continue;
                }
                if ("min_doc_freq".equals(currentFieldName) || "minDocFreq".equals(currentFieldName)) {
                    mltQuery.setMinDocFreq(parser.intValue());
                    continue;
                }
                if ("max_doc_freq".equals(currentFieldName) || "maxDocFreq".equals(currentFieldName)) {
                    mltQuery.setMaxDocFreq(parser.intValue());
                    continue;
                }
                if ("min_word_len".equals(currentFieldName) || "minWordLen".equals(currentFieldName)) {
                    mltQuery.setMinWordLen(parser.intValue());
                    continue;
                }
                if ("max_word_len".equals(currentFieldName) || "maxWordLen".equals(currentFieldName)) {
                    mltQuery.setMaxWordLen(parser.intValue());
                    continue;
                }
                if ("boost_terms".equals(currentFieldName) || "boostTerms".equals(currentFieldName)) {
                    mltQuery.setBoostTerms(true);
                    mltQuery.setBoostTermsFactor(parser.floatValue());
                    continue;
                }
                if (!"percent_terms_to_match".equals(currentFieldName) && !"percentTermsToMatch".equals(currentFieldName)) continue;
                mltQuery.setPercentTermsToMatch(parser.floatValue());
                continue;
            }
            if (token != XContentParser.Token.START_ARRAY || !"stop_words".equals(currentFieldName) && !"stopWords".equals(currentFieldName)) continue;
            HashSet<String> stopWords = Sets.newHashSet();
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                stopWords.add(parser.text());
            }
            mltQuery.setStopWords(stopWords);
        }
        if (mltQuery.getLikeText() == null) {
            throw new QueryParsingException(this.index, "more_like_this_field requires 'like_text' to be specified");
        }
        token = parser.nextToken();
        assert (token == XContentParser.Token.END_OBJECT);
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            fieldName = smartNameFieldMappers.mapper().names().indexName();
            mltQuery.setAnalyzer(smartNameFieldMappers.mapper().searchAnalyzer());
        }
        if (mltQuery.getAnalyzer() == null) {
            mltQuery.setAnalyzer(parseContext.mapperService().searchAnalyzer());
        }
        mltQuery.setMoreLikeFields(new String[]{fieldName});
        return QueryParsers.wrapSmartNameQuery(mltQuery, smartNameFieldMappers, parseContext);
    }
}

