/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.xcontent.BaseQueryBuilder;

public class WildcardQueryBuilder
extends BaseQueryBuilder {
    private final String name;
    private final String wildcard;
    private float boost = -1.0f;

    public WildcardQueryBuilder(String name, String wildcard) {
        this.name = name;
        this.wildcard = wildcard;
    }

    public WildcardQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("wildcard");
        if (this.boost == -1.0f) {
            builder.field(this.name, this.wildcard);
        } else {
            builder.startObject(this.name);
            builder.field("wildcard", this.wildcard);
            builder.field("boost", this.boost);
            builder.endObject();
        }
        builder.endObject();
    }
}

