/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.trove.ExtTLongObjectHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.elasticsearch.search.facet.datehistogram.InternalDateHistogramFacet;

public class InternalFullDateHistogramFacet
extends InternalDateHistogramFacet {
    private static final String STREAM_TYPE = "fdHistogram";
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(String type, StreamInput in) throws IOException {
            return InternalFullDateHistogramFacet.readHistogramFacet(in);
        }
    };
    private String name;
    private DateHistogramFacet.ComparatorType comparatorType;
    ExtTLongObjectHashMap<FullEntry> tEntries;
    boolean cachedEntries;
    Collection<FullEntry> entries;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public String streamType() {
        return STREAM_TYPE;
    }

    private InternalFullDateHistogramFacet() {
    }

    public InternalFullDateHistogramFacet(String name, DateHistogramFacet.ComparatorType comparatorType, ExtTLongObjectHashMap<FullEntry> entries, boolean cachedEntries) {
        this.name = name;
        this.comparatorType = comparatorType;
        this.tEntries = entries;
        this.cachedEntries = cachedEntries;
        this.entries = entries.valueCollection();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String type() {
        return "date_histogram";
    }

    @Override
    public String getType() {
        return this.type();
    }

    public List<FullEntry> entries() {
        if (!(this.entries instanceof List)) {
            this.entries = new ArrayList<FullEntry>(this.entries);
        }
        return (List)this.entries;
    }

    public List<FullEntry> getEntries() {
        return this.entries();
    }

    @Override
    public Iterator<DateHistogramFacet.Entry> iterator() {
        return this.entries().iterator();
    }

    void releaseCache() {
        if (this.cachedEntries) {
            CacheRecycler.pushLongObjectMap(this.tEntries);
            this.cachedEntries = false;
            this.tEntries = null;
        }
    }

    @Override
    public Facet reduce(String name, List<Facet> facets) {
        FullEntry value;
        if (facets.size() == 1) {
            InternalFullDateHistogramFacet internalFacet = (InternalFullDateHistogramFacet)facets.get(0);
            List<FullEntry> entries = internalFacet.entries();
            Collections.sort(entries, this.comparatorType.comparator());
            internalFacet.releaseCache();
            return internalFacet;
        }
        ExtTLongObjectHashMap map = CacheRecycler.popLongObjectMap();
        for (Facet facet : facets) {
            InternalFullDateHistogramFacet histoFacet = (InternalFullDateHistogramFacet)facet;
            for (FullEntry fullEntry : histoFacet.entries) {
                FullEntry current = (FullEntry)map.get(fullEntry.time);
                if (current != null) {
                    current.count += fullEntry.count;
                    current.total += fullEntry.total;
                    current.totalCount += fullEntry.totalCount;
                    if (fullEntry.min < current.min) {
                        current.min = fullEntry.min;
                    }
                    if (!(fullEntry.max > current.max)) continue;
                    current.max = fullEntry.max;
                    continue;
                }
                map.put(fullEntry.time, fullEntry);
            }
            histoFacet.releaseCache();
        }
        Object[] values = map.internalValues();
        Arrays.sort(values, this.comparatorType.comparator());
        ArrayList<FullEntry> ordered = new ArrayList<FullEntry>(map.size());
        for (int i = 0; i < map.size() && (value = (FullEntry)values[i]) != null; ++i) {
            ordered.add(value);
        }
        CacheRecycler.pushLongObjectMap(map);
        InternalFullDateHistogramFacet ret = new InternalFullDateHistogramFacet();
        ret.name = name;
        ret.comparatorType = this.comparatorType;
        ret.entries = ordered;
        return ret;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field(Fields._TYPE, "date_histogram");
        builder.startArray(Fields.ENTRIES);
        for (FullEntry entry : this.entries()) {
            builder.startObject();
            builder.field(Fields.TIME, entry.time());
            builder.field(Fields.COUNT, entry.count());
            builder.field(Fields.MIN, entry.min());
            builder.field(Fields.MAX, entry.max());
            builder.field(Fields.TOTAL, entry.total());
            builder.field(Fields.TOTAL_COUNT, entry.totalCount());
            builder.field(Fields.MEAN, entry.mean());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalFullDateHistogramFacet readHistogramFacet(StreamInput in) throws IOException {
        InternalFullDateHistogramFacet facet = new InternalFullDateHistogramFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        this.comparatorType = DateHistogramFacet.ComparatorType.fromId(in.readByte());
        this.cachedEntries = false;
        int size = in.readVInt();
        this.entries = new ArrayList<FullEntry>(size);
        for (int i = 0; i < size; ++i) {
            this.entries.add(new FullEntry(in.readLong(), in.readVLong(), in.readDouble(), in.readDouble(), in.readVLong(), in.readDouble()));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.entries.size());
        for (FullEntry entry : this.entries) {
            out.writeLong(entry.time);
            out.writeVLong(entry.count);
            out.writeDouble(entry.min);
            out.writeDouble(entry.max);
            out.writeVLong(entry.totalCount);
            out.writeDouble(entry.total);
        }
        this.releaseCache();
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString ENTRIES = new XContentBuilderString("entries");
        static final XContentBuilderString TIME = new XContentBuilderString("time");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString TOTAL_COUNT = new XContentBuilderString("total_count");
        static final XContentBuilderString MEAN = new XContentBuilderString("mean");
        static final XContentBuilderString MIN = new XContentBuilderString("min");
        static final XContentBuilderString MAX = new XContentBuilderString("max");

        Fields() {
        }
    }

    public static class FullEntry
    implements DateHistogramFacet.Entry {
        private final long time;
        long count;
        long totalCount;
        double total;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;

        public FullEntry(long time, long count, double min, double max, long totalCount, double total) {
            this.time = time;
            this.count = count;
            this.min = min;
            this.max = max;
            this.totalCount = totalCount;
            this.total = total;
        }

        @Override
        public long time() {
            return this.time;
        }

        @Override
        public long getTime() {
            return this.time();
        }

        @Override
        public long count() {
            return this.count;
        }

        @Override
        public long getCount() {
            return this.count();
        }

        @Override
        public double total() {
            return this.total;
        }

        @Override
        public double getTotal() {
            return this.total();
        }

        @Override
        public long totalCount() {
            return this.totalCount;
        }

        @Override
        public long getTotalCount() {
            return this.totalCount;
        }

        @Override
        public double mean() {
            return this.total / (double)this.totalCount;
        }

        @Override
        public double getMean() {
            return this.total / (double)this.totalCount;
        }

        @Override
        public double min() {
            return this.min;
        }

        @Override
        public double getMin() {
            return this.min;
        }

        @Override
        public double max() {
            return this.max;
        }

        @Override
        public double getMax() {
            return this.max;
        }
    }
}

