/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.AllButSourceFieldSelector;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.FieldMappersFieldSelector;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.UidAndSourceFieldSelector;
import org.elasticsearch.index.mapper.UidFieldSelector;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.fetch.FieldsParseElement;
import org.elasticsearch.search.fetch.SearchHitPhase;
import org.elasticsearch.search.fetch.explain.ExplainSearchHitPhase;
import org.elasticsearch.search.fetch.matchedfilters.MatchedFiltersSearchHitPhase;
import org.elasticsearch.search.fetch.script.ScriptFieldsSearchHitPhase;
import org.elasticsearch.search.fetch.version.VersionSearchHitPhase;
import org.elasticsearch.search.highlight.HighlightPhase;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.InternalSearchHitField;
import org.elasticsearch.search.internal.InternalSearchHits;
import org.elasticsearch.search.internal.SearchContext;

public class FetchPhase
implements SearchPhase {
    private final SearchHitPhase[] hitPhases;

    @Inject
    public FetchPhase(HighlightPhase highlightPhase, ScriptFieldsSearchHitPhase scriptFieldsPhase, MatchedFiltersSearchHitPhase matchFiltersPhase, ExplainSearchHitPhase explainPhase, VersionSearchHitPhase versionPhase) {
        this.hitPhases = new SearchHitPhase[]{scriptFieldsPhase, matchFiltersPhase, explainPhase, highlightPhase, versionPhase};
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        ImmutableMap.Builder<String, ? extends SearchParseElement> parseElements = ImmutableMap.builder();
        parseElements.put("fields", new FieldsParseElement());
        for (SearchHitPhase hitPhase : this.hitPhases) {
            parseElements.putAll(hitPhase.parseElements());
        }
        return parseElements.build();
    }

    @Override
    public void preProcess(SearchContext context) {
    }

    @Override
    public void execute(SearchContext context) {
        FieldSelector fieldSelector = this.buildFieldSelectors(context);
        InternalSearchHit[] hits = new InternalSearchHit[context.docIdsToLoadSize()];
        for (int index = 0; index < context.docIdsToLoadSize(); ++index) {
            InternalSearchHit searchHit;
            int docId = context.docIdsToLoad()[context.docIdsToLoadFrom() + index];
            Document doc = this.loadDocument(context, fieldSelector, docId);
            Uid uid = this.extractUid(context, doc);
            DocumentMapper documentMapper = context.mapperService().documentMapper(uid.type());
            if (documentMapper == null) {
                throw new TypeMissingException(new Index(context.shardTarget().index()), uid.type(), "failed to find type loaded for doc [" + uid.id() + "]");
            }
            byte[] source = this.extractSource(doc, documentMapper);
            hits[index] = searchHit = new InternalSearchHit(docId, uid.id(), uid.type(), source, null);
            for (Fieldable oField : doc.getFields()) {
                SearchHitField hitField;
                FieldMapper mapper;
                Fieldable field = oField;
                String name = field.name();
                if (name.equals("_uid") || name.equals("_source")) continue;
                Object value = null;
                FieldMappers fieldMappers = documentMapper.mappers().indexName(field.name());
                if (fieldMappers != null && (mapper = fieldMappers.mapper()) != null) {
                    name = mapper.names().fullName();
                    value = mapper.valueForSearch(field);
                }
                if (value == null) {
                    value = field.isBinary() ? field.getBinaryValue() : (Object)field.stringValue();
                }
                if (searchHit.fieldsOrNull() == null) {
                    searchHit.fields(new HashMap<String, SearchHitField>(2));
                }
                if ((hitField = searchHit.fields().get(name)) == null) {
                    hitField = new InternalSearchHitField(name, new ArrayList<Object>(2));
                    searchHit.fields().put(name, hitField);
                }
                hitField.values().add(value);
            }
            int readerIndex = context.searcher().readerIndex(docId);
            IndexReader subReader = context.searcher().subReaders()[readerIndex];
            int subDoc = docId - context.searcher().docStarts()[readerIndex];
            for (SearchHitPhase hitPhase : this.hitPhases) {
                SearchHitPhase.HitContext hitContext = new SearchHitPhase.HitContext();
                if (!hitPhase.executionNeeded(context)) continue;
                hitContext.reset(searchHit, subReader, subDoc, doc);
                hitPhase.execute(context, hitContext);
            }
        }
        context.fetchResult().hits(new InternalSearchHits(hits, context.queryResult().topDocs().totalHits, context.queryResult().topDocs().getMaxScore()));
    }

    private byte[] extractSource(Document doc, DocumentMapper documentMapper) {
        Fieldable sourceField = doc.getFieldable("_source");
        if (sourceField != null) {
            return documentMapper.sourceMapper().nativeValue(sourceField);
        }
        return null;
    }

    private Uid extractUid(SearchContext context, Document doc) {
        String sUid = doc.get("_uid");
        if (sUid != null) {
            return Uid.createUid(sUid);
        }
        throw new FetchPhaseExecutionException(context, "Failed to load uid from the index");
    }

    private Document loadDocument(SearchContext context, FieldSelector fieldSelector, int docId) {
        try {
            return context.searcher().doc(docId, fieldSelector);
        }
        catch (IOException e) {
            throw new FetchPhaseExecutionException(context, "Failed to fetch doc id [" + docId + "]", (Throwable)e);
        }
    }

    private FieldSelector buildFieldSelectors(SearchContext context) {
        if (context.hasScriptFields() && !context.hasFieldNames()) {
            return UidFieldSelector.INSTANCE;
        }
        if (!context.hasFieldNames()) {
            return new UidAndSourceFieldSelector();
        }
        if (context.fieldNames().isEmpty()) {
            return UidFieldSelector.INSTANCE;
        }
        if (context.fieldNames().get(0).equals("*")) {
            return AllButSourceFieldSelector.INSTANCE;
        }
        FieldMappersFieldSelector fieldSelector = new FieldMappersFieldSelector();
        for (String fieldName : context.fieldNames()) {
            FieldMappers x = context.mapperService().smartNameFieldMappers(fieldName);
            if (x == null) {
                throw new FetchPhaseExecutionException(context, "No mapping for field [" + fieldName + "] in order to load it");
            }
            fieldSelector.add(x);
        }
        fieldSelector.add("_uid");
        return fieldSelector;
    }
}

