/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc.types;

import java.net.MalformedURLException;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;

public class URL
implements SQLData {
    private String url;

    @Override
    public String getSQLTypeName() {
        return "url";
    }

    @Override
    public void readSQL(SQLInput stream, String typeName) throws SQLException {
        if (typeName.compareTo("url") != 0) {
            throw new SQLException("can only use this class with 'url' type", "M1M05");
        }
        this.url = stream.readString();
    }

    @Override
    public void writeSQL(SQLOutput stream) throws SQLException {
        stream.writeString(this.url);
    }

    public String toString() {
        return this.url;
    }

    public void fromString(String newurl) throws Exception {
        if (newurl == null) {
            this.url = newurl;
            return;
        }
        new java.net.URL(newurl);
        this.url = newurl;
    }

    public java.net.URL getURL() throws SQLException {
        if (this.url == null) {
            return null;
        }
        try {
            return new java.net.URL(this.url);
        }
        catch (MalformedURLException mue) {
            throw new SQLException("data is not a valid URL", "M0M27");
        }
    }

    public void setURL(java.net.URL nurl) throws Exception {
        this.url = nurl.toString();
    }
}

