/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.master.metrics.MasterMetrics;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogSplitter;
import org.apache.hadoop.hbase.regionserver.wal.OrphanHLogAfterSplitException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;

public class MasterFileSystem {
    private static final Log LOG = LogFactory.getLog((String)MasterFileSystem.class.getName());
    Configuration conf;
    Server master;
    MasterMetrics metrics;
    private final FileSystem fs;
    private volatile boolean fsOk = true;
    private final Path oldLogDir;
    private final Path rootdir;
    final Lock splitLogLock = new ReentrantLock();

    public MasterFileSystem(Server master, MasterMetrics metrics) throws IOException {
        this.conf = master.getConfiguration();
        this.master = master;
        this.metrics = metrics;
        this.rootdir = FSUtils.getRootDir(this.conf);
        this.fs = this.rootdir.getFileSystem(this.conf);
        String fsUri = this.fs.getUri().toString();
        this.conf.set("fs.default.name", fsUri);
        this.conf.set("fs.defaultFS", fsUri);
        this.oldLogDir = new Path(this.rootdir, ".oldlogs");
        this.createInitialFileSystemLayout();
    }

    private void createInitialFileSystemLayout() throws IOException {
        MasterFileSystem.checkRootDir(this.rootdir, this.conf, this.fs);
        if (!this.fs.exists(this.oldLogDir)) {
            this.fs.mkdirs(this.oldLogDir);
        }
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public Path getOldLogDir() {
        return this.oldLogDir;
    }

    public boolean checkFileSystem() {
        if (this.fsOk) {
            try {
                FSUtils.checkFileSystemAvailable(this.fs);
            }
            catch (IOException e) {
                this.master.abort("Shutting down HBase cluster: file system not available", e);
                this.fsOk = false;
            }
        }
        return this.fsOk;
    }

    public Path getRootDir() {
        return this.rootdir;
    }

    void splitLogAfterStartup(Map<String, HServerInfo> onlineServers) {
        FileStatus[] logFolders;
        Path logsDirPath = new Path(this.rootdir, ".logs");
        try {
            if (!this.fs.exists(logsDirPath)) {
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed exists test on " + logsDirPath, e);
        }
        try {
            logFolders = this.fs.listStatus(logsDirPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed listing " + logsDirPath.toString(), e);
        }
        if (logFolders == null || logFolders.length == 0) {
            LOG.debug((Object)"No log files to split, proceeding...");
            return;
        }
        for (FileStatus status : logFolders) {
            String serverName = status.getPath().getName();
            if (onlineServers.get(serverName) == null) {
                LOG.info((Object)("Log folder " + status.getPath() + " doesn't belong " + "to a known region server, splitting"));
                this.splitLog(serverName);
                continue;
            }
            LOG.info((Object)("Log folder " + status.getPath() + " belongs to an existing region server"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void splitLog(String serverName) {
        this.splitLogLock.lock();
        long splitTime = 0L;
        long splitLogSize = 0L;
        Path logDir = new Path(this.rootdir, HLog.getHLogDirectoryName(serverName));
        try {
            HLogSplitter splitter = HLogSplitter.createLogSplitter(this.conf, this.rootdir, logDir, this.oldLogDir, this.fs);
            try {
                splitter.splitLog();
            }
            catch (OrphanHLogAfterSplitException e) {
                LOG.warn((Object)"Retrying splitting because of:", (Throwable)e);
                splitter = HLogSplitter.createLogSplitter(this.conf, this.rootdir, logDir, this.oldLogDir, this.fs);
                splitter.splitLog();
            }
            splitTime = splitter.getTime();
            splitLogSize = splitter.getSize();
        }
        catch (IOException e) {
            this.checkFileSystem();
            LOG.error((Object)("Failed splitting " + logDir.toString()), (Throwable)e);
        }
        finally {
            this.splitLogLock.unlock();
        }
        if (this.metrics != null) {
            this.metrics.addSplit(splitTime, splitLogSize);
        }
    }

    private static Path checkRootDir(Path rd, Configuration c, FileSystem fs) throws IOException {
        FSUtils.waitOnSafeMode(c, c.getInt("hbase.server.thread.wakefrequency", 10000));
        if (!fs.exists(rd)) {
            fs.mkdirs(rd);
            FSUtils.setVersion(fs, rd, c.getInt("hbase.server.thread.wakefrequency", 10000));
        } else {
            FSUtils.checkVersion(fs, rd, true, c.getInt("hbase.server.thread.wakefrequency", 10000));
        }
        if (!FSUtils.rootRegionExists(fs, rd)) {
            MasterFileSystem.bootstrap(rd, c);
        }
        return rd;
    }

    private static void bootstrap(Path rd, Configuration c) throws IOException {
        LOG.info((Object)"BOOTSTRAP: creating ROOT and first META regions");
        try {
            HRegionInfo rootHRI = new HRegionInfo(HRegionInfo.ROOT_REGIONINFO);
            MasterFileSystem.setInfoFamilyCaching(rootHRI, false);
            HRegionInfo metaHRI = new HRegionInfo(HRegionInfo.FIRST_META_REGIONINFO);
            MasterFileSystem.setInfoFamilyCaching(metaHRI, false);
            HRegion root = HRegion.createHRegion(rootHRI, rd, c);
            HRegion meta = HRegion.createHRegion(metaHRI, rd, c);
            MasterFileSystem.setInfoFamilyCaching(rootHRI, true);
            MasterFileSystem.setInfoFamilyCaching(metaHRI, true);
            HRegion.addRegionToMETA(root, meta);
            root.close();
            root.getLog().closeAndDelete();
            meta.close();
            meta.getLog().closeAndDelete();
        }
        catch (IOException e) {
            e = RemoteExceptionHandler.checkIOException(e);
            LOG.error((Object)"bootstrap", (Throwable)e);
            throw e;
        }
    }

    private static void setInfoFamilyCaching(HRegionInfo hri, boolean b) {
        for (HColumnDescriptor hcd : hri.getTableDesc().families.values()) {
            if (!Bytes.equals(hcd.getName(), HConstants.CATALOG_FAMILY)) continue;
            hcd.setBlockCacheEnabled(b);
            hcd.setInMemory(b);
        }
    }

    public void deleteRegion(HRegionInfo region) throws IOException {
        this.fs.delete(HRegion.getRegionDir(this.rootdir, region), true);
    }

    public void deleteTable(byte[] tableName) throws IOException {
        this.fs.delete(new Path(this.rootdir, Bytes.toString(tableName)), true);
    }

    public void updateRegionInfo(HRegionInfo region) {
    }

    public void deleteFamily(HRegionInfo region, byte[] familyName) throws IOException {
        this.fs.delete(Store.getStoreHomedir(new Path(this.rootdir, region.getTableDesc().getNameAsString()), region.getEncodedName(), familyName), true);
    }
}

