/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SignonDialogAdapter;
import com.ibm.as400.access.ResourceBundleLoader;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.util.StringTokenizer;

class MessageDialog
extends Dialog {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private Button positiveButton_ = null;
    private Button negativeButton_ = null;
    private AS400SignonDialogAdapter listener_ = new AS400SignonDialogAdapter(this);

    MessageDialog(Frame parent, String messageText, String titleText, boolean allowChoice) {
        super(parent, titleText, true);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.insets = new Insets(8, 8, 0, 8);
        this.setLayout(layout);
        this.setResizable(false);
        this.setBackground(Color.lightGray);
        Panel panel = new Panel();
        StringTokenizer tokenizer = new StringTokenizer(messageText, "\n");
        panel.setLayout(new GridLayout(tokenizer.countTokens(), 1));
        while (tokenizer.hasMoreTokens()) {
            panel.add(new Label(tokenizer.nextToken()));
        }
        this.add(panel, layout, constraints, 0, 0, 1, 1);
        Panel centeringPanel = new Panel();
        centeringPanel.setLayout(new FlowLayout(1));
        constraints.insets = new Insets(8, 8, 8, 8);
        this.add(centeringPanel, layout, constraints, 0, 1, 1, 1);
        Panel buttonPanel = new Panel();
        buttonPanel.setLayout(new GridLayout(1, 2, 8, 0));
        centeringPanel.add(buttonPanel);
        if (allowChoice) {
            this.positiveButton_ = new Button(ResourceBundleLoader.getText("DLG_YES_BUTTON"));
            this.positiveButton_.addActionListener(this.listener_);
            this.positiveButton_.addFocusListener(this.listener_);
            this.positiveButton_.addKeyListener(this.listener_);
            buttonPanel.add(this.positiveButton_);
            this.negativeButton_ = new Button(ResourceBundleLoader.getText("DLG_NO_BUTTON"));
            this.negativeButton_.addActionListener(this.listener_);
            this.negativeButton_.addFocusListener(this.listener_);
            this.negativeButton_.addKeyListener(this.listener_);
            buttonPanel.add(this.negativeButton_);
        } else {
            this.positiveButton_ = new Button(ResourceBundleLoader.getCoreText("DLG_OK_BUTTON"));
            this.positiveButton_.addActionListener(this.listener_);
            this.positiveButton_.addFocusListener(this.listener_);
            this.positiveButton_.addKeyListener(this.listener_);
            buttonPanel.add(this.positiveButton_);
        }
        this.pack();
        this.addWindowListener(this.listener_);
    }

    boolean display() {
        this.listener_.setFocalPoint(this.positiveButton_);
        this.show();
        return this.listener_.getFocalPoint() != this.negativeButton_;
    }

    protected void add(Component component, GridBagLayout layout, GridBagConstraints constraints, int x, int y, int width, int height) {
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.gridwidth = width;
        constraints.gridheight = height;
        layout.setConstraints(component, constraints);
        this.add(component);
    }
}

