<?php

/**
 * This file is part of the Froxlor project.
 * Copyright (c) 2003-2007 the SysCP Team (see authors).
 * Copyright (c) 2010 the Froxlor Team (see authors).
 *
 * For the full copyright and license information, please view the COPYING
 * file that was distributed with this source code. You can also view the
 * COPYING file online at http://files.froxlor.org/misc/COPYING.txt
 *
 * @copyright  (c) the authors
 * @author     Florian Lippert <flo@syscp.org> (2003-2007)
 * @author     Froxlor Team <team@froxlor.org> (2010-)
 * @license    GPLv2 http://files.froxlor.org/misc/COPYING.txt
 * @package    Language
 * @version    $Id$
 */

/**
 * Global
 */

$lng['translator'] = '';
$lng['panel']['edit'] = 'upravit';
$lng['panel']['delete'] = 'smazat';
$lng['panel']['create'] = 'vytvo&oslash;it';
$lng['panel']['save'] = 'ulo&#382;it';
$lng['panel']['yes'] = 'ano';
$lng['panel']['no'] = 'ne';
$lng['panel']['emptyfornochanges'] = 'pr&aacute;zdn&eacute; - &#382;&aacute;dn&eacute; zm&igrave; ny';
$lng['panel']['emptyfordefault'] = 'pr&aacute;zdn&eacute; - pro v&yacute;choz&iacute;';
$lng['panel']['path'] = 'Cesta';
$lng['panel']['toggle'] = 'P&oslash;epnout';
$lng['panel']['next'] = 'dal&#353;&iacute;';
$lng['panel']['dirsmissing'] = 'Nemohu nej&iacute;t/&egrave;&iacute;st adres&aacute;&oslash;!';

/**
 * Login
 */

$lng['login']['username'] = 'U&#382;ivatel';
$lng['login']['password'] = 'Heslo';
$lng['login']['language'] = 'Jazyk';
$lng['login']['login'] = 'P&oslash;ihl&aacute;sit';
$lng['login']['logout'] = 'Odhl&aacute;sit';
$lng['login']['profile_lng'] = 'Jazyk profilu';

/**
 * Customer
 */

$lng['customer']['documentroot'] = 'Dom&aacute;c&iacute; adres&aacute;&oslash;';
$lng['customer']['name'] = 'Jm&eacute;no';
$lng['customer']['firstname'] = 'K&oslash;estn&iacute; jm&eacute;no';
$lng['customer']['company'] = 'Spole&egrave;nost';
$lng['customer']['street'] = 'Ulice';
$lng['customer']['zipcode'] = 'PS&Egrave;';
$lng['customer']['city'] = 'M&igrave; sto';
$lng['customer']['phone'] = 'Telefon';
$lng['customer']['fax'] = 'Fax';
$lng['customer']['email'] = 'Email';
$lng['customer']['customernumber'] = 'Z&aacute;kazn&iacute;kovo ID';
$lng['customer']['diskspace'] = 'Webov&yacute; prostor (MB)';
$lng['customer']['traffic'] = 'P&oslash;enosy (GB)';
$lng['customer']['mysqls'] = 'MySQL-Datab&aacute;ze';
$lng['customer']['emails'] = 'E-mailov&eacute;-adresy';
$lng['customer']['accounts'] = 'E-mailv&eacute;-&Uacute;&egrave;ty';
$lng['customer']['forwarders'] = 'E-mailov&eacute;-P&oslash;epos&iacute;la&egrave;e';
$lng['customer']['ftps'] = 'FTP-&Uacute;&egrave;ty';
$lng['customer']['subdomains'] = 'Sub-Dom&eacute;ny';
$lng['customer']['domains'] = 'Dom&eacute;na';
$lng['customer']['unlimited'] = 'neomezeno';

/**
 * Customermenue
 */

$lng['menue']['main']['main'] = 'Hlavn&iacute;';
$lng['menue']['main']['changepassword'] = 'Zm&igrave; nit heslo';
$lng['menue']['main']['changelanguage'] = 'Zm&igrave; nit jazyl';
$lng['menue']['email']['email'] = 'E-mail';
$lng['menue']['email']['emails'] = 'Adresy';
$lng['menue']['email']['webmail'] = 'WebMail';
$lng['menue']['mysql']['mysql'] = 'MySQL';
$lng['menue']['mysql']['databases'] = 'Datab&aacute;ze';
$lng['menue']['mysql']['phpmyadmin'] = 'phpMyAdmin';
$lng['menue']['domains']['domains'] = 'Dom&eacute;ny';
$lng['menue']['domains']['settings'] = 'Nastaven&iacute;';
$lng['menue']['ftp']['ftp'] = 'FTP';
$lng['menue']['ftp']['accounts'] = '&Uacute;&egrave;ty';
$lng['menue']['ftp']['webftp'] = 'WebFTP';
$lng['menue']['extras']['extras'] = 'Extra';
$lng['menue']['extras']['directoryprotection'] = 'Ochrana adres&aacute;&oslash;e';
$lng['menue']['extras']['pathoptions'] = 'nastaven&iacute; cesty';

/**
 * Index
 */

$lng['index']['customerdetails'] = 'Detaily z&aacute;kazn&iacute;ka';
$lng['index']['accountdetails'] = 'Detaily &Uacute;&egrave;tu';

/**
 * Change Password
 */

$lng['changepassword']['old_password'] = 'Star&eacute; heslo';
$lng['changepassword']['new_password'] = 'Nov&eacute; heslo';
$lng['changepassword']['new_password_confirm'] = 'Nov&eacute; heslo (potvrzen&iacute;)';
$lng['changepassword']['new_password_ifnotempty'] = 'Nov&eacute; heslo (pr&aacute;zdn&eacute; = beze zm&igrave; n)';
$lng['changepassword']['also_change_ftp'] = ' tak&eacute; zm&igrave; nit heslo k hlavn&iacute;mu FTP &Uacute;&egrave;tu';

/**
 * Domains
 */

$lng['domains']['description'] = 'Zde m&ugrave;&#382;ete vytvo&oslash;it (sub-)dom&eacute;ny a m&igrave; nit jejich cesty.<br />Syst&eacute;m pot&oslash;ebuje n&igrave; jak&yacute; &egrave;as, ne&#382; se po &Uacute;prav&igrave;  nov&eacute; nastaven&iacute; projev&iacute;.';
$lng['domains']['domainsettings'] = 'Nastaven&iacute; dom&eacute;ny';
$lng['domains']['domainname'] = 'Jm&eacute;no dom&eacute;ny';
$lng['domains']['subdomain_add'] = 'Vytvo&oslash;it subdom&eacute;nu';
$lng['domains']['subdomain_edit'] = 'Upravit (sub)dom&eacute;nu';
$lng['domains']['wildcarddomain'] = 'Vytvo&oslash;it jako wildcard dom&eacute;nu?';
$lng['domains']['aliasdomain'] = 'Alias pro dom&eacute;nu';
$lng['domains']['noaliasdomain'] = '&#382;&aacute;dn&yacute; alias pro dom&eacute;nu';

/**
 * E-mails
 */

$lng['emails']['description'] = 'Zde m&ugrave;&#382;ete tak&eacute; vytvo&oslash;it a m&igrave; nit e-mailov&eacute; adresy.<br />&Uacute;&egrave;et je jako Va&#353;e po&#353;tovn&iacute; schr&aacute;nka p&oslash;ed Va&#353;&iacute;m domem. Pokud V&aacute;m n&igrave; kdo po&#353;le e-mail, p&oslash;ijde na tento &Uacute;&egrave;et.<br /><br />Pro sta&#382;en&iacute; e-mail&ugrave; pou&#382;ijte n&aacute;sleduj&iacute;c&iacute; nastaven&iacute; ve sv&eacute;m po&#353;tovn&iacute;m klientu: (Data <i>kurz&iacute;vou</i> mus&iacute; b&yacute;t zm&igrave; n&igrave; na podle toho, co jste zadali!)<br />Host: <b><i>Jm&eacute;no dom&eacute;ny</i></b><br />U&#382;ivatelsk&eacute; jm&eacute;no: <b><i>Jm&eacute;no &Uacute;&egrave;tu / e-mailov&eacute; adresy</i></b><br />Heslo: <b><i>heslo kter&eacute; jste zadali</i></b>';
$lng['emails']['emailaddress'] = 'E-mail-adresa';
$lng['emails']['emails_add'] = 'Vytvo&oslash;it e-mailovou-adresu';
$lng['emails']['emails_edit'] = 'Editovat e-mailovou-addresu';
$lng['emails']['catchall'] = 'Catchall';
$lng['emails']['iscatchall'] = 'Definovat jako catchall-adresu?';
$lng['emails']['account'] = '&Uacute;&egrave;et';
$lng['emails']['account_add'] = 'Vytvo&oslash;it &Uacute;&egrave;et';
$lng['emails']['account_delete'] = 'Smazat &Uacute;&egrave;et';
$lng['emails']['from'] = 'Zdroj';
$lng['emails']['to'] = 'C&iacute;l';
$lng['emails']['forwarders'] = 'P&oslash;epos&iacute;latel&eacute;';
$lng['emails']['forwarder_add'] = 'Vytvo&oslash;it p&oslash;epos&iacute;latele';

/**
 * FTP
 */

$lng['ftp']['description'] = 'Zde m&ugrave;&#382;ete vytv&aacute;&oslash;et a m&igrave; nit FTP &Uacute;&egrave;ty.<br />Zm&igrave; ny jsou provedeny okam&#382;it&igrave;  a &Uacute;&egrave;ty mohou b&yacute;t okam&#382;it&igrave;  pou&#382;ity.';
$lng['ftp']['account_add'] = 'Vytvo&oslash;it &Uacute;&egrave;et';

/**
 * MySQL
 */

$lng['mysql']['databasename'] = 'jm&eacute;no u&#382;ivatele/datab&aacute;ze';
$lng['mysql']['databasedescription'] = 'popis datab&aacute;ze';
$lng['mysql']['database_create'] = 'Vytvo&oslash;it datab&aacute;zi';

/**
 * Extras
 */

$lng['extras']['description'] = 'Zde m&ugrave;&#382;ete vkl&aacute;dat extra v&igrave; ci, nap&oslash;&iacute;klad ochranu adres&aacute;&oslash;&ugrave;.<br />Syst&eacute;m pot&oslash;ebuje n&igrave; jak&yacute; &egrave;as, ne&#382; se zm&igrave; ny projev&iacute;.';
$lng['extras']['directoryprotection_add'] = 'P&oslash;idat ochranu adres&aacute;&oslash;e';
$lng['extras']['view_directory'] = 'zobrazit obsah adres&aacute;&oslash;e';
$lng['extras']['pathoptions_add'] = 'p&oslash;idat nastaven&iacute; cesty';
$lng['extras']['directory_browsing'] = 'prohl&iacute;&#382;en&iacute; obsahu adres&aacute;&oslash;e';
$lng['extras']['pathoptions_edit'] = 'upravit nastaven&iacute; cesty';
$lng['extras']['error404path'] = '404';
$lng['extras']['error403path'] = '403';
$lng['extras']['error500path'] = '500';
$lng['extras']['error401path'] = '401';
$lng['extras']['errordocument404path'] = 'URL k Chybov&eacute; str&aacute;nce 404';
$lng['extras']['errordocument403path'] = 'URL k Chybov&eacute; str&aacute;nce 403';
$lng['extras']['errordocument500path'] = 'URL k Chybov&eacute; str&aacute;nce 500';
$lng['extras']['errordocument401path'] = 'URL k Chybov&eacute; str&aacute;nce 401';

/**
 * Errors
 */

$lng['error']['error'] = 'Chyba';
$lng['error']['directorymustexist'] = 'Adres&aacute;&oslash; %s mus&iacute; existovat. Pros&iacute;m vytvo&oslash;te jej s pomoc&iacute; Va&#353;eho FTP klienta.';
$lng['error']['filemustexist'] = 'Soubor %s mus&iacute; existovat.';
$lng['error']['allresourcesused'] = 'U&#382; jste pou&#382;ili v&#353;echny sv&eacute; zdroje.';
$lng['error']['domains_cantdeletemaindomain'] = 'Nem&ugrave;&#382;ete smazat dom&eacute;nu, kter&aacute; se pou&#382;&iacute;v&aacute; jako e-mailov&aacute; dom&eacute;na.';
$lng['error']['domains_canteditdomain'] = 'Nem&ugrave;&#382;ete upravovat tuto dom&eacute;nu. Byla zak&aacute;z&aacute;na adminem.';
$lng['error']['domains_cantdeletedomainwithemail'] = 'Nem&ugrave;&#382;ete smazat dom&eacute;nu, kter&aacute; se pou&#382;&iacute;v&aacute; jako e-mailov&aacute; dom&eacute;na. Nejd&oslash;&iacute;ve sma&#382;te v&#353;echny emailov&eacute; adresy.';
$lng['error']['firstdeleteallsubdomains'] = 'Mus&iacute;te smazat v&#353;echny subdom&eacute;ny ne&#382; budete moci vytvo&oslash;it "wildcard" dom&eacute;nu.';
$lng['error']['youhavealreadyacatchallforthisdomain'] = 'U&#382; jste definovali "catchall" pro tuto dom&eacute;nu.';
$lng['error']['ftp_cantdeletemainaccount'] = 'Nem&ugrave;&#382;ete smazat sv&ugrave;j hlavn&iacute; FTP &Uacute;&egrave;et';
$lng['error']['login'] = 'U&#382;ivatelsk&eacute; jm&eacute;no nebo heslo, kter&eacute; jste zadali, je &#353;patn&eacute;. Pros&iacute;m zkuste to znovu!';
$lng['error']['login_blocked'] = 'Tento &Uacute;&egrave;et byl zablokov&aacute;n z d&ugrave;vodu p&oslash;&iacute;li&#353; velk&eacute;ho mno&#382;stv&iacute; chyb p&oslash;i p&oslash;ihl&aacute;&#353;en&iacute;. <br />Pros&iacute;m zkuste to znovu za ' . $settings['login']['deactivatetime'] . ' sekund.';
$lng['error']['notallreqfieldsorerrors'] = 'Nevyplnili jste v&#353;echna pol&iacute;&egrave;ka nebo jsou n&igrave; kter&eacute; vypln&igrave; na &#353;patn&igrave; .';
$lng['error']['oldpasswordnotcorrect'] = 'Star&eacute; heslo nen&iacute; spr&aacute;vn&eacute;.';
$lng['error']['youcantallocatemorethanyouhave'] = 'Nem&ugrave;&#382;ete alokovat v&iacute;ce zdroj&ugrave; ne&#382; sami vlastn&iacute;te';
$lng['error']['mustbeurl'] = 'Vlo&#382;ili jste nespr&aacute;vnou nebo nekompletn&iacute; url (nap&oslash;. http://somedomain.com/error404.htm)';
$lng['error']['invalidpath'] = 'Nevybrali jste spr&aacute;vnou url (mo&#382;n&aacute; probl&eacute;m s "dirlistingem"?)';
$lng['error']['stringisempty'] = 'Chyb&igrave; j&iacute;c&iacute; vstup v poli';
$lng['error']['stringiswrong'] = '&#353;patn&yacute; vstup v poli';
$lng['error']['myloginname'] = '\'' . $lng['login']['username'] . '\'';
$lng['error']['mypassword'] = '\'' . $lng['login']['password'] . '\'';
$lng['error']['oldpassword'] = '\'' . $lng['changepassword']['old_password'] . '\'';
$lng['error']['newpassword'] = '\'' . $lng['changepassword']['new_password'] . '\'';
$lng['error']['newpasswordconfirm'] = '\'' . $lng['changepassword']['new_password_confirm'] . '\'';
$lng['error']['newpasswordconfirmerror'] = 'Nov&eacute; heslo se neshoduje s t&iacute;m pro potvrzen&iacute;';
$lng['error']['myname'] = '\'' . $lng['customer']['name'] . '\'';
$lng['error']['myfirstname'] = '\'' . $lng['customer']['firstname'] . '\'';
$lng['error']['emailadd'] = '\'' . $lng['customer']['email'] . '\'';
$lng['error']['mydomain'] = '\'Domain\'';
$lng['error']['mydocumentroot'] = '\'Documentroot\'';
$lng['error']['loginnameexists'] = 'P&oslash;ihla&#353;ovac&iacute; jm&eacute;no %s ji&#382; existuje';
$lng['error']['emailiswrong'] = 'Emailov&aacute; adresa %s obsahuje nepovolen&eacute; znaky nebo je nekompletn&iacute;';
$lng['error']['loginnameiswrong'] = 'P&oslash;ihla&#353;ovac&iacute; jm&eacute;no %s obsahuje nepovolen&eacute; znaky';
$lng['error']['userpathcombinationdupe'] = 'Kombinace U&#382;ivatelsk&eacute;ho jm&eacute;na a cesty ji&#382; existuje';
$lng['error']['patherror'] = 'Obecn&aacute; chyba! Cesta nem&ugrave;&#382;e b&yacute;t pr&aacute;zdn&aacute;';
$lng['error']['errordocpathdupe'] = 'Mo&#382;nost pro cestu %s ji&#382; existuje';
$lng['error']['adduserfirst'] = 'Vytvo&oslash;te pros&iacute;m nejd&oslash;&iacute;ve z&aacute;kazn&iacute;ka';
$lng['error']['domainalreadyexists'] = 'Dom&eacute;na %s je ji&#382; p&oslash;i&oslash;azena k z&aacute;kazn&iacute;kovi';
$lng['error']['nolanguageselect'] = 'Nebyl vybr&aacute;n &#382;&aacute;dn&yacute; jazyk.';
$lng['error']['nosubjectcreate'] = 'Mus&iacute;te definovat t&eacute;ma pro tuto e-mailovou &#353;ablonu.';
$lng['error']['nomailbodycreate'] = 'Mus&iacute;te definovat text e-mailu pro tuto e-mailovou &#353;ablonu.';
$lng['error']['templatenotfound'] = '&#353;ablona nebyla nalezena.';
$lng['error']['alltemplatesdefined'] = 'Nem&ugrave;&#382;ete definovat v&iacute;ce &#353;ablon, v&#353;echny jazyky jsou ji&#382; podporov&aacute;ny.';
$lng['error']['wwwnotallowed'] = 'www nen&iacute; povoleno pro subdom&eacute;ny.';
$lng['error']['subdomainiswrong'] = 'Subdom&eacute;na %s obsahuje neplatn&eacute; znaky.';
$lng['error']['domaincantbeempty'] = 'Jm&eacute;no dom&eacute;ny nesm&iacute; b&yacute;t pr&aacute;zdn&eacute;.';
$lng['error']['domainexistalready'] = 'Dom&eacute;na %s ji&#382; existuje.';
$lng['error']['domainisaliasorothercustomer'] = 'Vybran&yacute; alias pro dom&eacute;nu je bu&iuml; sama aliasem dom&eacute;ny nebo pat&oslash;&iacute; jin&eacute;mu z&aacute;kazn&iacute;kovi.';
$lng['error']['emailexistalready'] = 'E-mailov&aacute; adresa %s ji&#382; existuje.';
$lng['error']['maindomainnonexist'] = 'Hlavn&iacute; dom&eacute;na %s neexistuje.';
$lng['error']['destinationnonexist'] = 'Pros&iacute;m vytvo&oslash;te p&oslash;epos&iacute;latele v poli \'C&iacute;l\'.';
$lng['error']['destinationalreadyexistasmail'] = 'P&oslash;epos&iacute;la&egrave; na %s ji&#382; existuje jako aktivn&iacute; emailov&aacute; adresa.';
$lng['error']['destinationalreadyexist'] = 'U&#382; jste nastavili p&oslash;epos&iacute;la&egrave; na %s .';
$lng['error']['destinationiswrong'] = 'P&oslash;epos&iacute;la&egrave; %s obsahuje nespr&aacute;vn&eacute; znaky nebo nen&iacute; kompletn&iacute;.';
$lng['error']['domainname'] = $lng['domains']['domainname'];

/**
 * Questions
 */

$lng['question']['question'] = 'Bezpe&egrave;nostn&iacute; ot&aacute;zka';
$lng['question']['admin_customer_reallydelete'] = 'Chcete opravdu smazat u&#382;ivatele %s? Akci nelze vz&iacute;t zp&igrave; t!';
$lng['question']['admin_domain_reallydelete'] = 'Chcete opravdu smazat dom&eacute;nu %s?';
$lng['question']['admin_domain_reallydisablesecuritysetting'] = 'Chcete opravdu deaktivovat tato Bezpe&egrave;nostn&iacute; nastaven&iacute; (OpenBasedir a/nebo SafeMode)?';
$lng['question']['admin_admin_reallydelete'] = 'Chcete opravdu smazat administr&aacute;tory %s? Ka&#382;d&yacute; z&aacute;kazn&iacute;k a dom&eacute;na bude nastavena k Va&#353;emu &Uacute;&egrave;tu.';
$lng['question']['admin_template_reallydelete'] = 'Chcete opravdu smazat &#353;ablonu \'%s\'?';
$lng['question']['domains_reallydelete'] = 'Chcete opravdu smazat dom&eacute;nu %s?';
$lng['question']['email_reallydelete'] = 'Opravdu chcete smazat e-mailovou adresu %s?';
$lng['question']['email_reallydelete_account'] = 'Chcete opravdu smazat e-mailov&yacute; &Uacute;&egrave;et %s?';
$lng['question']['email_reallydelete_forwarder'] = 'Chcete opravdu smazat p&oslash;epos&iacute;la&egrave; %s?';
$lng['question']['extras_reallydelete'] = 'Chcete opravdu odstranit ochranu adres&aacute;&oslash;e %s?';
$lng['question']['extras_reallydelete_pathoptions'] = 'Opravdu chcete smazat nastaven&iacute; cesty pro %s?';
$lng['question']['ftp_reallydelete'] = 'Opravdu chcete smazat FTP &Uacute;&egrave;et %s?';
$lng['question']['mysql_reallydelete'] = 'Opravdu chcete smazat datab&aacute;zi %s? Tato akce nem&ugrave;&#382;e b&yacute;t vzata zp&igrave; t!';
$lng['question']['admin_configs_reallyrebuild'] = 'Opravdu chcete rebuildovat apache a nabindovat konfigura&egrave;n&iacute; soubory?';

/**
 * Mails
 */

$lng['mails']['pop_success']['mailbody'] = 'Dobr&yacute; den,\n\nV&aacute;&#353; e-mailov&yacute; &Uacute;&egrave;et {EMAIL}\nbyl v po&oslash;&aacute;dku nastaven.\n\nToto je automaticky vytvo&oslash;en&yacute;\ne-mail, pros&iacute;m neodpov&iacute;dejte na n&igrave; j!\n\nP&oslash;ejeme hezk&yacute; den, Froxlor-Team';
$lng['mails']['pop_success']['subject'] = 'Po&#353;tovn&iacute; &Uacute;&egrave;et byl &Uacute;sp&igrave; &#353;n&igrave;  nastaven';
$lng['mails']['createcustomer']['mailbody'] = 'Dobr&yacute; den, {FIRSTNAME} {NAME},\n\nzde jsou informace o Va&#353;em &Uacute;&egrave;tu:\n\nU&#382;ivatel: {USERNAME}\nHeslo: {PASSWORD}\n\nD&igrave; kujeme,\nFroxlor-Team';
$lng['mails']['createcustomer']['subject'] = 'Informace o &Uacute;&egrave;tu';

/**
 * Admin
 */

$lng['admin']['overview'] = 'P&oslash;ehled';
$lng['admin']['ressourcedetails'] = 'Pou&#382;it&eacute; zdroje';
$lng['admin']['systemdetails'] = 'Detaily syst&eacute;mu';
$lng['admin']['froxlordetails'] = 'Froxlor Detaily';
$lng['admin']['installedversion'] = 'Nainstalovan&aacute; verze';
$lng['admin']['latestversion'] = 'Posledn&iacute; verze';
$lng['admin']['lookfornewversion']['clickhere'] = 'hledat p&oslash;es webservice';
$lng['admin']['lookfornewversion']['error'] = 'Chyba p&oslash;i &egrave;ten&iacute;';
$lng['admin']['resources'] = 'Zdroje';
$lng['admin']['customer'] = 'Z&aacute;kazn&iacute;k';
$lng['admin']['customers'] = 'Z&aacute;kazn&iacute;ci';
$lng['admin']['customer_add'] = 'Vytvo&oslash;it z&aacute;kazn&iacute;ka';
$lng['admin']['customer_edit'] = 'Upravit z&aacute;kazn&iacute;ka';
$lng['admin']['domains'] = 'Dom&eacute;ny';
$lng['admin']['domain_add'] = 'Vytvo&oslash;it dom&eacute;nu';
$lng['admin']['domain_edit'] = 'Upravit dom&eacute;nu';
$lng['admin']['subdomainforemail'] = 'Subdom&eacute;ny jako emailov&eacute; dom&eacute;ny';
$lng['admin']['admin'] = 'Administr&aacute;tor';
$lng['admin']['admins'] = 'Administr&aacute;to&oslash;i';
$lng['admin']['admin_add'] = 'Vytvo&oslash;it administr&aacute;tora';
$lng['admin']['admin_edit'] = 'Upravit administr&aacute;tora';
$lng['admin']['customers_see_all'] = 'M&ugrave;&#382;e vid&igrave; t v&#353;echy z&aacute;kazn&iacute;ky?';
$lng['admin']['domains_see_all'] = 'M&ugrave;&#382;e vid&igrave; t v&#353;echny dom&eacute;ny?';
$lng['admin']['change_serversettings'] = 'M&ugrave;&#382;e m&igrave; nit nastaven&iacute; serveru?';
$lng['admin']['server'] = 'Server';
$lng['admin']['serversettings'] = 'Nastaven&iacute;';
$lng['admin']['rebuildconf'] = 'P&oslash;ebudovat konfigura&egrave;n&iacute; soubory';
$lng['admin']['stdsubdomain'] = 'Standardn&iacute; subdom&eacute;na';
$lng['admin']['stdsubdomain_add'] = 'Vytvo&oslash;it standardn&iacute; subdom&eacute;nu';
$lng['admin']['phpenabled'] = 'PHP zapnuto';
$lng['admin']['deactivated'] = 'Deaktivov&aacute;no';
$lng['admin']['deactivated_user'] = 'Deaktivovat u&#382;ivatele';
$lng['admin']['sendpassword'] = 'Zaslat heslo';
$lng['admin']['ownvhostsettings'] = 'Vlastn&iacute; vHost-nastaven&iacute;';
$lng['admin']['configfiles']['serverconfiguration'] = 'Konfigurace';
$lng['admin']['configfiles']['files'] = '<b>Konfigura&egrave;n&iacute; soubory:</b> Pros&iacute;m zm&igrave; te n&aacute;sleduj&iacute;c&iacute; soubory nabo je vytvo&oslash;te s<br /> n&aacute;sleduj&iacute;c&iacute;m obsahem, pokud neexistuj&iacute;.<br /><b>Pozn&aacute;mka:</b> MySQL heslo nebylo nahrazeno z bezpe&egrave;nostn&iacute;ch d&ugrave;vod&ugrave;.<br />Pros&iacute;m nahra&iuml;te &quot;MYSQL_PASSWORD&quot; sv&yacute;m vlastn&iacute;m. Pokud jste zapomn&igrave; li sv&eacute; mysql heslo<br />najdete jej v &quot;lib/userdata.inc.php&quot;.';
$lng['admin']['configfiles']['commands'] = '<b>P&oslash;&iacute;kazy:</b> Pros&iacute;m spus?te n&aacute;sleduj&iacute;c&iacute; p&oslash;&iacute;kazy v p&oslash;&iacute;kazov&eacute;m &oslash;&aacute;dku.';
$lng['admin']['configfiles']['restart'] = '<b>Restart:</b> Pros&iacute;m spus?te n&iacute;sleduj&iacute;c&iacute; p&oslash;&iacute;kazy v p&oslash;&iacute;kazov&eacute;m &oslash;&aacute;dku, aby jste nahr&aacute;li novou konfiguraci.';
$lng['admin']['templates']['templates'] = '&#353;ablony';
$lng['admin']['templates']['template_add'] = 'P&oslash;idat &#353;ablonu';
$lng['admin']['templates']['template_edit'] = 'Upravit &#353;ablonu';
$lng['admin']['templates']['action'] = 'Akce';
$lng['admin']['templates']['email'] = 'E-Mail';
$lng['admin']['templates']['subject'] = 'P&oslash;edm&igrave; t';
$lng['admin']['templates']['mailbody'] = 'T&igrave; lo mailu';
$lng['admin']['templates']['createcustomer'] = 'Uv&iacute;tac&iacute; mail pro nov&eacute; z&aacute;kazn&iacute;ky';
$lng['admin']['templates']['pop_success'] = 'Uv&iacute;tac&iacute; mail pro nov&eacute; emailov&eacute; &Uacute;&egrave;ty';
$lng['admin']['templates']['template_replace_vars'] = 'Prom&igrave; nn&eacute; k nahrazen&iacute; v &#353;ablon&igrave; :';
$lng['admin']['templates']['FIRSTNAME'] = 'Nahrazeno k&oslash;estn&iacute;m jm&eacute;nem z&aacute;kazn&iacute;ka.';
$lng['admin']['templates']['NAME'] = 'Nahrazeno jm&eacute;nem z&aacute;kazn&iacute;ka.';
$lng['admin']['templates']['USERNAME'] = 'Nahrazeno u&#382;ivatelsk&yacute;m jm&eacute;nem z&aacute;kazn&iacute;ka.';
$lng['admin']['templates']['PASSWORD'] = 'Nahrazeno z&aacute;kazn&iacute;kov&yacute;m heslem.';
$lng['admin']['templates']['EMAIL'] = 'Nahrazeno adresou POP3/IMAP &Uacute;&egrave;tu.';

/**
 * Serversettings
 */

$lng['serversettings']['session_timeout']['title'] = 'Session Timeout';
$lng['serversettings']['session_timeout']['description'] = 'Jak dlouho mus&yacute; b&yacute;t u&#382;ivatel neaktivn&iacute;, ne&#382; session vypr&#353;&iacute; (sekundy)?';
$lng['serversettings']['accountprefix']['title'] = 'Z&aacute;kazn&iacute;kova p&oslash;edpona';
$lng['serversettings']['accountprefix']['description'] = 'Jk&eacute; p&oslash;edpony by m&igrave; ly m&iacute;t &Uacute;&egrave;ty z&aacute;kazn&iacute;k&ugrave;?';
$lng['serversettings']['mysqlprefix']['title'] = 'SQL p&oslash;edpona';
$lng['serversettings']['mysqlprefix']['description'] = 'Jak&eacute; p&oslash;edpony by m&igrave; ly m&iacute;t &Uacute;&egrave;ty mysql?';
$lng['serversettings']['ftpprefix']['title'] = 'FTP p&oslash;edpona';
$lng['serversettings']['ftpprefix']['description'] = 'Jakou p&oslash;edponu by m&igrave; ly m&iacute;t ftp &Uacute;&egrave;ty?';
$lng['serversettings']['documentroot_prefix']['title'] = 'Dom&aacute;c&iacute; adres&aacute;&oslash;';
$lng['serversettings']['documentroot_prefix']['description'] = 'Kde by m&igrave; ly b&yacute;t ulo&#382;eny v&#353;echny dom&aacute;c&iacute; adres&aacute;&oslash;e?';
$lng['serversettings']['logfiles_directory']['title'] = 'Adres&aacute;&oslash; pro log soubory';
$lng['serversettings']['logfiles_directory']['description'] = 'Kde by m&igrave; ly b&yacute;t v&#353;echny log soubory ulo&#382;eny?';
$lng['serversettings']['ipaddress']['title'] = 'IP-Adresa';
$lng['serversettings']['ipaddress']['description'] = 'Jak&aacute; je IP adresa tohoto serveru?';
$lng['serversettings']['hostname']['title'] = 'Jm&eacute;no hosta';
$lng['serversettings']['hostname']['description'] = 'Jak&eacute; je jm&eacute;no hosta tohoto serveru?';
$lng['serversettings']['apachereload_command']['title'] = 'P&oslash;&iacute;kaz pro reload apache';
$lng['serversettings']['apachereload_command']['description'] = 'Jak&yacute; je p&oslash;&iacute;kaz, kter&yacute;m apache znovunahraje sv&eacute; konfigura&egrave;n&iacute; soubory?';
$lng['serversettings']['bindconf_directory']['title'] = 'Bindujte konfigura&egrave;n&iacute; adres&aacute;&oslash;';
$lng['serversettings']['bindconf_directory']['description'] = 'Kde by m&igrave; ly b&yacute;t ulo&#382;eny "bind configfiles"?';
$lng['serversettings']['bindreload_command']['title'] = 'Bind reload p&oslash;&iacute;kaz';
$lng['serversettings']['bindreload_command']['description'] = 'Jak&yacute; je p&oslash;&iacute;kaz pro znovunahr&aacute;n&iacute; "bind configfiles"?';
$lng['serversettings']['binddefaultzone']['title'] = 'Bind v&yacute;choz&iacute; zna';
$lng['serversettings']['binddefaultzone']['description'] = 'Jak&yacute; je n&aacute;zev v&yacute;choz&iacute; zny?';
$lng['serversettings']['vmail_uid']['title'] = 'UID-mail&ugrave;';
$lng['serversettings']['vmail_uid']['description'] = 'Jak&eacute; UserID by m&igrave; ly e-maily m&iacute;t?';
$lng['serversettings']['vmail_gid']['title'] = 'GID-mail&ugrave;';
$lng['serversettings']['vmail_gid']['description'] = 'Jak&eacute; GroupID by m&igrave; ly maily m&iacute;t?';
$lng['serversettings']['vmail_homedir']['title'] = 'Mails-Home adres&aacute;&oslash;';
$lng['serversettings']['vmail_homedir']['description'] = 'Kam by se m&igrave; ly v&#353;echny maily ukl&aacute;dat?';
$lng['serversettings']['adminmail']['title'] = 'Odes&iacute;latel';
$lng['serversettings']['adminmail']['description'] = 'Jak&aacute; je odes&iacute;latelova adresa pro emaily odeslan&eacute; z Panelu?';
$lng['serversettings']['phpmyadmin_url']['title'] = 'phpMyAdminova URL';
$lng['serversettings']['phpmyadmin_url']['description'] = 'Jak&aacute; je URL adresa phpMyAdmin? (mus&iacute; za&egrave;&iacute;nat http(s)://)';
$lng['serversettings']['webmail_url']['title'] = 'WebMailov&aacute; URL';
$lng['serversettings']['webmail_url']['description'] = 'Jak&aacute; je URL adresa k WebMailu? (mus&iacute; za&egrave;&iacute;nat with http(s)://)';
$lng['serversettings']['webftp_url']['title'] = 'WebFTP URL';
$lng['serversettings']['webftp_url']['description'] = 'Jak&aacute; je URL k WebFTP? (mus&iacute; za&egrave;&iacute;nat with http(s)://)';
$lng['serversettings']['language']['description'] = 'Jak&yacute; je v&yacute;choz&iacute; jazyk Va&#353;eho serveru?';
$lng['serversettings']['maxloginattempts']['title'] = 'Maxim&aacute;ln&iacute; po&egrave;et pokus&ugrave; o p&oslash;ihl&aacute;&#353;en&iacute;';
$lng['serversettings']['maxloginattempts']['description'] = 'Maxim&aacute;ln&iacute; po&egrave;et pokus&ugrave; o p&oslash;ihl&aacute;&#353;en&iacute; k &Uacute;&egrave;tu, ne&#382; se &Uacute;&egrave;et zablokuje.';
$lng['serversettings']['deactivatetime']['title'] = 'Deaktivovan&yacute; po dobu';
$lng['serversettings']['deactivatetime']['description'] = '&egrave;as (sek.) po kter&yacute; bude &Uacute;&egrave;et deaktivov&aacute;n pro p&oslash;&iacute;li&#353; mnoho pokus&ugrave; o p&oslash;ihl&aacute;&#353;en&iacute;.';
$lng['serversettings']['pathedit']['title'] = 'Typ vstupu cesty';
$lng['serversettings']['pathedit']['description'] = 'M&igrave; la by b&yacute;t cesta vyb&iacute;r&aacute;na pomoc&iacute; vyskakovac&iacute;ho menu nebo vstupn&iacute;m polem?';
$lng['serversettings']['nameservers']['title'] = 'Nameservery';
$lng['serversettings']['nameservers']['description'] = 'St&oslash;edn&iacute;kem odd&igrave; len&yacute; seznam obsahuj&iacute;c&iacute; hostname v&#353;ech nameserver&ugrave;. Prvn&iacute; bude prim&aacute;rn&iacute;.';
$lng['serversettings']['mxservers']['title'] = 'MX servery';
$lng['serversettings']['mxservers']['description'] = 'St&oslash;edn&iacute;kem odd&igrave; len&yacute; seznam obsahuj&iacute;c&iacute; p&aacute;ry &egrave;&iacute;sel a hostname odd&igrave; len&yacute;ch mezerou (nap&oslash;. \'10 mx.example.com\') obsahuj&iacute;c&iacute; mx servery.';

/**
 * CHANGED BETWEEN 1.2.12 and 1.2.13
 */

$lng['mysql']['description'] = 'Zde m&ugrave;&#382;ete vytv&aacute;&oslash;et a m&igrave; nit sv&eacute; MySQL-Datab&aacute;ze.<br />Zm&igrave; ny jsou provedeny okam&#382;it&igrave;  a datab&aacute;ze m&ugrave;&#382;e b&yacute;t okam&#382;it&igrave;  pou&#382;&iacute;v&aacute;na.<br />V menu vlevo m&ugrave;&#382;ete naj&iacute;t n&aacute;stroj phpMyAdmin se kter&yacute;m m&ugrave;&#382;ete jednodu&#353;e upravovat svou datab&aacute;zi.<br /><br />Pro pou&#382;it&iacute; datab&aacute;ze ve sv&yacute;ch php skriptech pou&#382;ijte n&aacute;sleduj&iacute;c&iacute; nastaven&iacute;: (Data <i>kurz&iacute;vou</i> mus&iacute; b&yacute;t zm&igrave; n&igrave; na na V&aacute;mi vlo&#382;en&eacute; hodnoty!)<br />Host: <b><SQL_HOST></b><br />U&#382;ivatelsk&eacute; jm&eacute;no: <b><i>Databasename</i></b><br />Heslo: <b><i>heslo kter&eacute; jste zvolili</i></b><br />Datab&aacute;ze: <b><i>Databasename</i></b>';

/**
 * ADDED BETWEEN 1.2.12 and 1.2.13
 */

$lng['serversettings']['paging']['title'] = 'Z&aacute;znam&ugrave; na str&aacute;nku';
$lng['serversettings']['paging']['description'] = 'Kolik z&aacute;znam&ugrave; by m&igrave; lo b&yacute;t zobrazeno na str&aacute;nce? (0 = zru&#353;it str&aacute;nkov&aacute;n&iacute;)';
$lng['error']['ipstillhasdomains'] = 'IP/Port kombinace, kterou chcete smazat m&aacute; st&aacute;le p&oslash;i&oslash;azen&eacute; dom&eacute;ny, pros&iacute;m p&oslash;e&oslash;a&iuml;te je k jin&eacute; IP/Port kombinaci ne&#382; sma&#382;ete tuto IP/Port kombinaci.';
$lng['error']['cantdeletedefaultip'] = 'Nem&ugrave;&#382;ete smazat IP/Port kombinaci v&yacute;choz&iacute;ho p&oslash;eprodejce, pros&iacute;m vytvo&oslash;te jinou IP/Port kombinaci v&yacute;choz&iacute; pro p&oslash;eprodejce ne&#382; sma&#382;ete tuto IP/Port kombinaci.';
$lng['error']['cantdeletesystemip'] = 'Nem&ugrave;&#382;ete smazat posledn&iacute; syst&eacute;movou IP, bu&iuml; vytvo&oslash;te novou IP/Port kombinaci pro syst&eacute;movou IP nebo zm&igrave; te IP syst&eacute;mu.';
$lng['error']['myipaddress'] = '\'IP\'';
$lng['error']['myport'] = '\'Port\'';
$lng['error']['myipdefault'] = 'Mus&iacute;te vybrat IP/Port kombinaci kter&aacute; by se m&igrave; la st&aacute;t v&yacute;choz&iacute;.';
$lng['error']['myipnotdouble'] = 'Tato kombinace IP/Portu ji&#382; existuje.';
$lng['question']['admin_ip_reallydelete'] = 'Chcete opravdu smayat IP adresu %s?';
$lng['admin']['ipsandports']['ipsandports'] = 'IP a Porty';
$lng['admin']['ipsandports']['add'] = 'P&oslash;idat IP/Port';
$lng['admin']['ipsandports']['edit'] = 'Upravit IP/Port';
$lng['admin']['ipsandports']['ipandport'] = 'IP/Port';
$lng['admin']['ipsandports']['ip'] = 'IP';
$lng['admin']['ipsandports']['port'] = 'Port';

// ADDED IN 1.2.13-rc3

$lng['error']['cantchangesystemip'] = 'Nem&ugrave;&#382;ete zm&igrave; nit posledn&iacute; syst&eacute;movou IP, bu&iuml; vytvo&oslash;te novou IP/Port kombinaci pro syst&eacute;movou IP nebo zm&igrave; te IP syst&eacute;mu.';
$lng['question']['admin_domain_reallydocrootoutofcustomerroot'] = 'Jste si jisti, &#382;e chcete aby root dokument&ugrave; pro tuto dom&eacute;nu nebyl v "customerroot" z&aacute;kazn&iacute;ka?';

// ADDED IN 1.2.14-rc1

$lng['admin']['memorylimitdisabled'] = 'Zak&aacute;z&aacute;no';
$lng['domain']['openbasedirpath'] = 'OpenBasedir-cesta';
$lng['domain']['docroot'] = 'Cesta z pol&iacute;&egrave;ka naho&oslash;e';
$lng['domain']['homedir'] = 'Domovn&iacute; adres&aacute;&oslash;';
$lng['admin']['valuemandatory'] = 'Tato hodnota je povinn&aacute;';
$lng['admin']['valuemandatorycompany'] = 'Bu&iuml; &quot;jm&eacute;no&quot; a &quot;k&oslash;estn&iacute; jm&eacute;no&quot; nebo &quot;spole&egrave;nost&quot; mus&iacute; b&yacute;t vypln&igrave; na';
$lng['menue']['main']['username'] = 'P&oslash;ihl&aacute;&#353;en(a) jako: ';
$lng['panel']['urloverridespath'] = 'URL (p&oslash;ep&iacute;&#353;e cestu)';
$lng['panel']['pathorurl'] = 'Cesta nebo URL';
$lng['error']['sessiontimeoutiswrong'] = 'Pouze &egrave;&iacute;seln&eacute; &quot;Session Timeout&quot; je povoleno.';
$lng['error']['maxloginattemptsiswrong'] = 'ouze &egrave;&iacute;seln&eacute; &quot;Maxim&aacute;ln&iacute; po&egrave;et pokus&ugrave; o p&oslash;ihl&aacute;&#353;en&iacute;&quot; je povoleno.';
$lng['error']['deactivatetimiswrong'] = 'ouze &egrave;&iacute;seln&eacute; &quot;&egrave;as deaktivace&quot; je povoleno.';
$lng['error']['accountprefixiswrong'] = '&quot;P&oslash;edpona u&#382;ivatele&quot; je &#353;patn&igrave; .';
$lng['error']['mysqlprefixiswrong'] = '&quot;SQL p&oslash;edpona&quot; je &#353;patn&igrave; .';
$lng['error']['ftpprefixiswrong'] = '&quot;FTP p&oslash;edpona&quot; je &#353;patn&igrave; .';
$lng['error']['ipiswrong'] = '&quot;IP-Adresa&quot; je &#353;patn&igrave; . Pouze validn&iacute; IP adresa je povolena.';
$lng['error']['vmailuidiswrong'] = '&quot;Mails-uid&quot; je &#353;patn&igrave; . Je povoleno pouze &egrave;&iacute;seln&eacute; UID.';
$lng['error']['vmailgidiswrong'] = '&quot;Mails-gid&quot; je &#353;patn&igrave; . Je povoleno pouze &egrave;&iacute;seln&eacute; GID.';
$lng['error']['adminmailiswrong'] = '&quot;Sender-address&quot; je &#353;patn&igrave; . Je povolena pouze validn&iacute; emailov&aacute; adresa.';
$lng['error']['pagingiswrong'] = '&quot;Entries per Page&quot;-value je &#353;patn&igrave; . Jsou povolena pouze &egrave;&iacute;sla.';
$lng['error']['phpmyadminiswrong'] = 'phpMyAdmin-url nan&iacute; spr&aacute;vn&aacute; url.';
$lng['error']['webmailiswrong'] = 'WebMail-odkaz nen&iacute; spr&aacute;vn&yacute; odkaz.';
$lng['error']['webftpiswrong'] = 'WebFTP-odkaz nen&iacute; spr&aacute;vn&yacute; odkaz.';
$lng['domains']['hasaliasdomains'] = 'M&aacute; aliasov&eacute; dom&eacute;ny';
$lng['serversettings']['defaultip']['title'] = 'V&yacute;choz&iacute; IP/Port';
$lng['serversettings']['defaultip']['description'] = 'Jak&aacute; je v&yacute;choz&iacute; IP/Port kombinace?';
$lng['domains']['statstics'] = 'Statistika pou&#382;it&iacute;';
$lng['panel']['ascending'] = 'sestupn&igrave; ';
$lng['panel']['decending'] = 'vzestupn&igrave; ';
$lng['panel']['search'] = 'Vyhled&aacute;v&aacute;n&iacute;';
$lng['panel']['used'] = 'pou&#382;ito';

// ADDED IN 1.2.14-rc3

$lng['panel']['translator'] = 'P&oslash;ekladatel';

// ADDED IN 1.2.14-rc4

$lng['error']['stringformaterror'] = 'Hodnota pole &quot;%s&quot; nen&iacute; v o&egrave;ek&aacute;van&eacute;m form&aacute;tu.';

// ADDED IN 1.2.15-rc1

$lng['admin']['serversoftware'] = 'Software serveru';
$lng['admin']['phpversion'] = 'PHP-Verze';
$lng['admin']['phpmemorylimit'] = 'PHP-Limit-Pam&igrave; ti';
$lng['admin']['mysqlserverversion'] = 'MySQL verze serveru';
$lng['admin']['mysqlclientversion'] = 'MySQL verze klienta';
$lng['admin']['webserverinterface'] = 'Webserver rozhran&iacute;';
$lng['domains']['isassigneddomain'] = 'Je p&oslash;i&oslash;azen&aacute; dom&eacute;na';
$lng['serversettings']['phpappendopenbasedir']['title'] = 'Cesty k p&oslash;id&aacute;n&iacute; k OpenBasedir';
$lng['serversettings']['phpappendopenbasedir']['description'] = 'Tyto cesty (odd&igrave; leny pomoc&iacute; "colons") budou vlo&#382;eny  do OpenBasedir-statementu v ka&#382;d&eacute;m vhost-containeru.';

// CHANGED IN 1.2.15-rc1

$lng['error']['loginnameissystemaccount'] = 'Nem&ugrave;&#382;ete vytvo&oslash;it &Uacute;&egrave;ty, kter&eacute; jsou podobn&eacute; syst&eacute;mov&yacute;m &Uacute;&egrave;t&ugrave;m (nap&oslash;&iacute;klad za&egrave;&iacute;naj&iacute; &quot;%s&quot;). Pros&iacute;m vlo&#382;te jin&eacute; jm&eacute;no &Uacute;&egrave;tu.';
$lng['error']['youcantdeleteyourself'] = 'Z bezpe&egrave;nostn&iacute;ch d&ugrave;vod&ugrave; se nem&ugrave;&#382;ete smazat.';
$lng['error']['youcanteditallfieldsofyourself'] = 'Pozn&aacute;mka: Z bezpe&egrave;nostn&iacute;ch d&ugrave;vod&ugrave; nem&ugrave;&#382;ete upravovat v&#353;echna pole sv&eacute;ho &Uacute;&egrave;tu.';

// ADDED IN 1.2.16-svn1

$lng['serversettings']['natsorting']['title'] = 'Pou&#382;&iacute;t "lidsk&eacute;" t&oslash;&iacute;d&igrave; n&iacute; v seznamech';
$lng['serversettings']['natsorting']['description'] = '&oslash;adit seznamy jako web1 -> web2 -> web11 m&iacute;sto web1 -> web11 -> web2.';

// ADDED IN 1.2.16-svn2

$lng['serversettings']['deactivateddocroot']['title'] = 'Docroot pro deaktivovan&eacute; u&#382;ivatele';
$lng['serversettings']['deactivateddocroot']['description'] = 'Kdy&#382; bude u&#382;ivatel deaktivov&aacute;n, tato cesta bude pou&#382;ita jako jeho docroot. Ponechte pr&aacute;zdn&eacute;, pokud nechcete vytv&aacute;&oslash;et.';

// ADDED IN 1.2.16-svn4

$lng['panel']['reset'] = 'zru&#353;it zm&igrave; ny';
$lng['admin']['accountsettings'] = 'Nastaven&iacute; &Uacute;&egrave;tu';
$lng['admin']['panelsettings'] = 'Nastaven&iacute; panelu';
$lng['admin']['systemsettings'] = 'Nastaven&iacute; syst&eacute;mu';
$lng['admin']['webserversettings'] = 'Nastaven&iacute; webserveru';
$lng['admin']['mailserversettings'] = 'Nastaven&iacute; mailserveru';
$lng['admin']['nameserversettings'] = 'Nastaven&iacute; nameserveru';
$lng['admin']['updatecounters'] = 'P&oslash;epo&egrave;&iacute;tat vyu&#382;it&iacute; zdroj&ugrave;';
$lng['question']['admin_counters_reallyupdate'] = 'Opravdu chcete p&oslash;epo&egrave;&iacute;tat vyu&#382;it&iacute; zdroj&ugrave;?';
$lng['panel']['pathDescription'] = 'Pokud adres&aacute;&oslash; neexistuje, bude vytvo&oslash;en automaticky.';

// ADDED IN 1.2.16-svn6

$lng['mails']['trafficninetypercent']['mailbody'] = 'V&aacute;&#382;en&yacute; u&#382;ivateli {NAME},\n\nPou&#382;il jste {TRAFFICUSED} MB z V&aacute;mi dostupn&yacute;ch {TRAFFIC} MB p&oslash;enos&ugrave;.\nTo je v&iacute;ce jak 90%.\n\nP&oslash;ejeme hezk&yacute; den, Froxlor-Team';
$lng['mails']['trafficninetypercent']['subject'] = 'Dosahuj&iacute;c va&#353;eho limitu p&oslash;enos&ugrave;';
$lng['admin']['templates']['trafficninetypercent'] = 'Upozorovac&iacute; mail pro z&aacute;kazn&iacute;ky, pokud vy&egrave;erpaj&iacute; 90% z p&oslash;enos&ugrave;';
$lng['admin']['templates']['TRAFFIC'] = 'Nahrazeno p&oslash;enosy, kter&eacute; byly p&oslash;id&igrave; leny u&#382;ivateli.';
$lng['admin']['templates']['TRAFFICUSED'] = 'Nahrazeno p&oslash;enosy, kter&eacute; byly vy&egrave;erp&aacute;ny z&aacute;kazn&iacute;kem.';

// ADDED IN 1.2.16-svn7

$lng['admin']['subcanemaildomain']['never'] = 'Nikdy';
$lng['admin']['subcanemaildomain']['choosableno'] = 'V&yacute;b&igrave; r, v&yacute;choz&iacute; ne';
$lng['admin']['subcanemaildomain']['choosableyes'] = 'V&yacute;b&igrave; r, v&yacute;choz&iacute; ano';
$lng['admin']['subcanemaildomain']['always'] = 'V&#382;dy';
$lng['changepassword']['also_change_webalizer'] = ' tak&eacute; zm&igrave; te heslo pro webalizer statistics';

// ADDED IN 1.2.16-svn8

$lng['serversettings']['mailpwcleartext']['title'] = 'Tak&eacute; ulo&#382;te hesla mailov&yacute;ch &Uacute;&egrave;t&ugrave; ne&#353;ifrovan&aacute; v datab&aacute;zi';
$lng['serversettings']['mailpwcleartext']['description'] = 'Pokud je toto nastaveno na "ano", v&#353;echna hesla budou ukl&aacute;d&aacute;na bez &#353;ifrov&aacute;n&iacute; (&egrave;&iacute;st&yacute; text, &egrave;iteln&aacute; pro kohokoliv s p&oslash;&iacute;stupem k datab&aacute;zi) v tabulce mail_users. Toto aktivujte jen pokud to opravdu pot&oslash;ebujete!';
$lng['serversettings']['mailpwcleartext']['removelink'] = 'Kliknut&iacute;m zde vyma&#382;ete v&#353;echna neza&#353;ifrovan&aacute; hesla z tabulky.';
$lng['question']['admin_cleartextmailpws_reallywipe'] = 'Opravdu chcete vymazat v&#353;echna neza&#353;ifrovan&aacute; hesla pro e-mailov&eacute; &Uacute;&egrave;ty z tabulky mail_users? Tento krok nelze vr&aacute;tit zp&igrave; t!';
$lng['admin']['configfiles']['overview'] = 'P&oslash;ehled';
$lng['admin']['configfiles']['wizard'] = 'Pr&ugrave;vodce';
$lng['admin']['configfiles']['distribution'] = 'Distribuce';
$lng['admin']['configfiles']['service'] = 'Slu&#382;ba';
$lng['admin']['configfiles']['daemon'] = 'Daemon';
$lng['admin']['configfiles']['http'] = 'Webserver (HTTP)';
$lng['admin']['configfiles']['dns'] = 'Nameserver (DNS)';
$lng['admin']['configfiles']['mail'] = 'Mailserver (IMAP/POP3)';
$lng['admin']['configfiles']['smtp'] = 'Mailserver (SMTP)';
$lng['admin']['configfiles']['ftp'] = 'FTP-Server';
$lng['admin']['configfiles']['etc'] = 'Ostatn&iacute; (System)';
$lng['admin']['configfiles']['choosedistribution'] = '-- Vyberte distribuci --';
$lng['admin']['configfiles']['chooseservice'] = '-- Vyberte slu&#382;bu --';
$lng['admin']['configfiles']['choosedaemon'] = '-- Vyberte daemona --';

// ADDED IN 1.2.16-svn10

$lng['serversettings']['ftpdomain']['title'] = 'FTP &Uacute;&egrave;ty na dom&eacute;n&igrave; ';
$lng['serversettings']['ftpdomain']['description'] = 'Z&aacute;kazn&iacute;ci mohou vytv&aacute;&oslash;et FTP &Uacute;&egrave;ty user@customerdomain?';
$lng['panel']['back'] = 'Back';

// ADDED IN 1.2.16-svn12

$lng['serversettings']['mod_log_sql']['title'] = 'Do&egrave;asn&igrave;  ukl&aacute;dat logy do datab&aacute;ze';
$lng['serversettings']['mod_log_sql']['description'] = 'Pou&#382;&iacute;t <a href="http://www.outoforder.cc/projects/apache/mod_log_sql/" title="mod_log_sql">mod_log_sql</a> pro do&egrave;asn&eacute; ulo&#382;en&iacute; webrequest&ugrave;<br /><b>Toto vy&#382;aduje speci&aacute;ln&iacute; <a href="http://files.syscp.org/docs/mod_log_sql/" title="mod_log_sql - documentation">konfiguraci apache</a>!</b>';
$lng['serversettings']['mod_fcgid']['title'] = 'Includuj PHP p&oslash;es mod_fcgid/suexec';
$lng['serversettings']['mod_fcgid']['description'] = 'Pou&#382;ij mod_fcgid/suexec/libnss_mysql pro b&igrave; h PHP s odpov&iacute;daj&iacute;c&iacute;m &Uacute;&oslash;ivatelsk&yacute;m &Uacute;&egrave;tem.<br/><b>toto vy&#382;aduje speci&aacute;ln&iacute; konfiguraci apache!</b>';
$lng['serversettings']['sendalternativemail']['title'] = 'Pou&#382;ij alternativn&iacute; e-mailovou adresu';
$lng['serversettings']['sendalternativemail']['description'] = 'Po&#353;li email s heslem na jinou adresu p&oslash;i vytv&aacute;&oslash;en&iacute; emailov&eacute;ho &Uacute;&egrave;tu';
$lng['emails']['alternative_emailaddress'] = 'Alternativn&iacute; e-mailov&aacute; adresa';
$lng['mails']['pop_success_alternative']['mailbody'] = 'V&aacute;&#382;en&yacute; u&#382;ivateli,\n\nV&aacute;&#353; emailov&yacute; &Uacute;&egrave;et {EMAIL}\nbyl &Uacute;sp&igrave; &#353;n&igrave;  nastaven.\nVa&#353;e heslo je {PASSWORD}.\n\nTento e-mail byl automaticky vygenerov&aacute;n,\npros&iacute;m neodpov&iacute;dejte na n&igrave; j!\n\nP&oslash;ejeme V&aacute;m hezk&yacute; den, Froxlor-Team';
$lng['mails']['pop_success_alternative']['subject'] = 'E-mailov&yacute; &Uacute;&egrave;et byl &Uacute;sp&igrave; &#353;n&igrave;  vytvo&oslash;en';
$lng['admin']['templates']['pop_success_alternative'] = 'Uv&iacute;tac&iacute; e-mail pro nov&eacute; &Uacute;&egrave;ty byl odesl&aacute;n na alternativn&iacute; adresu';
$lng['admin']['templates']['EMAIL_PASSWORD'] = 'Nahrazeno heslem &Uacute;&egrave;tu POP3/IMAP.';

// ADDED IN 1.2.16-svn13

$lng['error']['documentrootexists'] = 'Adres&aacute;&oslash; &quot;%s&quot; ji&#382; existuje pro tohoto z&aacute;kazn&iacute;ka. Pros&iacute;m odstrate jej, ne&#382; budete znovu z&aacute;kazn&iacute;ka vkl&aacute;dat.';

// ADDED IN 1.2.16-svn14

$lng['serversettings']['apacheconf_vhost']['title'] = 'Apache vhost konfigura&egrave;n&iacute; soubor/dirname';
$lng['serversettings']['apacheconf_vhost']['description'] = 'Kde by m&igrave; la b&yacute;t ulo&#382;ena konfigurace vhosta? M&ugrave;&#382;ete zde bu&iuml; specifikovat soubor (v&#353;ichni vhosti v jednom souboru) nebo adres&aacute;&oslash; (ka&#382;d&yacute; vhost m&aacute; vlastn&iacute; soubor).';
$lng['serversettings']['apacheconf_diroptions']['title'] = 'Apache diroptions konfigura&egrave;n&iacute; soubor/dirname';
$lng['serversettings']['apacheconf_diroptions']['description'] = 'Kde by m&igrave; la b&yacute;t ulo&#382;ena konfigurace diroptions?  M&ugrave;&#382;ete zde bu&iuml; specifikovat soubor (v&#353;ichni diroptions v jednom souboru) nebo adres&aacute;&oslash; (ka&#382;d&yacute; diroption m&aacute; vlastn&iacute; soubor).';
$lng['serversettings']['apacheconf_htpasswddir']['title'] = 'Apache htpasswd dirname';
$lng['serversettings']['apacheconf_htpasswddir']['description'] = 'Kde by m&igrave; ly b&yacute;t ulo&#382;eny htpasswd soubory pro ochranu adres&aacute;&oslash;&ugrave;?';

// ADDED IN 1.2.16-svn15

$lng['error']['formtokencompromised'] = 'The request seems to be compromised. Z bezpe&egrave;nostn&iacute;ch d&ugrave;vod&ugrave; jste byli odhl&aacute;&#353;eni.';
$lng['serversettings']['mysql_access_host']['title'] = 'MySQL-Access-Hosts';
$lng['serversettings']['mysql_access_host']['description'] = 'St&oslash;edn&iacute;kem odd&igrave; len&yacute; seznam host&ugrave;, ze kter&yacute;ch bude dovoleno u&#382;ivatel&ugrave;m se p&oslash;ipojit k MySQL-Serveru.';

// ADDED IN 1.2.18-svn1

$lng['admin']['ipsandports']['create_listen_statement'] = 'Vytvo&oslash;it Listen statement';
$lng['admin']['ipsandports']['create_namevirtualhost_statement'] = 'Vytvo&oslash;it NameVirtualHost statement';
$lng['admin']['ipsandports']['create_vhostcontainer'] = 'Vytvo&oslash;it vHost-Container';
$lng['admin']['ipsandports']['create_vhostcontainer_servername_statement'] = 'Vytvo&oslash;it ServerName statement v vHost-Container';

// ADDED IN 1.2.18-svn2

$lng['admin']['webalizersettings'] = 'Nastaven&iacute; Webalizeru';
$lng['admin']['webalizer']['normal'] = 'Norm&aacute;ln&iacute;';
$lng['admin']['webalizer']['quiet'] = 'Tich&yacute;';
$lng['admin']['webalizer']['veryquiet'] = '&#382;&aacute;dn&yacute; v&yacute;stup';
$lng['serversettings']['webalizer_quiet']['title'] = 'V&yacute;stup Webalizeru';
$lng['serversettings']['webalizer_quiet']['description'] = 'Pov&iacute;davost webalizer-programu';

// ADDED IN 1.2.18-svn3

$lng['ticket']['admin_email'] = 'root@localhost';
$lng['ticket']['noreply_email'] = 'tikety@froxlor';
$lng['admin']['ticketsystem'] = 'Support-tikety';
$lng['menue']['ticket']['ticket'] = 'Support tikety';
$lng['menue']['ticket']['categories'] = 'Kategorie podpory';
$lng['menue']['ticket']['archive'] = 'Archiv-tiket&ugrave;';
$lng['ticket']['description'] = 'Nastavit popis zde!';
$lng['ticket']['ticket_new'] = 'Otev&oslash;&iacute;t nov&yacute; tiket';
$lng['ticket']['ticket_reply'] = 'zodpov&igrave; d&igrave; t tiket';
$lng['ticket']['ticket_reopen'] = 'Znovuotev&oslash;&iacute;t tiket';
$lng['ticket']['ticket_newcateory'] = 'Vytvo&oslash;it novou kategorii';
$lng['ticket']['ticket_editcateory'] = 'Upravit kategorii';
$lng['ticket']['ticket_view'] = 'Zobrazit ticketcourse';
$lng['ticket']['ticketcount'] = 'Tikety';
$lng['ticket']['ticket_answers'] = 'Odpov&igrave; di';
$lng['ticket']['lastchange'] = 'Posledn&iacute; akce';
$lng['ticket']['subject'] = 'P&oslash;edm&igrave; t';
$lng['ticket']['status'] = 'Status';
$lng['ticket']['lastreplier'] = 'Posledn&iacute; odpov&iacute;daj&iacute;c&iacute;';
$lng['ticket']['priority'] = 'Priorita';
$lng['ticket']['low'] = '<span class="ticket_low">N&iacute;zk&aacute;</span>';
$lng['ticket']['normal'] = '<span class="ticket_normal">Norm&aacute;ln&iacute;</span>';
$lng['ticket']['high'] = '<span class="ticket_high">Vysok&aacute;</span>';
$lng['ticket']['unf_low'] = 'N&iacute;zk&aacute;';
$lng['ticket']['unf_normal'] = 'Norm&aacute;ln&iacute;';
$lng['ticket']['unf_high'] = 'Vysok&aacute;';
$lng['ticket']['lastchange'] = 'Posledn&iacute; zm&igrave; na';
$lng['ticket']['lastchange_from'] = 'Od data (dd.mm.yyyy)';
$lng['ticket']['lastchange_to'] = 'Do data (dd.mm.yyyy)';
$lng['ticket']['category'] = 'Kategorie';
$lng['ticket']['no_cat'] = '&#382;&aacute;dn&aacute;';
$lng['ticket']['message'] = 'Zpr&aacute;va';
$lng['ticket']['show'] = 'Zobraz';
$lng['ticket']['answer'] = 'Odpov&igrave; &iuml;';
$lng['ticket']['close'] = 'Zav&oslash;&iacute;t';
$lng['ticket']['reopen'] = 'Znovuotev&oslash;&iacute;t';
$lng['ticket']['archive'] = 'Archiv';
$lng['ticket']['ticket_delete'] = 'Smazat tiket';
$lng['ticket']['lastarchived'] = 'Ned&aacute;vno archivovan&eacute; tikety';
$lng['ticket']['archivedtime'] = 'Archivov&aacute;no';
$lng['ticket']['open'] = 'Otev&oslash;&iacute;t';
$lng['ticket']['wait_reply'] = '&egrave;ek&aacute; na odpov&igrave; &iuml;';
$lng['ticket']['replied'] = 'Odpov&igrave; zeno';
$lng['ticket']['closed'] = 'Zav&oslash;en&yacute;';
$lng['ticket']['staff'] = 'Person&aacute;l';
$lng['ticket']['customer'] = 'Z&aacute;kazn&iacute;k';
$lng['ticket']['old_tickets'] = 'Tiket zpr&aacute;vy';
$lng['ticket']['search'] = 'Prohledat archiv';
$lng['ticket']['nocustomer'] = '&#382;&aacute;dn&yacute; v&yacute;b&igrave; r';
$lng['ticket']['archivesearch'] = 'V&yacute;sledky prohled&aacute;v&aacute;n&iacute; archivu';
$lng['ticket']['noresults'] = 'Nenalezeny &#382;&aacute;dn&eacute; tikety';
$lng['ticket']['notmorethanxopentickets'] = 'Kv&ugrave;li ochran&igrave;  proti SPAMu nem&ugrave;&#382;ete m&iacute;t otev&oslash;eno v&iacute;c jak %s tiket&ugrave;';
$lng['ticket']['supportstatus'] = 'Status-podpory';
$lng['ticket']['supportavailable'] = '<span class="ticket_low">Na&#353;e podpora jsou k dispozici a p&oslash;ipraveni pomoci.</span>';
$lng['ticket']['supportnotavailable'] = '<span class="ticket_high">Na&#353;e podpora nen&iacute; moment&aacute;ln&igrave;  dostupn&aacute;</span>';
$lng['admin']['templates']['ticket'] = 'Upozorovac&iacute; e-maily pro tikety podpory';
$lng['admin']['templates']['SUBJECT'] = 'Nahrazeno p&oslash;edm&igrave; tem tiketu podpory';
$lng['admin']['templates']['new_ticket_for_customer'] = 'Z&aacute;kaznick&eacute; upozorn&igrave; n&iacute;, &#382;e byl tiket odesl&aacute;n';
$lng['admin']['templates']['new_ticket_by_customer'] = 'Administr&aacute;torsk&eacute; upozorn&igrave; n&iacute;, &#382;e byl tiket otev&oslash;en z&aacute;kazn&iacute;kem';
$lng['admin']['templates']['new_reply_ticket_by_customer'] = 'Administr&aacute;torsk&eacute; upozorn&igrave; n&iacute;, &#382;e p&oslash;i&#353;la odpov&igrave; &iuml; na tiket od z&aacute;kazn&iacute;ka';
$lng['admin']['templates']['new_ticket_by_staff'] = 'Z&aacute;kaznick&eacute; upozorn&igrave; n&iacute;, &#382;e byl tiket otev&oslash;en person&aacute;lem';
$lng['admin']['templates']['new_reply_ticket_by_staff'] = 'Z&aacute;kaznick&eacute; upozorn&igrave; n&iacute; na odpov&igrave; &iuml; na tiket od person&aacute;lu';
$lng['mails']['new_ticket_for_customer']['mailbody'] = 'V&aacute;&#382;en&yacute; u&#382;ivateli {FIRSTNAME} {NAME},\n\nV&aacute;&#353; tiket podpory s p&oslash;edm&igrave; tem "{SUBJECT}" byl odesl&aacute;n.\n\nA&#382; p&oslash;ijde odpov&igrave; &iuml; na V&aacute;&#353; tiket, budete upozorn&igrave; ni.\n\nD&igrave; kujeme,\n Froxlor-Team';
$lng['mails']['new_ticket_for_customer']['subject'] = 'V&aacute;&#353; tiket na podporu byl odesl&aacute;n';
$lng['mails']['new_ticket_by_customer']['mailbody'] = 'Mil&yacute; administr&aacute;tore,\n\nbyl odesl&aacute;n nov&yacute; tiket s p&oslash;edm&igrave; tem "{SUBJECT}".\n\nPros&iacute;m p&oslash;ihla&#353;te se pro otev&oslash;en&iacute; tiketu.\n\nD&igrave; kujeme,\n Froxlor-Team';
$lng['mails']['new_ticket_by_customer']['subject'] = 'Nov&yacute; tiket podpory byl odesl&aacute;n';
$lng['mails']['new_reply_ticket_by_customer']['mailbody'] = 'Mil&yacute; administr&aacute;tore,\n\ntiket podpory "{SUBJECT}" byl zodpov&igrave; zen z&aacute;kazn&iacute;kem.\n\nPros&iacute;m p&oslash;ihla&#353;te se pro otev&oslash;en&iacute; tiketu.\n\nD&igrave; kujeme,\n Froxlor-Team';
$lng['mails']['new_reply_ticket_by_customer']['subject'] = 'Nov&aacute; odpov&igrave; &iuml; na tiket podpory';
$lng['mails']['new_ticket_by_staff']['mailbody'] = 'V&aacute;&#382;en&yacute; u&#382;ivateli {FIRSTNAME} {NAME},\n\nbyl pro V&aacute;s otev&oslash;en tiket podpory s p&oslash;edm&igrave; tem "{SUBJECT}".\n\nPros&iacute;m p&oslash;ihla&#353;te se pro otev&oslash;en&iacute; tiketu.\n\nD&igrave; kujeme,\n Froxlor-Team';
$lng['mails']['new_ticket_by_staff']['subject'] = 'Nov&yacute; tiket podpory byl odesl&aacute;n';
$lng['mails']['new_reply_ticket_by_staff']['mailbody'] = 'V&aacute;&#382;en&yacute; u&#382;ivateli {FIRSTNAME} {NAME},\n\ntiket podpory s p&oslash;edm&igrave; tem "{SUBJECT}" byl zodpov&igrave; zen na&#353;&iacute;m person&aacute;lem.\n\nPro p&oslash;e&egrave;ten&iacute; tiketu se pros&iacute;m p&oslash;ihla&#353;te.\n\nD&igrave; kujem,\n Froxlor-Team';
$lng['mails']['new_reply_ticket_by_staff']['subject'] = 'Nov&aacute; odpov&igrave; &iuml; na tiket podpory';
$lng['question']['ticket_reallyclose'] = 'Opravdu chcete zav&oslash;&iacute;t tiket "%s"?';
$lng['question']['ticket_reallydelete'] = 'Opravdu chcete smazat tiket "%s"?';
$lng['question']['ticket_reallydeletecat'] = 'Opravdu chcete smazat kategorii "%s"?';
$lng['question']['ticket_reallyarchive'] = 'Opravdu chcete p&oslash;esunout tiket "%s" do archivu?';
$lng['error']['mysubject'] = '\'' . $lng['ticket']['subject'] . '\'';
$lng['error']['mymessage'] = '\'' . $lng['ticket']['message'] . '\'';
$lng['error']['mycategory'] = '\'' . $lng['ticket']['category'] . '\'';
$lng['error']['nomoreticketsavailable'] = 'Pou&#382;ili jste v&#353;echny dostupn&eacute; tikety. Pros&iacute;m kontaktujte sv&eacute;ho administr&aacute;tora.';
$lng['error']['nocustomerforticket'] = 'Nemohu vytv&aacute;&oslash;et tikety bez z&aacute;kazn&iacute;k&ugrave;';
$lng['error']['categoryhastickets'] = 'Kategorie st&aacute;le obsahuje tikety.<br />Pros&iacute;m sma&#382;te tikety aby jste mohli smazat kategorii';
$lng['error']['notmorethanxopentickets'] = $lng['ticket']['notmorethanxopentickets'];
$lng['admin']['ticketsettings'] = 'Tikety-podpory nastaven&iacute;';
$lng['admin']['archivelastrun'] = 'Posledn&iacute; archivace tiket&ugrave;';
$lng['serversettings']['ticket']['noreply_email']['title'] = 'Bez odpov&igrave; dn&iacute; e-mailov&aacute; adresa';
$lng['serversettings']['ticket']['noreply_email']['description'] = 'Odes&iacute;latelova adresa pro tikety podpory, v&igrave; t&#353;inou n&igrave; co jako no-reply@domain.tld';
$lng['serversettings']['ticket']['worktime_begin']['title'] = 'Za&egrave;&aacute;tek pr&aacute;ce podpory (hh:mm)';
$lng['serversettings']['ticket']['worktime_begin']['description'] = 'Start-time pokud je podpora k dispozici';
$lng['serversettings']['ticket']['worktime_end']['title'] = 'Konec pr&aacute;ce podpory (hh:mm)';
$lng['serversettings']['ticket']['worktime_end']['description'] = 'End-time pokud je podpora k dispozici';
$lng['serversettings']['ticket']['worktime_sat'] = 'Je podpora k dispozici o sobot&aacute;ch?';
$lng['serversettings']['ticket']['worktime_sun'] = 'Je podpora k dispozici o ned&igrave; l&iacute;ch?';
$lng['serversettings']['ticket']['worktime_all']['title'] = 'Podpora bez &egrave;asov&eacute;ho omezen&iacute;';
$lng['serversettings']['ticket']['worktime_all']['description'] = 'Pokud "Ano" mo&#382;nosti za&egrave;&aacute;tku a konce pr&aacute;ce podpory bude p&oslash;eps&aacute;na';
$lng['serversettings']['ticket']['archiving_days'] = 'Po kolika dnech by m&igrave; ly b&yacute;t uzav&oslash;en&eacute; tikety archivov&aacute;ny?';
$lng['customer']['tickets'] = 'Tikety podpory';

// ADDED IN 1.2.18-svn4

$lng['admin']['domain_nocustomeraddingavailable'] = 'Moment&aacute;ln&igrave;  nen&iacute; mo&#382;n&eacute; p&oslash;idat dom&eacute;nu. Nejd&oslash;&iacute;ve mus&iacute;te p&oslash;idat aspo jednoho z&aacute;kazn&iacute;ka.';
$lng['serversettings']['ticket']['enable'] = 'Zapnout syst&eacute;m tiket&ugrave;';
$lng['serversettings']['ticket']['concurrentlyopen'] = 'Kolik tiket&ugrave; by m&igrave; lo b&yacute;t k dispozici najednou?';
$lng['error']['norepymailiswrong'] = '&quot;Bezodpov&igrave; dn&iacute; adresa&quot; je &#353;patn&igrave; . Je povolena pouze validn&iacute; e-mailov&aacute; adresa.';
$lng['error']['tadminmailiswrong'] = '&quot;Ticketadmin-adresa&quot; je &#353;patn&igrave; . Je povolena pouze validn&iacute; e-mailov&aacute; adresa.';
$lng['ticket']['awaitingticketreply'] = 'M&aacute;te %s nezodpov&igrave; zen&yacute;ch tiket&ugrave; podpory';

// ADDED IN 1.2.18-svn5

$lng['serversettings']['ticket']['noreply_name'] = 'Jm&eacute;no odes&iacute;latele tiket&ugrave; v emailu';

?>
