/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Set;
import org.aspectj.bridge.IMessage;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;

public class NewConstructorTypeMunger
extends ResolvedTypeMunger {
    private ResolvedMember syntheticConstructor;
    private ResolvedMember explicitConstructor;

    public NewConstructorTypeMunger(ResolvedMember signature, ResolvedMember syntheticConstructor, ResolvedMember explicitConstructor, Set superMethodsCalled) {
        super(ResolvedTypeMunger.Constructor, signature);
        this.syntheticConstructor = syntheticConstructor;
        this.explicitConstructor = explicitConstructor;
        this.setSuperMethodsCalled(superMethodsCalled);
    }

    public ResolvedMember getDispatchMethod(TypeX aspectType) {
        return AjcMemberMaker.interMethodBody(this.signature, aspectType);
    }

    public void write(DataOutputStream s) throws IOException {
        this.kind.write(s);
        this.signature.write(s);
        this.syntheticConstructor.write(s);
        this.explicitConstructor.write(s);
        this.writeSuperMethodsCalled(s);
    }

    public static ResolvedTypeMunger readConstructor(DataInputStream s, ISourceContext context) throws IOException {
        return new NewConstructorTypeMunger(ResolvedMember.readResolvedMember(s, context), ResolvedMember.readResolvedMember(s, context), ResolvedMember.readResolvedMember(s, context), ResolvedTypeMunger.readSuperMethodsCalled(s));
    }

    public ResolvedMember getExplicitConstructor() {
        return this.explicitConstructor;
    }

    public ResolvedMember getSyntheticConstructor() {
        return this.syntheticConstructor;
    }

    public void setExplicitConstructor(ResolvedMember explicitConstructor) {
        this.explicitConstructor = explicitConstructor;
    }

    public ResolvedMember getMatchingSyntheticMember(Member member, ResolvedTypeX aspectType) {
        ResolvedMember ret = this.getSyntheticConstructor();
        if (ResolvedTypeX.matches(ret, member)) {
            return this.getSignature();
        }
        return super.getMatchingSyntheticMember(member, aspectType);
    }

    public void check(World world) {
        if (this.getSignature().getDeclaringType().isAspect(world)) {
            world.showMessage(IMessage.ERROR, "can't declare constructor on an aspect", this.getSignature().getSourceLocation(), null);
        }
    }
}

