/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.internal.registry.BundleModel;
import org.eclipse.core.internal.registry.RegistryModelObject;
import org.eclipse.core.internal.runtime.CompatibilityHelper;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;

public class ExtensionPoint
extends RegistryModelObject
implements IExtensionPoint {
    private String id = null;
    private IExtension[] extensions = null;
    private String schemaReference;

    public IExtension[] getExtensions() {
        if (this.extensions == null) {
            return new IExtension[0];
        }
        return this.extensions;
    }

    public String getSchemaReference() {
        return this.schemaReference == null ? "" : this.schemaReference.replace(File.separatorChar, '/');
    }

    public String getSchema() {
        return this.schemaReference;
    }

    public String getSimpleIdentifier() {
        return this.id;
    }

    public IExtension getExtension(String id) {
        if (id == null) {
            return null;
        }
        if (this.extensions == null) {
            return null;
        }
        int i = 0;
        while (i < this.extensions.length) {
            if (id.equals(this.extensions[i].getUniqueIdentifier())) {
                return this.extensions[i];
            }
            ++i;
        }
        return null;
    }

    public String getUniqueIdentifier() {
        return String.valueOf(this.getParentIdentifier()) + "." + this.getSimpleIdentifier();
    }

    public void setExtensions(IExtension[] value) {
        this.extensions = value;
    }

    public void setSchema(String schemaReference) {
        this.assertIsWriteable();
        this.schemaReference = schemaReference;
    }

    public void setSimpleIdentifier(String value) {
        this.assertIsWriteable();
        this.id = value;
    }

    public String getParentIdentifier() {
        BundleModel parent = (BundleModel)this.getParent();
        return parent.isFragment() ? parent.getHostIdentifier() : parent.getName();
    }

    public String getLabel() {
        String s = this.getName();
        if (s == null) {
            return "";
        }
        String localized = ((BundleModel)this.getParent()).getResourceString(s);
        if (localized != s) {
            this.setLocalizedName(localized);
        }
        return localized;
    }

    public String toString() {
        return this.getUniqueIdentifier();
    }

    public IConfigurationElement[] getConfigurationElements() {
        IExtension[] exts = this.getExtensions();
        ArrayList<IConfigurationElement> allConfigElts = new ArrayList<IConfigurationElement>();
        int i = 0;
        while (i < exts.length) {
            allConfigElts.addAll(Arrays.asList(exts[i].getConfigurationElements()));
            ++i;
        }
        IConfigurationElement[] value = new IConfigurationElement[allConfigElts.size()];
        allConfigElts.toArray(value);
        return value;
    }

    public IPluginDescriptor getDeclaringPluginDescriptor() {
        return CompatibilityHelper.getPluginDescriptor(this.getParentIdentifier());
    }
}

