/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public class MarkerTypeDefinition {
    protected String type;
    protected Set superTypes;
    protected Set attributeNames;
    protected boolean persistent = false;
    protected String name;

    public MarkerTypeDefinition(IExtension ext) {
        this.type = ext.getUniqueIdentifier();
        this.name = ext.getLabel();
        IConfigurationElement[] elements = ext.getConfigurationElements();
        HashSet<String> types = null;
        HashSet<String> attributes = null;
        int i = 0;
        while (i < elements.length) {
            String bool;
            String name;
            String type;
            IConfigurationElement element = elements[i];
            if (element.getName().equalsIgnoreCase("super") && (type = element.getAttribute("type")) != null) {
                if (types == null) {
                    types = new HashSet<String>(3);
                }
                types.add(type);
            }
            if (element.getName().equalsIgnoreCase("attribute") && (name = element.getAttribute("name")) != null) {
                if (attributes == null) {
                    attributes = new HashSet<String>(3);
                }
                attributes.add(name);
            }
            if (elements[i].getName().equalsIgnoreCase("persistent") && (bool = element.getAttribute("value")) != null) {
                this.persistent = Boolean.valueOf(bool);
            }
            if (elements[i].getName().equalsIgnoreCase("transient") && (bool = element.getAttribute("value")) != null) {
                this.persistent = Boolean.valueOf(bool) == false;
            }
            ++i;
        }
        this.superTypes = types;
        this.attributeNames = attributes;
    }

    public Set getAttributeNames() {
        return this.attributeNames;
    }

    public String getName() {
        return this.name;
    }

    public Set getSuperTypes() {
        return this.superTypes;
    }

    public String getType() {
        return this.type;
    }

    public boolean persistent() {
        return this.persistent;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(40);
        buffer.append(this.getClass().getName());
        buffer.append("\n\ttype=" + this.type);
        buffer.append("\n\tname=" + this.name);
        buffer.append("\n\tsupertypes=" + this.superTypes);
        buffer.append("\n\tattributenames=" + this.attributeNames);
        buffer.append("\n\tpersistent=" + this.persistent);
        return buffer.toString();
    }
}

