/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimpleName;

public class ArrayAccess
extends Expression {
    private Expression arrayExpression = null;
    private Expression indexExpression = null;

    ArrayAccess(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 2;
    }

    ASTNode clone(AST target) {
        ArrayAccess result = new ArrayAccess(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setArray((Expression)this.getArray().clone(target));
        result.setIndex((Expression)this.getIndex().clone(target));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getArray());
            this.acceptChild(visitor, this.getIndex());
        }
        visitor.endVisit(this);
    }

    public Expression getArray() {
        if (this.arrayExpression == null) {
            long count = this.getAST().modificationCount();
            this.setArray(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.arrayExpression;
    }

    public void setArray(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.arrayExpression, expression, true);
        this.arrayExpression = expression;
    }

    public Expression getIndex() {
        if (this.indexExpression == null) {
            long count = this.getAST().modificationCount();
            this.setIndex(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.indexExpression;
    }

    public void setIndex(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.indexExpression, expression, true);
        this.indexExpression = expression;
    }

    int memSize() {
        return 48;
    }

    int treeSize() {
        return this.memSize() + (this.arrayExpression == null ? 0 : this.getArray().treeSize()) + (this.indexExpression == null ? 0 : this.getIndex().treeSize());
    }
}

