/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimpleName;

public class ConditionalExpression
extends Expression {
    private Expression conditionExpression = null;
    private Expression thenExpression = null;
    private Expression elseExpression = null;

    ConditionalExpression(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 16;
    }

    ASTNode clone(AST target) {
        ConditionalExpression result = new ConditionalExpression(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setExpression((Expression)this.getExpression().clone(target));
        result.setThenExpression((Expression)this.getThenExpression().clone(target));
        result.setElseExpression((Expression)this.getElseExpression().clone(target));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getExpression());
            this.acceptChild(visitor, this.getThenExpression());
            this.acceptChild(visitor, this.getElseExpression());
        }
        visitor.endVisit(this);
    }

    public Expression getExpression() {
        if (this.conditionExpression == null) {
            long count = this.getAST().modificationCount();
            this.setExpression(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.conditionExpression;
    }

    public void setExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.conditionExpression, expression, true);
        this.conditionExpression = expression;
    }

    public Expression getThenExpression() {
        if (this.thenExpression == null) {
            long count = this.getAST().modificationCount();
            this.setThenExpression(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.thenExpression;
    }

    public void setThenExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.thenExpression, expression, true);
        this.thenExpression = expression;
    }

    public Expression getElseExpression() {
        if (this.elseExpression == null) {
            long count = this.getAST().modificationCount();
            this.setElseExpression(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.elseExpression;
    }

    public void setElseExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.elseExpression, expression, true);
        this.elseExpression = expression;
    }

    int memSize() {
        return 52;
    }

    int treeSize() {
        return this.memSize() + (this.conditionExpression == null ? 0 : this.getExpression().treeSize()) + (this.thenExpression == null ? 0 : this.getThenExpression().treeSize()) + (this.elseExpression == null ? 0 : this.getElseExpression().treeSize());
    }
}

