/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;

public class InstanceofExpression
extends Expression {
    private Expression leftOperand = null;
    private Type rightOperand = null;

    InstanceofExpression(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 62;
    }

    ASTNode clone(AST target) {
        InstanceofExpression result = new InstanceofExpression(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setLeftOperand((Expression)this.getLeftOperand().clone(target));
        result.setRightOperand((Type)this.getRightOperand().clone(target));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getLeftOperand());
            this.acceptChild(visitor, this.getRightOperand());
        }
        visitor.endVisit(this);
    }

    public Expression getLeftOperand() {
        if (this.leftOperand == null) {
            long count = this.getAST().modificationCount();
            this.setLeftOperand(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.leftOperand;
    }

    public void setLeftOperand(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.leftOperand, expression, true);
        this.leftOperand = expression;
    }

    public Type getRightOperand() {
        if (this.rightOperand == null) {
            long count = this.getAST().modificationCount();
            this.setRightOperand(new SimpleType(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.rightOperand;
    }

    public void setRightOperand(Type referenceType) {
        if (referenceType == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.rightOperand, referenceType, true);
        this.rightOperand = referenceType;
    }

    int memSize() {
        return 48;
    }

    int treeSize() {
        return this.memSize() + (this.leftOperand == null ? 0 : this.getLeftOperand().treeSize()) + (this.rightOperand == null ? 0 : this.getRightOperand().treeSize());
    }
}

