/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimpleName;

public class PrefixExpression
extends Expression {
    private Operator operator = Operator.PLUS;
    private Expression operand = null;

    PrefixExpression(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 38;
    }

    ASTNode clone(AST target) {
        PrefixExpression result = new PrefixExpression(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setOperator(this.getOperator());
        result.setOperand((Expression)this.getOperand().clone(target));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getOperand());
        }
        visitor.endVisit(this);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        if (operator == null) {
            throw new IllegalArgumentException();
        }
        this.modifying();
        this.operator = operator;
    }

    public Expression getOperand() {
        if (this.operand == null) {
            long count = this.getAST().modificationCount();
            this.setOperand(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.operand;
    }

    public void setOperand(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.operand, expression, true);
        this.operand = expression;
    }

    int memSize() {
        return 48;
    }

    int treeSize() {
        return this.memSize() + (this.operand == null ? 0 : this.getOperand().treeSize());
    }

    public static class Operator {
        private String token;
        public static final Operator INCREMENT = new Operator("++");
        public static final Operator DECREMENT = new Operator("--");
        public static final Operator PLUS = new Operator("+");
        public static final Operator MINUS = new Operator("-");
        public static final Operator COMPLEMENT = new Operator("~");
        public static final Operator NOT = new Operator("!");
        private static final Map CODES = new HashMap(20);

        static {
            Operator[] ops = new Operator[]{INCREMENT, DECREMENT, PLUS, MINUS, COMPLEMENT, NOT};
            int i = 0;
            while (i < ops.length) {
                CODES.put(ops[i].toString(), ops[i]);
                ++i;
            }
        }

        private Operator(String token) {
            this.token = token;
        }

        public String toString() {
            return this.token;
        }

        public static Operator toOperator(String token) {
            return (Operator)CODES.get(token);
        }
    }
}

