/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;

public class TypeDeclaration
extends BodyDeclaration {
    private static final int LEGAL_MODIFIERS = 3103;
    private boolean isInterface = false;
    private SimpleName typeName = null;
    private Name optionalSuperclassName = null;
    private ASTNode.NodeList superInterfaceNames;
    private ASTNode.NodeList bodyDeclarations;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    TypeDeclaration(AST ast) {
        super(ast);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.Name");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.superInterfaceNames = new ASTNode.NodeList(false, clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jdt.core.dom.BodyDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.bodyDeclarations = new ASTNode.NodeList(true, clazz2);
    }

    public int getNodeType() {
        return 55;
    }

    ASTNode clone(AST target) {
        TypeDeclaration result = new TypeDeclaration(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setModifiers(this.getModifiers());
        result.setJavadoc((Javadoc)ASTNode.copySubtree(target, this.getJavadoc()));
        result.setInterface(this.isInterface());
        result.setName((SimpleName)this.getName().clone(target));
        result.setSuperclass((Name)ASTNode.copySubtree(target, this.getSuperclass()));
        result.superInterfaces().addAll(ASTNode.copySubtrees(target, this.superInterfaces()));
        result.bodyDeclarations().addAll(ASTNode.copySubtrees(target, this.bodyDeclarations()));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getJavadoc());
            this.acceptChild(visitor, this.getName());
            this.acceptChild(visitor, this.getSuperclass());
            this.acceptChildren(visitor, this.superInterfaceNames);
            this.acceptChildren(visitor, this.bodyDeclarations);
        }
        visitor.endVisit(this);
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void setInterface(boolean isInterface) {
        this.modifying();
        this.isInterface = isInterface;
    }

    public int getModifiers() {
        return super.getModifiers();
    }

    public void setModifiers(int modifiers) {
        if ((modifiers & 0xFFFFF3E0) != 0) {
            throw new IllegalArgumentException();
        }
        super.setModifiers(modifiers);
    }

    public SimpleName getName() {
        if (this.typeName == null) {
            long count = this.getAST().modificationCount();
            this.setName(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.typeName;
    }

    public void setName(SimpleName typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.typeName, typeName, false);
        this.typeName = typeName;
    }

    public Name getSuperclass() {
        return this.optionalSuperclassName;
    }

    public void setSuperclass(Name superclassName) {
        this.replaceChild(this.optionalSuperclassName, superclassName, false);
        this.optionalSuperclassName = superclassName;
    }

    public List superInterfaces() {
        return this.superInterfaceNames;
    }

    public List bodyDeclarations() {
        return this.bodyDeclarations;
    }

    public FieldDeclaration[] getFields() {
        List bd = this.bodyDeclarations();
        int fieldCount = 0;
        ListIterator it = bd.listIterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof FieldDeclaration)) continue;
            ++fieldCount;
        }
        FieldDeclaration[] fields = new FieldDeclaration[fieldCount];
        int next = 0;
        ListIterator it2 = bd.listIterator();
        while (it2.hasNext()) {
            Object decl = it2.next();
            if (!(decl instanceof FieldDeclaration)) continue;
            fields[next++] = (FieldDeclaration)decl;
        }
        return fields;
    }

    public MethodDeclaration[] getMethods() {
        List bd = this.bodyDeclarations();
        int methodCount = 0;
        ListIterator it = bd.listIterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof MethodDeclaration)) continue;
            ++methodCount;
        }
        MethodDeclaration[] methods = new MethodDeclaration[methodCount];
        int next = 0;
        ListIterator it2 = bd.listIterator();
        while (it2.hasNext()) {
            Object decl = it2.next();
            if (!(decl instanceof MethodDeclaration)) continue;
            methods[next++] = (MethodDeclaration)decl;
        }
        return methods;
    }

    public TypeDeclaration[] getTypes() {
        List bd = this.bodyDeclarations();
        int typeCount = 0;
        ListIterator it = bd.listIterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof TypeDeclaration)) continue;
            ++typeCount;
        }
        TypeDeclaration[] memberTypes = new TypeDeclaration[typeCount];
        int next = 0;
        ListIterator it2 = bd.listIterator();
        while (it2.hasNext()) {
            Object decl = it2.next();
            if (!(decl instanceof TypeDeclaration)) continue;
            memberTypes[next++] = (TypeDeclaration)decl;
        }
        return memberTypes;
    }

    public boolean isPackageMemberTypeDeclaration() {
        ASTNode parent = this.getParent();
        return parent instanceof CompilationUnit;
    }

    public boolean isMemberTypeDeclaration() {
        ASTNode parent = this.getParent();
        return parent instanceof TypeDeclaration || parent instanceof AnonymousClassDeclaration;
    }

    public boolean isLocalTypeDeclaration() {
        ASTNode parent = this.getParent();
        return parent instanceof TypeDeclarationStatement;
    }

    public ITypeBinding resolveBinding() {
        return this.getAST().getBindingResolver().resolveType(this);
    }

    void appendDebugString(StringBuffer buffer) {
        buffer.append("TypeDeclaration[");
        buffer.append(this.isInterface() ? "interface " : "class ");
        buffer.append(this.getName().getIdentifier());
        buffer.append(" ");
        Iterator it = this.bodyDeclarations().iterator();
        while (it.hasNext()) {
            BodyDeclaration d = (BodyDeclaration)it.next();
            d.appendDebugString(buffer);
            if (!it.hasNext()) continue;
            buffer.append(";");
        }
        buffer.append("]");
    }

    int memSize() {
        return super.memSize() + 20;
    }

    int treeSize() {
        return this.memSize() + (this.getJavadoc() == null ? 0 : this.getJavadoc().treeSize()) + (this.typeName == null ? 0 : this.getName().treeSize()) + (this.optionalSuperclassName == null ? 0 : this.getSuperclass().treeSize()) + this.superInterfaceNames.listSize() + this.bodyDeclarations.listSize();
    }
}

