/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class BlockScope
extends Scope {
    public LocalVariableBinding[] locals;
    public int localIndex;
    public int startIndex;
    public int offset;
    public int maxOffset;
    public BlockScope[] shiftScopes;
    public static final VariableBinding[] EmulationPathToImplicitThis = new VariableBinding[0];
    public static final VariableBinding[] NoEnclosingInstanceInConstructorCall = new VariableBinding[0];
    public static final VariableBinding[] NoEnclosingInstanceInStaticContext = new VariableBinding[0];
    public Scope[] subscopes = new Scope[1];
    public int subscopeCount = 0;

    protected BlockScope(int kind, Scope parent) {
        super(kind, parent);
    }

    public BlockScope(BlockScope parent) {
        this(parent, true);
    }

    public BlockScope(BlockScope parent, boolean addToParentScope) {
        this(1, parent);
        this.locals = new LocalVariableBinding[5];
        if (addToParentScope) {
            parent.addSubscope(this);
        }
        this.startIndex = parent.localIndex;
    }

    public BlockScope(BlockScope parent, int variableCount) {
        this(1, parent);
        this.locals = new LocalVariableBinding[variableCount];
        parent.addSubscope(this);
        this.startIndex = parent.localIndex;
    }

    public final void addAnonymousType(TypeDeclaration anonymousType, ReferenceBinding superBinding) {
        ClassScope anonymousClassScope = new ClassScope(this, anonymousType);
        anonymousClassScope.buildAnonymousTypeBinding(this.enclosingSourceType(), superBinding);
    }

    public final void addLocalType(TypeDeclaration localType) {
        ReferenceBinding type = this.enclosingSourceType();
        do {
            if (!CharOperation.equals(type.sourceName, localType.name)) continue;
            this.problemReporter().hidingEnclosingType(localType);
            return;
        } while ((type = type.enclosingType()) != null);
        Scope scope = this;
        do {
            if (scope.findLocalType(localType.name) == null) continue;
            this.problemReporter().duplicateNestedType(localType);
            return;
        } while ((scope = scope.parent) instanceof BlockScope);
        ClassScope localTypeScope = new ClassScope(this, localType);
        this.addSubscope(localTypeScope);
        localTypeScope.buildLocalTypeBinding(this.enclosingSourceType());
    }

    public final void addLocalVariable(LocalVariableBinding binding) {
        this.checkAndSetModifiersForVariable(binding);
        if (this.localIndex == this.locals.length) {
            this.locals = new LocalVariableBinding[this.localIndex * 2];
            System.arraycopy(this.locals, 0, this.locals, 0, this.localIndex);
        }
        this.locals[this.localIndex++] = binding;
        binding.declaringScope = this;
        binding.id = this.outerMostMethodScope().analysisIndex++;
    }

    public void addSubscope(Scope childScope) {
        if (this.subscopeCount == this.subscopes.length) {
            this.subscopes = new Scope[this.subscopeCount * 2];
            System.arraycopy(this.subscopes, 0, this.subscopes, 0, this.subscopeCount);
        }
        this.subscopes[this.subscopeCount++] = childScope;
    }

    public final boolean allowBlankFinalFieldAssignment(FieldBinding binding) {
        if (this.enclosingSourceType() != binding.declaringClass) {
            return false;
        }
        MethodScope methodScope = this.methodScope();
        if (methodScope.isStatic != binding.isStatic()) {
            return false;
        }
        return methodScope.isInsideInitializer() || ((AbstractMethodDeclaration)methodScope.referenceContext).isInitializationMethod();
    }

    String basicToString(int tab) {
        String newLine = "\n";
        int i = tab;
        while (--i >= 0) {
            newLine = String.valueOf(newLine) + "\t";
        }
        String s = String.valueOf(newLine) + "--- Block Scope ---";
        newLine = String.valueOf(newLine) + "\t";
        s = String.valueOf(s) + newLine + "locals:";
        int i2 = 0;
        while (i2 < this.localIndex) {
            s = String.valueOf(s) + newLine + "\t" + this.locals[i2].toString();
            ++i2;
        }
        s = String.valueOf(s) + newLine + "startIndex = " + this.startIndex;
        return s;
    }

    private void checkAndSetModifiersForVariable(LocalVariableBinding varBinding) {
        int unexpectedModifiers;
        int realModifiers;
        int modifiers = varBinding.modifiers;
        if ((modifiers & 0x400000) != 0 && varBinding.declaration != null) {
            this.problemReporter().duplicateModifierForVariable(varBinding.declaration, this instanceof MethodScope);
        }
        if (((realModifiers = modifiers & 0xFFFF) & (unexpectedModifiers = -17)) != 0 && varBinding.declaration != null) {
            this.problemReporter().illegalModifierForVariable(varBinding.declaration, this instanceof MethodScope);
        }
        varBinding.modifiers = modifiers;
    }

    void computeLocalVariablePositions(int ilocal, int initOffset, CodeStream codeStream) {
        this.offset = initOffset;
        this.maxOffset = initOffset;
        int maxLocals = this.localIndex;
        boolean hasMoreVariables = ilocal < maxLocals;
        int iscope = 0;
        int maxScopes = this.subscopeCount;
        boolean hasMoreScopes = maxScopes > 0;
        while (hasMoreVariables || hasMoreScopes) {
            boolean generateCurrentLocalVar;
            if (hasMoreScopes && (!hasMoreVariables || this.subscopes[iscope].startIndex() <= ilocal)) {
                if (this.subscopes[iscope] instanceof BlockScope) {
                    BlockScope subscope = (BlockScope)this.subscopes[iscope];
                    int subOffset = subscope.shiftScopes == null ? this.offset : subscope.maxShiftedOffset();
                    subscope.computeLocalVariablePositions(0, subOffset, codeStream);
                    if (subscope.maxOffset > this.maxOffset) {
                        this.maxOffset = subscope.maxOffset;
                    }
                }
                hasMoreScopes = ++iscope < maxScopes;
                continue;
            }
            LocalVariableBinding local = this.locals[ilocal];
            boolean bl = generateCurrentLocalVar = local.useFlag == 1 && local.constant == Constant.NotAConstant;
            if (local.useFlag == 0 && local.declaration != null && (local.declaration.bits & 0x40000000) != 0 && !(local.declaration instanceof Argument)) {
                this.problemReporter().unusedLocalVariable(local.declaration);
            }
            if (!generateCurrentLocalVar && local.declaration != null && this.environment().options.preserveAllLocalVariables) {
                generateCurrentLocalVar = true;
                local.useFlag = 1;
            }
            if (generateCurrentLocalVar) {
                if (local.declaration != null) {
                    codeStream.record(local);
                }
                local.resolvedPosition = this.offset++;
                if (local.type == BaseTypes.LongBinding || local.type == BaseTypes.DoubleBinding) {
                    this.offset += 2;
                }
                if (this.offset > 65535) {
                    this.problemReporter().noMoreAvailableSpaceForLocal(local, local.declaration == null ? (ASTNode)((Object)this.methodScope().referenceContext) : local.declaration);
                }
            } else {
                local.resolvedPosition = -1;
            }
            boolean bl2 = hasMoreVariables = ++ilocal < maxLocals;
        }
        if (this.offset > this.maxOffset) {
            this.maxOffset = this.offset;
        }
    }

    public void emulateOuterAccess(LocalVariableBinding outerLocalVariable) {
        MethodScope currentMethodScope = this.methodScope();
        if (currentMethodScope != outerLocalVariable.declaringScope.methodScope()) {
            NestedTypeBinding currentType = (NestedTypeBinding)this.enclosingSourceType();
            if (!currentType.isLocalType()) {
                return;
            }
            if (!currentMethodScope.isInsideInitializerOrConstructor()) {
                currentType.addSyntheticArgumentAndField(outerLocalVariable);
            } else {
                currentType.addSyntheticArgument(outerLocalVariable);
            }
        }
    }

    public final ReferenceBinding findLocalType(char[] name) {
        int i = 0;
        int length = this.subscopeCount;
        while (i < length) {
            SourceTypeBinding sourceType;
            if (this.subscopes[i] instanceof ClassScope && CharOperation.equals((sourceType = ((ClassScope)this.subscopes[i]).referenceContext.binding).sourceName(), name)) {
                return sourceType;
            }
            ++i;
        }
        return null;
    }

    public LocalVariableBinding findVariable(char[] variable) {
        int variableLength = variable.length;
        int i = 0;
        int length = this.locals.length;
        while (i < length) {
            LocalVariableBinding local = this.locals[i];
            if (local == null) {
                return null;
            }
            if (local.name.length == variableLength && CharOperation.prefixEquals(local.name, variable)) {
                return local;
            }
            ++i;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Binding getBinding(char[][] compoundName, int mask, InvocationSite invocationSite, boolean needResolve) {
        binding = this.getBinding(compoundName[0], mask | 4 | 16, invocationSite, needResolve);
        invocationSite.setFieldIndex(1);
        if (binding instanceof VariableBinding) {
            return binding;
        }
        this.compilationUnitScope().recordSimpleReference(compoundName[0]);
        if (!binding.isValidBinding()) {
            return binding;
        }
        length = compoundName.length;
        currentIndex = 1;
        if (!(binding instanceof PackageBinding)) ** GOTO lbl44
        packageBinding = (PackageBinding)binding;
        while (currentIndex < length) {
            block14: {
                this.compilationUnitScope().recordReference(packageBinding.compoundName, compoundName[currentIndex]);
                binding = packageBinding.getTypeOrPackage(compoundName[currentIndex++]);
                invocationSite.setFieldIndex(currentIndex);
                if (binding == null) {
                    if (currentIndex == length) {
                        return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), 1);
                    }
                    return new ProblemBinding(CharOperation.subarray(compoundName, 0, currentIndex), 1);
                }
                if (!(binding instanceof ReferenceBinding)) break block14;
                if (!binding.isValidBinding()) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), binding.problemId());
                }
                if (!((ReferenceBinding)binding).canBeSeenBy(this)) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), (ReferenceBinding)binding, 2);
                }
                ** GOTO lbl44
            }
            packageBinding = (PackageBinding)binding;
        }
        return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), 1);
lbl-1000:
        // 1 sources

        {
            typeBinding = (ReferenceBinding)binding;
            nextName = compoundName[currentIndex++];
            invocationSite.setFieldIndex(currentIndex);
            invocationSite.setActualReceiverType(typeBinding);
            if ((mask & 1) != 0 && (binding = this.findField(typeBinding, nextName, invocationSite, true)) != null) {
                if (binding.isValidBinding()) break;
                return new ProblemFieldBinding(((FieldBinding)binding).declaringClass, CharOperation.subarray(compoundName, 0, currentIndex), binding.problemId());
            }
            binding = this.findMemberType(nextName, typeBinding);
            if (binding == null) {
                if ((mask & 1) != 0) {
                    return new ProblemBinding(CharOperation.subarray(compoundName, 0, currentIndex), typeBinding, 1);
                }
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), typeBinding, 1);
            }
            if (binding.isValidBinding()) continue;
            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), binding.problemId());
lbl44:
            // 3 sources

            ** while (currentIndex < length)
        }
lbl45:
        // 2 sources

        if ((mask & 1) != 0 && binding instanceof FieldBinding) {
            field = (FieldBinding)binding;
            if (!field.isStatic()) {
                return new ProblemFieldBinding(field.declaringClass, CharOperation.subarray(compoundName, 0, currentIndex), 7);
            }
            return binding;
        }
        if ((mask & 4) != 0 && binding instanceof ReferenceBinding) {
            return binding;
        }
        return new ProblemBinding(CharOperation.subarray(compoundName, 0, currentIndex), 1);
    }

    public final Binding getBinding(char[][] compoundName, InvocationSite invocationSite) {
        Binding binding;
        int length;
        int currentIndex;
        block17: {
            block16: {
                currentIndex = 0;
                length = compoundName.length;
                if (!(binding = this.getBinding(compoundName[currentIndex++], 23, invocationSite, true)).isValidBinding()) {
                    return binding;
                }
                if (binding instanceof PackageBinding) {
                    while (currentIndex < length) {
                        PackageBinding packageBinding = (PackageBinding)binding;
                        if ((binding = packageBinding.getTypeOrPackage(compoundName[currentIndex++])) == null) {
                            if (currentIndex == length) {
                                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), 1);
                            }
                            return new ProblemBinding(CharOperation.subarray(compoundName, 0, currentIndex), 1);
                        }
                        if (!(binding instanceof ReferenceBinding)) continue;
                        if (!binding.isValidBinding()) {
                            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), binding.problemId());
                        }
                        if (!((ReferenceBinding)binding).canBeSeenBy(this)) {
                            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), (ReferenceBinding)binding, 2);
                        }
                        break block16;
                    }
                    return binding;
                }
            }
            if (binding instanceof ReferenceBinding) {
                while (currentIndex < length) {
                    char[] nextName;
                    ReferenceBinding typeBinding = (ReferenceBinding)binding;
                    if ((binding = this.findField(typeBinding, nextName = compoundName[currentIndex++], invocationSite, true)) != null) {
                        if (!binding.isValidBinding()) {
                            return new ProblemFieldBinding(((FieldBinding)binding).declaringClass, CharOperation.subarray(compoundName, 0, currentIndex), binding.problemId());
                        }
                        if (!((FieldBinding)binding).isStatic()) {
                            return new ProblemFieldBinding(((FieldBinding)binding).declaringClass, CharOperation.subarray(compoundName, 0, currentIndex), 7);
                        }
                        break block17;
                    }
                    binding = this.findMemberType(nextName, typeBinding);
                    if (binding == null) {
                        return new ProblemBinding(CharOperation.subarray(compoundName, 0, currentIndex), typeBinding, 1);
                    }
                    if (binding.isValidBinding()) continue;
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), binding.problemId());
                }
                return binding;
            }
        }
        VariableBinding variableBinding = (VariableBinding)binding;
        while (currentIndex < length) {
            TypeBinding typeBinding = variableBinding.type;
            if (typeBinding == null) {
                return new ProblemFieldBinding(null, CharOperation.subarray(compoundName, 0, currentIndex + 1), 1);
            }
            if ((variableBinding = this.findField(typeBinding, compoundName[currentIndex++], invocationSite, true)) == null) {
                return new ProblemFieldBinding(null, CharOperation.subarray(compoundName, 0, currentIndex), 1);
            }
            if (variableBinding.isValidBinding()) continue;
            return variableBinding;
        }
        return variableBinding;
    }

    public VariableBinding[] getEmulationPath(LocalVariableBinding outerLocalVariable) {
        FieldBinding syntheticField;
        SyntheticArgumentBinding syntheticArg;
        MethodScope currentMethodScope = this.methodScope();
        SourceTypeBinding sourceType = currentMethodScope.enclosingSourceType();
        if (currentMethodScope == outerLocalVariable.declaringScope.methodScope()) {
            return new VariableBinding[]{outerLocalVariable};
        }
        if (currentMethodScope.isInsideInitializerOrConstructor() && sourceType.isNestedType() && (syntheticArg = ((NestedTypeBinding)sourceType).getSyntheticArgument(outerLocalVariable)) != null) {
            return new VariableBinding[]{syntheticArg};
        }
        if (!currentMethodScope.isStatic && (syntheticField = sourceType.getSyntheticField(outerLocalVariable)) != null) {
            return new VariableBinding[]{syntheticField};
        }
        return null;
    }

    public Object[] getEmulationPath(ReferenceBinding targetEnclosingType, boolean onlyExactMatch, boolean ignoreEnclosingArgInConstructorCall) {
        SyntheticArgumentBinding syntheticArg;
        MethodScope currentMethodScope = this.methodScope();
        SourceTypeBinding sourceType = currentMethodScope.enclosingSourceType();
        if (!currentMethodScope.isConstructorCall && !currentMethodScope.isStatic && (sourceType == targetEnclosingType || !onlyExactMatch && targetEnclosingType.isSuperclassOf(sourceType))) {
            return EmulationPathToImplicitThis;
        }
        if (!sourceType.isNestedType() || sourceType.isStatic()) {
            if (currentMethodScope.isConstructorCall) {
                return NoEnclosingInstanceInConstructorCall;
            }
            if (currentMethodScope.isStatic) {
                return NoEnclosingInstanceInStaticContext;
            }
            return null;
        }
        boolean insideConstructor = currentMethodScope.isInsideInitializerOrConstructor();
        if (insideConstructor && (syntheticArg = ((NestedTypeBinding)sourceType).getSyntheticArgument(targetEnclosingType, onlyExactMatch)) != null) {
            if (ignoreEnclosingArgInConstructorCall && currentMethodScope.isConstructorCall && (sourceType == targetEnclosingType || !onlyExactMatch && targetEnclosingType.isSuperclassOf(sourceType))) {
                return NoEnclosingInstanceInConstructorCall;
            }
            return new Object[]{syntheticArg};
        }
        if (currentMethodScope.isStatic) {
            return NoEnclosingInstanceInStaticContext;
        }
        FieldBinding syntheticField = sourceType.getSyntheticField(targetEnclosingType, onlyExactMatch);
        if (syntheticField != null) {
            if (currentMethodScope.isConstructorCall) {
                return NoEnclosingInstanceInConstructorCall;
            }
            return new Object[]{syntheticField};
        }
        Object[] path = new Object[2];
        ReferenceBinding currentType = sourceType.enclosingType();
        if (insideConstructor) {
            path[0] = ((NestedTypeBinding)sourceType).getSyntheticArgument(currentType, onlyExactMatch);
        } else {
            if (currentMethodScope.isConstructorCall) {
                return NoEnclosingInstanceInConstructorCall;
            }
            path[0] = sourceType.getSyntheticField(currentType, onlyExactMatch);
        }
        if (path[0] != null) {
            ReferenceBinding currentEnclosingType;
            int count = 1;
            while ((currentEnclosingType = currentType.enclosingType()) != null) {
                if (currentType == targetEnclosingType || !onlyExactMatch && targetEnclosingType.isSuperclassOf(currentType)) break;
                if (currentMethodScope != null) {
                    if ((currentMethodScope = currentMethodScope.enclosingMethodScope()) != null && currentMethodScope.isConstructorCall) {
                        return NoEnclosingInstanceInConstructorCall;
                    }
                    if (currentMethodScope != null && currentMethodScope.isStatic) {
                        return NoEnclosingInstanceInStaticContext;
                    }
                }
                if ((syntheticField = ((NestedTypeBinding)currentType).getSyntheticField(currentEnclosingType, onlyExactMatch)) == null) break;
                if (count == path.length) {
                    Object[] objectArray = path;
                    path = new Object[count + 1];
                    System.arraycopy(objectArray, 0, path, 0, count);
                }
                path[count++] = ((SourceTypeBinding)syntheticField.declaringClass).addSyntheticMethod(syntheticField, true);
                currentType = currentEnclosingType;
            }
            if (currentType == targetEnclosingType || !onlyExactMatch && targetEnclosingType.isSuperclassOf(currentType)) {
                return path;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public MethodBinding getImplicitMethod(char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        boolean insideStaticContext = false;
        boolean insideConstructorCall = false;
        Binding foundMethod = null;
        ProblemMethodBinding foundFuzzyProblem = null;
        ProblemMethodBinding foundInsideProblem = null;
        Scope scope = this;
        int depth = 0;
        block5: while (true) {
            switch (scope.kind) {
                case 2: {
                    MethodScope methodScope = (MethodScope)scope;
                    insideStaticContext |= methodScope.isStatic;
                    insideConstructorCall |= methodScope.isConstructorCall;
                    break;
                }
                case 3: {
                    MethodBinding methodBinding;
                    ClassScope classScope = (ClassScope)scope;
                    SourceTypeBinding receiverType = classScope.referenceContext.binding;
                    boolean isExactMatch = true;
                    MethodBinding methodBinding2 = methodBinding = foundMethod == null ? classScope.findExactMethod(receiverType, selector, argumentTypes, invocationSite) : classScope.findExactMethod(receiverType, ((MethodBinding)foundMethod).selector, ((MethodBinding)foundMethod).parameters, invocationSite);
                    if (methodBinding == null) {
                        isExactMatch = false;
                        methodBinding = classScope.findMethod(receiverType, selector, argumentTypes, invocationSite);
                    }
                    if (methodBinding != null) {
                        if (methodBinding.problemId() == 3) {
                            if (foundMethod != null && foundMethod.problemId() != 2) {
                                return new ProblemMethodBinding(selector, argumentTypes, 5);
                            }
                            return methodBinding;
                        }
                        ProblemMethodBinding fuzzyProblem = null;
                        ProblemMethodBinding insideProblem = null;
                        if (methodBinding.isValidBinding()) {
                            if (!isExactMatch) {
                                if (!this.areParametersAssignable(methodBinding.parameters, argumentTypes)) {
                                    if (foundMethod == null || foundMethod.problemId() == 2) {
                                        return new ProblemMethodBinding(methodBinding, selector, argumentTypes, 1);
                                    }
                                    fuzzyProblem = new ProblemMethodBinding(selector, methodBinding.parameters, 5);
                                } else if (!methodBinding.canBeSeenBy(receiverType, invocationSite, classScope)) {
                                    fuzzyProblem = new ProblemMethodBinding(methodBinding, selector, methodBinding.parameters, 2);
                                }
                            }
                            if (fuzzyProblem == null && !methodBinding.isStatic()) {
                                if (insideConstructorCall) {
                                    insideProblem = new ProblemMethodBinding(methodBinding.selector, methodBinding.parameters, 6);
                                } else if (insideStaticContext) {
                                    insideProblem = new ProblemMethodBinding(methodBinding.selector, methodBinding.parameters, 7);
                                }
                            }
                            if (receiverType == methodBinding.declaringClass || receiverType.getMethods(selector) != TypeConstants.NoMethods || (fuzzyProblem == null || fuzzyProblem.problemId() != 2) && this.environment().options.complianceLevel >= 0x300000L) {
                                if (foundMethod == null) {
                                    if (depth > 0) {
                                        invocationSite.setDepth(depth);
                                        invocationSite.setActualReceiverType(receiverType);
                                    }
                                    if (fuzzyProblem != null) {
                                        return fuzzyProblem;
                                    }
                                    if (insideProblem != null) {
                                        return insideProblem;
                                    }
                                    return methodBinding;
                                }
                                if (((MethodBinding)foundMethod).declaringClass != methodBinding.declaringClass) {
                                    return new ProblemMethodBinding(methodBinding.selector, methodBinding.parameters, 5);
                                }
                            }
                        }
                        if (foundMethod == null || foundMethod.problemId() == 2 && methodBinding.problemId() != 2) {
                            if (depth > 0) {
                                invocationSite.setDepth(depth);
                                invocationSite.setActualReceiverType(receiverType);
                            }
                            foundFuzzyProblem = fuzzyProblem;
                            foundInsideProblem = insideProblem;
                            if (fuzzyProblem == null) {
                                foundMethod = methodBinding;
                            }
                        }
                    }
                    ++depth;
                    insideStaticContext |= receiverType.isStatic();
                    MethodScope enclosingMethodScope = scope.methodScope();
                    insideConstructorCall = enclosingMethodScope == null ? false : enclosingMethodScope.isConstructorCall;
                    break;
                }
                case 4: {
                    break block5;
                }
            }
            scope = scope.parent;
        }
        if (foundFuzzyProblem != null) {
            return foundFuzzyProblem;
        }
        if (foundInsideProblem != null) {
            return foundInsideProblem;
        }
        if (foundMethod != null) {
            return foundMethod;
        }
        return new ProblemMethodBinding(selector, argumentTypes, 1);
    }

    public final boolean isDuplicateLocalVariable(char[] name) {
        BlockScope current = this;
        while (true) {
            int i = 0;
            while (i < this.localIndex) {
                if (CharOperation.equals(name, current.locals[i].name)) {
                    return true;
                }
                ++i;
            }
            if (current.kind != 1) {
                return false;
            }
            current = (BlockScope)current.parent;
        }
    }

    public int maxShiftedOffset() {
        int max = -1;
        if (this.shiftScopes != null) {
            int i = 0;
            int length = this.shiftScopes.length;
            while (i < length) {
                int subMaxOffset = this.shiftScopes[i].maxOffset;
                if (subMaxOffset > max) {
                    max = subMaxOffset;
                }
                ++i;
            }
        }
        return max;
    }

    public ProblemReporter problemReporter() {
        return this.outerMostMethodScope().problemReporter();
    }

    public void propagateInnerEmulation(ReferenceBinding targetType, boolean isEnclosingInstanceSupplied) {
        SyntheticArgumentBinding[] syntheticArguments = targetType.syntheticOuterLocalVariables();
        if (syntheticArguments != null) {
            int i = 0;
            int max = syntheticArguments.length;
            while (i < max) {
                SyntheticArgumentBinding syntheticArg = syntheticArguments[i];
                if (!isEnclosingInstanceSupplied || syntheticArg.type != targetType.enclosingType()) {
                    this.emulateOuterAccess(syntheticArg.actualOuterLocalVariable);
                }
                ++i;
            }
        }
    }

    public TypeDeclaration referenceType() {
        return this.methodScope().referenceType();
    }

    public int scopeIndex() {
        if (this instanceof MethodScope) {
            return -1;
        }
        BlockScope parentScope = (BlockScope)this.parent;
        Scope[] parentSubscopes = parentScope.subscopes;
        int i = 0;
        int max = parentScope.subscopeCount;
        while (i < max) {
            if (parentSubscopes[i] == this) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    int startIndex() {
        return this.startIndex;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int tab) {
        String s = this.basicToString(tab);
        int i = 0;
        while (i < this.subscopeCount) {
            if (this.subscopes[i] instanceof BlockScope) {
                s = String.valueOf(s) + ((BlockScope)this.subscopes[i]).toString(tab + 1) + "\n";
            }
            ++i;
        }
        return s;
    }
}

