/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.builder.ClasspathDirectory;
import org.eclipse.jdt.internal.core.util.Util;

class ClasspathMultiDirectory
extends ClasspathDirectory {
    IContainer sourceFolder;
    char[][] exclusionPatterns;
    boolean hasIndependentOutputFolder;

    ClasspathMultiDirectory(IContainer sourceFolder, IContainer binaryFolder, char[][] exclusionPatterns) {
        super(binaryFolder, true);
        this.sourceFolder = sourceFolder;
        this.exclusionPatterns = exclusionPatterns;
        this.hasIndependentOutputFolder = false;
        if (this.exclusionPatterns != null && this.exclusionPatterns.length == 0) {
            this.exclusionPatterns = null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathMultiDirectory)) {
            return false;
        }
        ClasspathMultiDirectory md = (ClasspathMultiDirectory)o;
        return this.sourceFolder.equals(md.sourceFolder) && this.binaryFolder.equals(md.binaryFolder) && CharOperation.equals(this.exclusionPatterns, md.exclusionPatterns);
    }

    protected boolean isExcluded(IResource resource) {
        if (this.exclusionPatterns != null && this.sourceFolder.equals(this.binaryFolder)) {
            return Util.isExcluded(resource, this.exclusionPatterns);
        }
        return false;
    }

    public String toString() {
        return "Source classpath directory " + this.sourceFolder.getFullPath().toString() + " with binary directory " + this.binaryFolder.getFullPath().toString();
    }
}

