/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;

public class ConstructorPattern
extends SearchPattern {
    private static ThreadLocal indexRecord = new ThreadLocal(){

        protected Object initialValue() {
            return new ConstructorPattern(false, false, null, null, null, null, 4);
        }
    };
    protected boolean findDeclarations;
    protected boolean findReferences;
    public char[] declaringQualification;
    public char[] declaringSimpleName;
    public char[][] parameterQualifications;
    public char[][] parameterSimpleNames;
    public int parameterCount;

    public static char[] createIndexKey(char[] typeName, int argCount) {
        ConstructorPattern record = ConstructorPattern.getConstructorRecord();
        record.declaringSimpleName = typeName;
        record.parameterCount = argCount;
        return record.encodeIndexKey();
    }

    public static ConstructorPattern getConstructorRecord() {
        return (ConstructorPattern)indexRecord.get();
    }

    public ConstructorPattern(boolean findDeclarations, boolean findReferences, char[] declaringSimpleName, char[] declaringQualification, char[][] parameterQualifications, char[][] parameterSimpleNames, int matchRule) {
        super(32, matchRule);
        this.findDeclarations = findDeclarations;
        this.findReferences = findReferences;
        boolean isCaseSensitive = this.isCaseSensitive();
        this.declaringQualification = isCaseSensitive ? declaringQualification : CharOperation.toLowerCase(declaringQualification);
        char[] cArray = this.declaringSimpleName = isCaseSensitive ? declaringSimpleName : CharOperation.toLowerCase(declaringSimpleName);
        if (parameterSimpleNames != null) {
            this.parameterCount = parameterSimpleNames.length;
            this.parameterQualifications = new char[this.parameterCount][];
            this.parameterSimpleNames = new char[this.parameterCount][];
            int i = 0;
            while (i < this.parameterCount) {
                this.parameterQualifications[i] = isCaseSensitive ? parameterQualifications[i] : CharOperation.toLowerCase(parameterQualifications[i]);
                this.parameterSimpleNames[i] = isCaseSensitive ? parameterSimpleNames[i] : CharOperation.toLowerCase(parameterSimpleNames[i]);
                ++i;
            }
        } else {
            this.parameterCount = -1;
        }
        this.mustResolve = this.mustResolve();
    }

    public void decodeIndexKey(char[] key) {
        int size = key.length;
        int lastSeparatorIndex = CharOperation.lastIndexOf('/', key);
        this.parameterCount = Integer.parseInt(new String(key, lastSeparatorIndex + 1, size - lastSeparatorIndex - 1));
        this.declaringSimpleName = CharOperation.subarray(key, 0, lastSeparatorIndex);
    }

    public char[] encodeIndexKey() {
        if (this.isCaseSensitive() && this.declaringSimpleName != null) {
            switch (this.matchMode()) {
                case 0: {
                    int arity = this.parameterCount;
                    if (arity >= 0) {
                        char[] countChars = arity < 10 ? IIndexConstants.COUNTS[arity] : ("/" + String.valueOf(arity)).toCharArray();
                        return CharOperation.concat(this.declaringSimpleName, countChars);
                    }
                }
                case 1: {
                    return this.declaringSimpleName;
                }
                case 2: {
                    int starPos = CharOperation.indexOf('*', this.declaringSimpleName);
                    switch (starPos) {
                        case -1: {
                            return this.declaringSimpleName;
                        }
                        default: {
                            char[] result = new char[starPos];
                            System.arraycopy(this.declaringSimpleName, 0, result, 0, starPos);
                            return result;
                        }
                        case 0: 
                    }
                }
            }
        }
        return CharOperation.NO_CHAR;
    }

    public SearchPattern getIndexRecord() {
        return ConstructorPattern.getConstructorRecord();
    }

    public char[][] getMatchCategories() {
        if (this.findReferences) {
            if (this.findDeclarations) {
                return new char[][]{IIndexConstants.CONSTRUCTOR_REF, IIndexConstants.CONSTRUCTOR_DECL};
            }
            return new char[][]{IIndexConstants.CONSTRUCTOR_REF};
        }
        if (this.findDeclarations) {
            return new char[][]{IIndexConstants.CONSTRUCTOR_DECL};
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    public boolean isMatchingIndexRecord() {
        ConstructorPattern record = ConstructorPattern.getConstructorRecord();
        if (this.parameterCount != -1 && this.parameterCount != record.parameterCount) {
            return false;
        }
        return this.matchesName(this.declaringSimpleName, record.declaringSimpleName);
    }

    protected boolean mustResolve() {
        if (this.declaringQualification != null) {
            return true;
        }
        if (this.parameterSimpleNames != null) {
            int i = 0;
            int max = this.parameterSimpleNames.length;
            while (i < max) {
                if (this.parameterQualifications[i] != null) {
                    return true;
                }
                ++i;
            }
        }
        return this.findReferences;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        if (this.findDeclarations) {
            buffer.append(this.findReferences ? "ConstructorCombinedPattern: " : "ConstructorDeclarationPattern: ");
        } else {
            buffer.append("ConstructorReferencePattern: ");
        }
        if (this.declaringQualification != null) {
            buffer.append(this.declaringQualification).append('.');
        }
        if (this.declaringSimpleName != null) {
            buffer.append(this.declaringSimpleName);
        } else if (this.declaringQualification != null) {
            buffer.append("*");
        }
        buffer.append('(');
        if (this.parameterSimpleNames == null) {
            buffer.append("...");
        } else {
            int i = 0;
            int max = this.parameterSimpleNames.length;
            while (i < max) {
                if (i > 0) {
                    buffer.append(", ");
                }
                if (this.parameterQualifications[i] != null) {
                    buffer.append(this.parameterQualifications[i]).append('.');
                }
                if (this.parameterSimpleNames[i] == null) {
                    buffer.append('*');
                } else {
                    buffer.append(this.parameterSimpleNames[i]);
                }
                ++i;
            }
        }
        buffer.append(')');
        buffer.append(", ");
        switch (this.matchMode()) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        buffer.append(this.isCaseSensitive() ? "case sensitive" : "case insensitive");
        return buffer.toString();
    }
}

