/*
 * Copyright (c) 2015, 2019, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, version 2.0, as published by the
 * Free Software Foundation.
 *
 * This program is also distributed with certain software (including but not
 * limited to OpenSSL) that is licensed under separate terms, as designated in a
 * particular file or component or in included license documentation. The
 * authors of MySQL hereby grant you an additional permission to link the
 * program and your derivative works with the separately licensed software that
 * they have included with MySQL.
 *
 * Without limiting anything contained in the foregoing, this file, which is
 * part of MySQL Connector/J, is also subject to the Universal FOSS Exception,
 * version 1.0, a copy of which can be found at
 * http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License, version 2.0,
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
 */

package com.mysql.cj.xdevapi;

import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;

import com.mysql.cj.x.protobuf.MysqlxCrud.Projection;

/**
 * {@link FilterParams} implementation for {@link com.mysql.cj.xdevapi.Collection} syntax.
 */
public class DocFilterParams extends AbstractFilterParams {

    /**
     * Constructor.
     * 
     * @param schemaName
     *            Schema name
     * @param collectionName
     *            Collection name
     */
    public DocFilterParams(String schemaName, String collectionName) {
        this(schemaName, collectionName, true);
    }

    /**
     * Constructor.
     * 
     * @param schemaName
     *            Schema name
     * @param collectionName
     *            Collection name
     * @param supportsOffset
     *            Whether OFFSET is supported or not
     */
    public DocFilterParams(String schemaName, String collectionName, boolean supportsOffset) {
        super(schemaName, collectionName, supportsOffset, false);
    }

    /**
     * Parse projection expressions into X Protocol Projection objects.
     * 
     * @param docProjection
     *            projection expression
     */
    public void setFields(Expression docProjection) {
        this.fields = Collections.singletonList(Projection.newBuilder().setSource(new ExprParser(docProjection.getExpressionString(), false).parse()).build());
    }

    @Override
    public void setFields(String... projection) {
        this.fields = new ExprParser(Arrays.stream(projection).collect(Collectors.joining(", ")), false).parseDocumentProjection();
    }
}
