/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui;

import java.io.PrintWriter;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.algorithm.Algorithm;
import org.pentaho.aggdes.algorithm.Progress;
import org.pentaho.aggdes.algorithm.Result;
import org.pentaho.aggdes.algorithm.util.ArgumentUtils;
import org.pentaho.aggdes.model.Component;
import org.pentaho.aggdes.ui.form.model.ConnectionModel;

public class AlgorithmRunner {
    private static final Log logger = LogFactory.getLog(AlgorithmRunner.class);
    private static final PrintWriter pw = new PrintWriter(System.out);
    private Result result;
    private ConnectionModel connectionModel;
    private Algorithm algorithm;

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public void start(Map<String, String> algorithmRawParams, final Callback callback) {
        final Map algorithmParams = ArgumentUtils.validateParameters((Component)this.algorithm, algorithmRawParams);
        final ArgumentUtils.TextProgress progress = new ArgumentUtils.TextProgress(pw);
        new Thread(){

            @Override
            public void run() {
                logger.debug((Object)("Calling algorithm run method with parameters: " + algorithmParams));
                AlgorithmRunner.this.result = AlgorithmRunner.this.algorithm.run(AlgorithmRunner.this.connectionModel.getSchema(), algorithmParams, (Progress)progress);
                callback.algorithmDone();
            }
        }.start();
    }

    public void stop() {
        this.algorithm.cancel();
    }

    public Result getResult() {
        return this.result;
    }

    public void setConnectionModel(ConnectionModel connectionModel) {
        this.connectionModel = connectionModel;
    }

    public static interface Callback {
        public void algorithmDone();
    }
}

