/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui.ext.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.pentaho.aggdes.ui.model.SchemaModel;
import org.pentaho.aggdes.ui.util.Messages;

public class MondrianFileSchemaModel
implements SchemaModel {
    private long schemaChecksum;
    private String mondrianSchemaFilename;
    private String cubeName;

    public String getMondrianSchemaFilename() {
        return this.mondrianSchemaFilename;
    }

    public void setMondrianSchemaFilename(String mondrianSchemaFilename) {
        this.mondrianSchemaFilename = mondrianSchemaFilename;
    }

    @Override
    public long recalculateSchemaChecksum() {
        if (this.getMondrianSchemaFilename() != null) {
            try {
                CheckedInputStream cis = new CheckedInputStream(new FileInputStream(this.getMondrianSchemaFilename()), new CRC32());
                byte[] buf = new byte[1024];
                while (cis.read(buf) >= 0) {
                }
                return cis.getChecksum().getValue();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return -1L;
    }

    @Override
    public void setSchemaChecksum(long schemaChecksum) {
        this.schemaChecksum = schemaChecksum;
    }

    @Override
    public long getSchemaChecksum() {
        return this.schemaChecksum;
    }

    @Override
    public String getCubeName() {
        return this.cubeName;
    }

    @Override
    public void setCubeName(String cubeName) {
        this.cubeName = cubeName;
    }

    @Override
    public boolean schemaExists() {
        return this.mondrianSchemaFilename != null && new File(this.mondrianSchemaFilename).exists();
    }

    @Override
    public String getSchemaDoesNotExistErrorMessage() {
        return Messages.getString("MondrianFileSchemaModel.ErrorSchemaFileDoesNotExist", this.mondrianSchemaFilename);
    }
}

