/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui.ext.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.AggDesignerException;
import org.pentaho.aggdes.ui.ext.impl.AbstractMondrianSchemaProvider;
import org.pentaho.aggdes.ui.ext.impl.MondrianFileSchemaModel;
import org.pentaho.aggdes.ui.model.SchemaModel;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulFileDialog;
import org.pentaho.ui.xul.stereotype.Controller;

@Controller
public class MondrianFileSchemaProvider
extends AbstractMondrianSchemaProvider {
    private static final Log logger = LogFactory.getLog(MondrianFileSchemaProvider.class);
    private MondrianFileSchemaModel model = new MondrianFileSchemaModel();

    @Override
    public String getOverlayPath() {
        return "org/pentaho/aggdes/ui/resources/mondrianFileSchemaProvider.xul";
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.bindingFactory.createBinding("mondrianSelector", "selected", (Object)this, "selected", new BindingConvertor[0]);
        this.bindingFactory.createBinding((Object)this, "selectedEnabled", "mondrianSchemaFileName", "!disabled", new BindingConvertor[0]);
        this.bindingFactory.createBinding((Object)this, "selectedEnabled", "fileSelector", "!disabled", new BindingConvertor[0]);
        this.bindingFactory.createBinding((Object)this, "mondrianSchemaFilename", "mondrianSchemaFileName", "value", new BindingConvertor[0]);
        this.bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        this.bindingFactory.createBinding((Object)this, "enabled", "mondrianSelector", "!disabled", new BindingConvertor[0]);
        this.addPropertyChangeListener("mondrianSchemaFilename", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String val = (String)evt.getNewValue();
                MondrianFileSchemaProvider.this.setSchemaDefined(!StringUtils.isEmpty((String)val));
            }
        });
        BindingConvertor<Boolean, Boolean> isDefinedConverter = new BindingConvertor<Boolean, Boolean>(){

            public Boolean sourceToTarget(Boolean value) {
                if (Boolean.TRUE.equals(value)) {
                    return !StringUtils.isEmpty((String)MondrianFileSchemaProvider.this.getMondrianSchemaFilename());
                }
                return false;
            }

            public Boolean targetToSource(Boolean value) {
                return null;
            }
        };
        this.bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        this.bindingFactory.createBinding((Object)this, "selected", (Object)this, "schemaDefined", new BindingConvertor[]{isDefinedConverter});
        BindingConvertor<Boolean, Boolean> converter = new BindingConvertor<Boolean, Boolean>(){

            public Boolean sourceToTarget(Boolean value) {
                DatabaseMeta databaseMeta = MondrianFileSchemaProvider.this.connectionModel.getDatabaseMeta();
                boolean disabled = MondrianFileSchemaProvider.this.connectionModel.isSchemaLocked();
                if (disabled && MondrianFileSchemaProvider.this.isSelected()) {
                    MondrianFileSchemaProvider.this.setSelected(false);
                }
                return disabled;
            }

            public Boolean targetToSource(Boolean value) {
                return null;
            }
        };
        this.bindingFactory.createBinding((Object)this.connectionModel, "schemaSourceSelectionEnabled", "mondrianSelector", "disabled", new BindingConvertor[]{converter});
    }

    @Override
    public String getMondrianSchemaFilename() {
        return this.model.getMondrianSchemaFilename();
    }

    public void setMondrianSchemaFilename(String mondrianSchemaFilename) {
        String oldVal = this.model.getMondrianSchemaFilename();
        this.model.setMondrianSchemaFilename(mondrianSchemaFilename);
        this.firePropertyChange("mondrianSchemaFilename", oldVal, mondrianSchemaFilename);
    }

    public void chooseFile() throws AggDesignerException {
        try {
            XulFileDialog fc = (XulFileDialog)this.document.createElement("filedialog");
            XulFileDialog.RETURN_CODE retVal = this.getLastFile() != null ? fc.showOpenDialog((Object)this.getLastFile()) : fc.showOpenDialog();
            if (retVal == XulFileDialog.RETURN_CODE.OK) {
                File selectedFile = (File)fc.getFile();
                this.setLastFile(selectedFile);
                this.setMondrianSchemaFilename(((File)fc.getFile()).getAbsolutePath());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error showing file chooser", (Throwable)e);
            throw new AggDesignerException((Throwable)e);
        }
    }

    private String getFileContents(File file) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected File getLastFile() {
        File file = new File(".schemaInfo");
        if (file.exists()) {
            String path = this.getFileContents(file).replaceAll("\n", "");
            return new File(path);
        }
        return null;
    }

    protected void setLastFile(File f) {
        try {
            File file = new File(".schemaInfo");
            PrintWriter pw = new PrintWriter(new FileWriter(file));
            pw.println(f.getAbsolutePath());
            pw.close();
        }
        catch (Exception e) {
            logger.error((Object)"could not write last file path", (Throwable)e);
        }
    }

    @Override
    public boolean supportsSchemaModel(SchemaModel schemaModel) {
        return schemaModel instanceof MondrianFileSchemaModel;
    }

    @Override
    public MondrianFileSchemaModel getSchemaModel() {
        return this.model;
    }

    @Override
    public void setSchemaModel(SchemaModel model) {
        MondrianFileSchemaModel schemaModel = (MondrianFileSchemaModel)model;
        String oldVal = this.model.getMondrianSchemaFilename();
        this.model = schemaModel;
        this.firePropertyChange("mondrianSchemaFilename", oldVal, schemaModel.getMondrianSchemaFilename());
    }

    public String getName() {
        return "mondrianFileSchemaProvider";
    }

    @Override
    public void reset() {
        this.setSchemaModel(new MondrianFileSchemaModel());
        this.firePropertyChange("mondrianSchemaFilename", "", null);
    }

    @Override
    public void onUnload() {
    }
}

