/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui.form.controller;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.AggDesignerException;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.output.OutputService;
import org.pentaho.aggdes.ui.Workspace;
import org.pentaho.aggdes.ui.ext.SchemaProviderUiExtension;
import org.pentaho.aggdes.ui.form.model.ConnectionModel;
import org.pentaho.aggdes.ui.model.SchemaModel;
import org.pentaho.aggdes.ui.util.Messages;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.ui.xul.XulEventSource;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.stereotype.Controller;
import org.pentaho.ui.xul.stereotype.RequestHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Controller
public class ConnectionController
extends AbstractXulEventHandler {
    public static final String CONNECT_ERROR_DIALOG = "connectErrorDialog";
    public static final String CONNECTION_DIALOG = "connection_dialog";
    public static final String ANON_WAIT_DIALOG = "anonWaitDialog";
    public static final String GENERAL_DATASOURCE_WINDOW = "general-datasource-window";
    private static final Log logger = LogFactory.getLog(ConnectionController.class);
    private ConnectionModel connectionModel;
    private XulEventHandler dataHandler;
    private Workspace workspace;
    private OutputService outputService;
    private List<SchemaProviderUiExtension> schemaProviders = new ArrayList<SchemaProviderUiExtension>();
    private SchemaProviderUiExtension selectedSchemaProvider = null;
    private Schema schema = null;
    private BindingFactory bindingFactory;
    private List<String> cubeNames = null;

    @Autowired
    public void setBindingFactory(BindingFactory bindingFactory) {
        this.bindingFactory = bindingFactory;
    }

    public void setOutputService(OutputService outputService) {
        this.outputService = outputService;
    }

    public List<SchemaProviderUiExtension> getSchemaProviders() {
        return this.schemaProviders;
    }

    public void setConnectionModel(ConnectionModel connectionModel) {
        this.connectionModel = connectionModel;
    }

    public void setDataHandler(XulEventHandler dataHandler) {
        this.dataHandler = dataHandler;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Autowired
    public void setSchemaProviders(List<SchemaProviderUiExtension> schemaProviders) {
        this.schemaProviders = schemaProviders;
    }

    public void setSelectedSchemaProvider() {
        this.selectedSchemaProvider = null;
        for (SchemaProviderUiExtension sProvider : this.schemaProviders) {
            if (!sProvider.isSelected()) continue;
            this.selectedSchemaProvider = sProvider;
        }
    }

    public void reset() throws Exception {
        this.connectionModel.reset();
        for (SchemaProviderUiExtension extension : this.schemaProviders) {
            extension.reset();
        }
    }

    @RequestHandler
    public void onLoad() throws Exception {
        BindingFactory bf = this.bindingFactory;
        bf.setDocument(this.document);
        for (final SchemaProviderUiExtension extension : this.schemaProviders) {
            try {
                this.document.addOverlay(extension.getOverlayPath());
                this.getXulDomContainer().addEventHandler((XulEventHandler)extension);
                ((XulEventSource)extension).addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        boolean schemaAppliable = false;
                        if (evt.getPropertyName().equals("schemaDefined") || evt.getPropertyName().equals("selected")) {
                            logger.debug((Object)("*** got schemaDefined=" + evt.getNewValue() + ", checking if any providers are applyable"));
                            for (SchemaProviderUiExtension ex : ConnectionController.this.schemaProviders) {
                                if (evt.getPropertyName().equals("selected") && extension != ex && evt.getNewValue() == Boolean.TRUE) {
                                    ex.setSelected(false);
                                }
                                if (ex.isSchemaDefined() && ex.isSelected()) {
                                    logger.debug((Object)("provider " + ex.getName() + " is applyable"));
                                    schemaAppliable = true;
                                    continue;
                                }
                                logger.debug((Object)(ex.getName() + " NOT applyable: defined=[" + ex.isSchemaDefined() + "] selected=[" + ex.isSelected() + "]"));
                            }
                            ConnectionController.this.connectionModel.setApplySchemaSourceEnabled(schemaAppliable);
                        }
                    }
                });
                bf.setBindingType(Binding.Type.ONE_WAY);
                bf.createBinding((Object)this.connectionModel, "schemaLocked", (Object)extension, "!enabled", new BindingConvertor[0]);
            }
            catch (XulException e) {
                logger.error((Object)"Error loading Schema Provider Overlay", (Throwable)e);
            }
        }
        bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        bf.createBinding((Object)this.workspace, "applicationUnlocked", "open_advisor", "!disabled", new BindingConvertor[0]);
        bf.createBinding((Object)this.workspace, "applicationUnlocked", "open_export", "!disabled", new BindingConvertor[0]);
        bf.createBinding((Object)this.workspace, "applicationUnlocked", "agg_add_btn", "!disabled", new BindingConvertor[0]);
        bf.createBinding((Object)this.connectionModel, "cubeNames", "cubeSelector", "elements", new BindingConvertor[0]);
        bf.createBinding((Object)this.connectionModel, "cubeName", "cubeSelector", "selectedItem", new BindingConvertor[0]);
        bf.setBindingType(Binding.Type.ONE_WAY);
        bf.createBinding((Object)this.connectionModel, "applySchemaSourceEnabled", "applySchemaSourceButton", "!disabled", new BindingConvertor[0]);
        bf.createBinding((Object)this.connectionModel, "databaseName", "databaseName", "value", new BindingConvertor[0]);
        bf.createBinding((Object)this.connectionModel, "cubeSelectionEnabled", "cubeSelector", "!disabled", new BindingConvertor[0]);
        bf.createBinding((Object)this.connectionModel, "schemaLocked", "cubeSelector", "disabled", new BindingConvertor[0]);
        bf.createBinding((Object)this.connectionModel, "schemaLocked", "applySchemaSourceButton", "disabled", new BindingConvertor[0]);
        bf.createBinding((Object)this.connectionModel, "connectEnabled", "connection_dialog_accept", "!disabled", new BindingConvertor[0]).fireSourceChanged();
        this.connectionModel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("selectedSchemaModel")) {
                    SchemaModel model = (SchemaModel)evt.getNewValue();
                    for (SchemaProviderUiExtension extension : ConnectionController.this.schemaProviders) {
                        if (model != null && extension.supportsSchemaModel(model)) {
                            ConnectionController.this.selectedSchemaProvider = extension;
                            extension.setSelected(true);
                            extension.setSchemaModel(model);
                            continue;
                        }
                        extension.setSelected(false);
                    }
                }
            }
        });
        for (final SchemaProviderUiExtension extension : this.schemaProviders) {
            extension.onLoad();
        }
        if (this.schemaProviders.size() == 1) {
            this.schemaProviders.get(0).setSelected(true);
        }
        this.document.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConnectionController.this.showConnectionDialog();
            }
        });
    }

    @RequestHandler
    public void loadDatabaseDialog() {
        this.dataHandler.setData((Object)this.connectionModel.getDatabaseMeta());
        XulDialog dialog = (XulDialog)this.document.getElementById(GENERAL_DATASOURCE_WINDOW);
        dialog.show();
        DatabaseMeta databaseMeta = (DatabaseMeta)this.dataHandler.getData();
        if (databaseMeta != null) {
            this.connectionModel.setDatabaseMeta(databaseMeta);
        }
    }

    @RequestHandler
    public void connect() {
        final XulDialog waitDialog = (XulDialog)this.document.getElementById(ANON_WAIT_DIALOG);
        try {
            if (this.selectedSchemaProvider == null) {
                throw new AggDesignerException(Messages.getString("select_olap_model", new Object[0]));
            }
            this.workspace.setApplicationUnlocked(false);
            new Thread(){

                @Override
                public void run() {
                    try {
                        while (waitDialog.isHidden()) {
                            Thread.sleep(300L);
                        }
                        ConnectionController.this.schema = ConnectionController.this.selectedSchemaProvider.loadSchema(ConnectionController.this.connectionModel.getCubeName());
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error loading schema: ", (Throwable)e);
                    }
                    finally {
                        waitDialog.hide();
                    }
                }
            }.start();
            waitDialog.show();
            if (this.schema == null) {
                throw new AggDesignerException("Error loading Schema");
            }
            this.connectionModel.setSchema(this.schema);
            this.outputService.init(this.schema);
            this.connectionModel.setSchemaUpToDate(true);
            this.workspace.setApplicationUnlocked(true);
            this.hideConnectionDialog();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to connect", (Throwable)e);
            if (!waitDialog.isHidden()) {
                waitDialog.hide();
            }
            XulDialog connectErrorDialog = (XulDialog)this.document.getElementById(CONNECT_ERROR_DIALOG);
            Assert.notNull((Object)connectErrorDialog, (String)"missing element from document");
            XulTextbox connectErrorDialogMessage = (XulTextbox)this.document.getElementById("connectErrorDialogMessage");
            Assert.notNull((Object)connectErrorDialogMessage, (String)"missing element from document");
            connectErrorDialogMessage.setValue(e.getLocalizedMessage());
            connectErrorDialog.show();
        }
    }

    @RequestHandler
    public void connectErrorDialogDismiss() {
        XulDialog connectErrorDialog = (XulDialog)this.document.getElementById(CONNECT_ERROR_DIALOG);
        Assert.notNull((Object)connectErrorDialog, (String)"missing element from document");
        if (!connectErrorDialog.isHidden()) {
            connectErrorDialog.hide();
        }
    }

    @RequestHandler
    public void showConnectionDialog() {
        logger.debug((Object)"In Thread showing mondrian dialog");
        XulDialog connectionDialog = (XulDialog)this.document.getElementById(CONNECTION_DIALOG);
        connectionDialog.show();
    }

    @RequestHandler
    public void hideConnectionDialog() {
        XulDialog connectionDialog = (XulDialog)this.document.getElementById(CONNECTION_DIALOG);
        connectionDialog.hide();
    }

    @RequestHandler
    public void apply() throws XulException {
        final XulDialog waitDialog = (XulDialog)this.document.getElementById(ANON_WAIT_DIALOG);
        logger.debug((Object)"starting thread");
        new Thread(){

            @Override
            public void run() {
                while (waitDialog.isHidden()) {
                    try {
                        logger.debug((Object)"waiting for wait dialog to show");
                        5.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)"an exception occurred", (Throwable)e);
                        return;
                    }
                }
                logger.debug((Object)"apply is running in separate thread");
                try {
                    ConnectionController.this.setSelectedSchemaProvider();
                    if (ConnectionController.this.selectedSchemaProvider == null) {
                        throw new AggDesignerException(Messages.getString("select_olap_model", new Object[0]));
                    }
                    ConnectionController.this.cubeNames = ConnectionController.this.selectedSchemaProvider.getCubeNames();
                }
                catch (AggDesignerException e) {
                    logger.error((Object)"Error loading OLAP schema", (Throwable)e);
                    try {
                        XulMessageBox box = (XulMessageBox)ConnectionController.this.document.createElement("messagebox");
                        box.setTitle("Error");
                        box.setMessage(Messages.getString("Olap.apply.error", new Object[0]));
                        box.open();
                    }
                    catch (XulException xulException) {
                        // empty catch block
                    }
                }
                finally {
                    logger.debug((Object)"hiding dialog if it isn't already hidden");
                    waitDialog.hide();
                }
            }
        }.start();
        logger.debug((Object)"showing wait dialog");
        waitDialog.show();
        if (this.selectedSchemaProvider == null) {
            XulMessageBox box = (XulMessageBox)this.document.createElement("messagebox");
            box.setTitle("Error");
            box.setMessage("Error applying OLAP schema");
            box.open();
            return;
        }
        this.connectionModel.setCubeNames(this.cubeNames);
        this.connectionModel.setSelectedSchemaModel(this.selectedSchemaProvider.getSchemaModel());
    }
}

