/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.ui.model.AggList;
import org.pentaho.aggdes.ui.model.AggListEvent;
import org.pentaho.aggdes.ui.model.AggListListener;
import org.pentaho.aggdes.ui.model.UIAggregate;
import org.pentaho.aggdes.ui.util.EventSupport;

public class AggListImpl
implements AggList {
    private static final Log logger = LogFactory.getLog(AggListImpl.class);
    private List<UIAggregate> list;
    private EventSupport<AggListListener> eventSupport = new EventSupport();
    private int selectedIndex = -1;

    public AggListImpl() {
        this(new ArrayList<UIAggregate>());
    }

    public AggListImpl(List<UIAggregate> list) {
        this.list = Collections.synchronizedList(list);
    }

    @Override
    public void addAgg(UIAggregate agg) {
        boolean added = this.list.add(agg);
        if (added) {
            this.fireEvent(new AggListEvent(this, AggListEvent.Type.AGG_ADDED, this.list.size() - 1));
        }
    }

    protected void fireEvent(AggListEvent e) {
        for (AggListListener l : this.eventSupport.getListeners()) {
            l.listChanged(e);
        }
    }

    @Override
    public void addAggListListener(AggListListener l) {
        this.eventSupport.addListener(l);
    }

    @Override
    public UIAggregate getAgg(int index) {
        if (index < 0 || index > this.list.size()) {
            return null;
        }
        return this.list.get(index);
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public void removeAggListListener(AggListListener l) {
        this.eventSupport.removeListener(l);
    }

    @Override
    public void removeAgg(int index) {
        if (0 <= index && index < this.list.size()) {
            UIAggregate old = this.list.remove(index);
            if (index == this.selectedIndex) {
                this.setSelectedIndex(-1);
            }
            if (old != null) {
                this.fireEvent(new AggListEvent(this, AggListEvent.Type.AGG_REMOVED, index));
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("index out of bounds: " + index));
        }
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    public void setSelectedIndex(int index) {
        if (this.selectedIndex == index) {
            return;
        }
        this.fireEvent(new AggListEvent(this, AggListEvent.Type.SELECTION_CHANGING, this.selectedIndex));
        this.selectedIndex = index;
        this.fireEvent(new AggListEvent(this, AggListEvent.Type.SELECTION_CHANGED, this.selectedIndex));
    }

    @Override
    public UIAggregate getSelectedValue() {
        return this.selectedIndex > -1 ? this.list.get(this.selectedIndex) : null;
    }

    @Override
    public void aggChanged(UIAggregate agg) {
        if (!this.list.contains(agg)) {
            throw new IllegalArgumentException("Aggregate not in list");
        }
        this.fireEvent(new AggListEvent(this, AggListEvent.Type.AGG_CHANGED, this.list.indexOf(agg)));
    }

    @Override
    public Iterator<UIAggregate> iterator() {
        return Collections.unmodifiableList(this.list).iterator();
    }

    @Override
    public void addAggs(List<UIAggregate> aggs) {
        boolean added = this.list.addAll(aggs);
        if (added) {
            this.fireEvent(new AggListEvent(this, AggListEvent.Type.AGGS_ADDED, this.list.size() - aggs.size()));
        }
    }

    @Override
    public void clearAggs() {
        this.list.clear();
        this.setSelectedIndex(-1);
        this.fireEvent(new AggListEvent(this, AggListEvent.Type.AGGS_CLEARED, 0));
    }

    @Override
    public void moveAggDown(UIAggregate agg) {
        int curpos = this.list.indexOf(agg);
        if (curpos + 1 == this.list.size()) {
            return;
        }
        this.list.remove(agg);
        this.list.add(curpos + 1, agg);
        this.fireEvent(new AggListEvent(this, AggListEvent.Type.AGG_CHANGED, this.list.indexOf(agg)));
        this.fireEvent(new AggListEvent(this, AggListEvent.Type.AGG_CHANGED, this.list.indexOf(agg) - 1));
        this.setSelectedIndex(curpos + 1);
    }

    @Override
    public void moveAggUp(UIAggregate agg) {
        int curpos = this.list.indexOf(agg);
        if (curpos == 0) {
            return;
        }
        this.list.remove(agg);
        this.list.add(curpos - 1, agg);
        this.fireEvent(new AggListEvent(this, AggListEvent.Type.AGG_CHANGED, this.list.indexOf(agg)));
        this.fireEvent(new AggListEvent(this, AggListEvent.Type.AGG_CHANGED, this.list.indexOf(agg) + 1));
        this.setSelectedIndex(curpos - 1);
    }

    @Override
    public void uncheckAll() {
        for (UIAggregate agg : this.list) {
            agg.setEnabled(false);
            this.fireEvent(new AggListEvent(this, AggListEvent.Type.AGG_CHANGED, this.list.indexOf(agg)));
        }
    }

    @Override
    public void checkAll() {
        for (UIAggregate agg : this.list) {
            agg.setEnabled(true);
            this.fireEvent(new AggListEvent(this, AggListEvent.Type.AGG_CHANGED, this.list.indexOf(agg)));
        }
    }
}

