/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseFactoryInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.DatabaseTestResults;
import org.pentaho.di.core.database.GenericDatabaseMeta;
import org.pentaho.di.core.database.PartitionDatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.i18n.BaseMessages;

public class DatabaseFactory
implements DatabaseFactoryInterface {
    private static Class<?> PKG = Database.class;
    private boolean success;
    private Exception capturedException;
    public static final LoggingObjectInterface loggingObject = new SimpleLoggingObject("Database factory", LoggingObjectType.GENERAL, null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConnectionTestReport(DatabaseMeta databaseMeta) {
        this.success = true;
        if (databaseMeta.getAccessType() != 3) {
            StringBuilder report = new StringBuilder();
            Database db = new Database(loggingObject, databaseMeta);
            if (databaseMeta.isPartitioned()) {
                PartitionDatabaseMeta[] partitioningInformation = databaseMeta.getPartitioningInformation();
                for (int i = 0; i < partitioningInformation.length; ++i) {
                    try {
                        db.connect(partitioningInformation[i].getPartitionId());
                        report.append(BaseMessages.getString(PKG, "DatabaseMeta.report.ConnectionWithPartOk", databaseMeta.getName(), partitioningInformation[i].getPartitionId()) + Const.CR);
                    }
                    catch (KettleException e) {
                        this.capturedException = e;
                        report.append(BaseMessages.getString(PKG, "DatabaseMeta.report.ConnectionWithPartError", databaseMeta.getName(), partitioningInformation[i].getPartitionId(), e.toString()) + Const.CR);
                        report.append(Const.getStackTracker(e) + Const.CR);
                        this.success = false;
                    }
                    finally {
                        db.disconnect();
                    }
                    this.appendConnectionInfo(report, db.environmentSubstitute(partitioningInformation[i].getHostname()), db.environmentSubstitute(partitioningInformation[i].getPort()), db.environmentSubstitute(partitioningInformation[i].getDatabaseName()));
                    report.append(Const.CR);
                }
            } else {
                try {
                    db.connect();
                    report.append(BaseMessages.getString(PKG, "DatabaseMeta.report.ConnectionOk", databaseMeta.getName()) + Const.CR);
                }
                catch (KettleException e) {
                    this.capturedException = e;
                    report.append(BaseMessages.getString(PKG, "DatabaseMeta.report.ConnectionError", databaseMeta.getName()) + e.toString() + Const.CR);
                    report.append(Const.getStackTracker(e) + Const.CR);
                    this.success = false;
                }
                finally {
                    db.disconnect();
                }
                if (databaseMeta.getAccessType() == 4) {
                    this.appendJndiConnectionInfo(report, db.environmentSubstitute(databaseMeta.getDatabaseName()));
                } else {
                    this.appendConnectionInfo(report, db, databaseMeta);
                }
                report.append(Const.CR);
            }
            return report.toString();
        }
        this.success = false;
        return BaseMessages.getString(PKG, "BaseDatabaseMeta.TestConnectionReportNotImplemented.Message", new String[0]);
    }

    @Override
    public DatabaseTestResults getConnectionTestResults(DatabaseMeta databaseMeta) throws KettleDatabaseException {
        DatabaseTestResults databaseTestResults = new DatabaseTestResults();
        String message = this.getConnectionTestReport(databaseMeta);
        databaseTestResults.setException(this.capturedException);
        databaseTestResults.setMessage(message);
        databaseTestResults.setSuccess(this.success);
        return databaseTestResults;
    }

    private StringBuilder appendJndiConnectionInfo(StringBuilder report, String jndiName) {
        report.append(BaseMessages.getString(PKG, "DatabaseMeta.report.JndiName", new String[0])).append(jndiName).append(Const.CR);
        return report;
    }

    private StringBuilder appendConnectionInfo(StringBuilder report, Database db, DatabaseMeta databaseMeta) {
        if (databaseMeta.getDatabaseInterface() instanceof GenericDatabaseMeta) {
            String customUrl = databaseMeta.getAttributes().getProperty("CUSTOM_URL");
            String customDriverClass = databaseMeta.getAttributes().getProperty("CUSTOM_DRIVER_CLASS");
            return report.append(BaseMessages.getString(PKG, "GenericDatabaseMeta.report.customUrl", new String[0])).append(db.environmentSubstitute(customUrl)).append(Const.CR).append(BaseMessages.getString(PKG, "GenericDatabaseMeta.report.customDriverClass", new String[0])).append(db.environmentSubstitute(customDriverClass)).append(Const.CR);
        }
        return this.appendConnectionInfo(report, db.environmentSubstitute(databaseMeta.getHostname()), db.environmentSubstitute(databaseMeta.getDatabasePortNumberString()), db.environmentSubstitute(databaseMeta.getDatabaseName()));
    }

    private StringBuilder appendConnectionInfo(StringBuilder report, String hostName, String portNumber, String dbName) {
        report.append(BaseMessages.getString(PKG, "DatabaseMeta.report.Hostname", new String[0])).append(hostName).append(Const.CR);
        report.append(BaseMessages.getString(PKG, "DatabaseMeta.report.Port", new String[0])).append(portNumber).append(Const.CR);
        report.append(BaseMessages.getString(PKG, "DatabaseMeta.report.DatabaseName", new String[0])).append(dbName).append(Const.CR);
        return report;
    }
}

