/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mondrian.publish.workbench;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import mondrian.gui.SchemaExplorer;
import mondrian.gui.Workbench;
import mondrian.gui.WorkbenchMenubarPlugin;
import org.pentaho.mondrian.publish.Messages;
import org.pentaho.mondrian.publish.PublishSchemaPluginParent;
import org.pentaho.mondrian.publish.PublishToServerCommand;

public class MondrianPublish
implements WorkbenchMenubarPlugin,
PublishSchemaPluginParent {
    private static final Logger LOG = Logger.getLogger(PublishToServerCommand.class.getName());
    private Workbench workbench;

    public void setWorkbench(Workbench workbench) {
        this.workbench = workbench;
    }

    public void addItemsToMenubar(JMenuBar menubar) {
        JMenu menu = menubar.getMenu(0);
        int loc = this.getFirstMenuSeparator(menu);
        JMenuItem publish = new JMenuItem("Publish...");
        publish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaExplorer schemaExplorer = MondrianPublish.this.workbench.getCurrentSchemaExplorer();
                if (schemaExplorer == null) {
                    JOptionPane.showMessageDialog((Component)MondrianPublish.this.workbench, Messages.getString("NoSchemaSelectedWarning.Message"), Messages.getString("NoSchemaSelectedWarning.Title"), 2);
                    return;
                }
                if (schemaExplorer.isDirty()) {
                    int option = JOptionPane.showConfirmDialog((Component)MondrianPublish.this.workbench, Messages.getString("SchemaModifiedWarning.Message"), Messages.getString("SchemaModifiedWarning.Title"), 1, 2);
                    if (option == 0) {
                        MondrianPublish.this.workbench.saveMenuItemActionPerformed(null);
                    } else if (option == 2) {
                        return;
                    }
                }
                PublishToServerCommand command = new PublishToServerCommand();
                command.execute(MondrianPublish.this);
            }
        });
        menu.add((Component)publish, loc);
        menu.add((Component)new JSeparator(), loc);
    }

    private int getFirstMenuSeparator(JMenu menu) {
        for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
            if (!(menu.getMenuComponent(i) instanceof JSeparator)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public JFrame getFrame() {
        return this.workbench;
    }

    @Override
    public String getProperty(String name) {
        return this.workbench.getWorkbenchProperty(name);
    }

    @Override
    public void setProperty(String name, String value) {
        this.workbench.setWorkbenchProperty(name, value);
    }

    @Override
    public void storeProperties() {
        this.workbench.storeWorkbenchProperties();
    }

    @Override
    public String getSchemaName() {
        return this.workbench.getCurrentSchemaExplorer().getSchema().name;
    }

    @Override
    public File getSchemaFile() {
        return this.workbench.getCurrentSchemaExplorer().getSchemaFile();
    }
}

