/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.model.mondrian.validate;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mondrian.olap.MondrianDef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.model.ValidationMessage;
import org.pentaho.aggdes.model.mondrian.validate.AbstractMondrianSchemaValidator;

public class DimensionFkValidator
extends AbstractMondrianSchemaValidator {
    private static final Log logger = LogFactory.getLog(DimensionFkValidator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ValidationMessage> validateCube(MondrianDef.Schema schema, MondrianDef.Cube cube, Connection conn) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        HashMap<String, Boolean> checkedRelations = new HashMap<String, Boolean>();
        DatabaseMetaData meta = null;
        try {
            meta = conn.getMetaData();
        }
        catch (SQLException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"an exception occurred", (Throwable)e);
            }
            return this.fatal(e, messages);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("processing cube \"" + cube.name + "\""));
        }
        if (!(cube.fact instanceof MondrianDef.Table)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("cube \"" + cube.name + "\" contains unsupported fact type, " + cube.fact));
            }
            return messages;
        }
        String factTableName = ((MondrianDef.Table)cube.fact).name;
        String schemaName = ((MondrianDef.Table)cube.fact).schema;
        for (MondrianDef.CubeDimension dim : cube.dimensions) {
            String foreignKey = dim.foreignKey;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("processing dimension \"" + dim.name + "\""));
            }
            if (foreignKey == null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"dimension is degenerate, skipping");
                continue;
            }
            if (checkedRelations.containsKey(this.makeKey(schemaName, factTableName, foreignKey))) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("already checked that foreign key not null on column \"" + (null == schemaName ? "" : schemaName + ".") + factTableName + "." + foreignKey + "\"; skipping"));
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("checking that foreign key not null on column \"" + (null == schemaName ? "" : schemaName + ".") + factTableName + "." + foreignKey + "\""));
            }
            ResultSet rs = null;
            try {
                rs = meta.getColumns(null, schemaName, factTableName, foreignKey);
            }
            catch (SQLException e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"an exception occurred", (Throwable)e);
                }
                return this.fatal(e, messages);
            }
            boolean isNullable = true;
            try {
                if (rs.next() && rs.getString("IS_NULLABLE").equals("NO")) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"column is not nullable; skipping value check");
                    }
                    isNullable = false;
                }
            }
            catch (SQLException e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"an exception occurred", (Throwable)e);
                }
                return this.fatal(e, messages);
            }
            if (isNullable) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"falling back on checking column values");
                }
                Statement stmt = null;
                boolean nulls = false;
                try {
                    long nullCount;
                    ResultSet rs2;
                    String sql = MessageFormat.format("select count(*) as null_count from {0} where {1} is null", (null == schemaName ? "" : schemaName + ".") + factTableName, foreignKey);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("executing query: " + sql));
                    }
                    if ((rs2 = (stmt = conn.createStatement()).executeQuery(sql)).next() && (nullCount = rs2.getLong("null_count")) > 0L) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"foreign key column contains null values");
                        }
                        nulls = true;
                    }
                }
                catch (SQLException e) {
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)"an exception occurred", (Throwable)e);
                    }
                    List<ValidationMessage> list = this.fatal(e, messages);
                    return list;
                }
                finally {
                    try {
                        if (null != stmt) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        if (logger.isErrorEnabled()) {
                            logger.error((Object)"an exception occurred", (Throwable)e);
                        }
                        return this.fatal(e, messages);
                    }
                }
                if (nulls) {
                    this.append(messages, ValidationMessage.Type.ERROR, "ERROR_CUBE_FK_CHECK", cube.name, factTableName, foreignKey);
                } else {
                    this.append(messages, ValidationMessage.Type.OK, "OK_CUBE_FK_CHECK", cube.name, factTableName, foreignKey);
                }
            } else {
                this.append(messages, ValidationMessage.Type.OK, "OK_CUBE_FK_CHECK", cube.name, factTableName, foreignKey);
            }
            checkedRelations.put(this.makeKey(schemaName, factTableName, foreignKey), true);
        }
        return messages;
    }

    private String makeKey(String schemaName, String tableName, String columnName) {
        return (null == schemaName ? "" : schemaName + ".") + tableName + "." + columnName;
    }
}

