/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.model.mondrian.validate;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mondrian.olap.MondrianDef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.model.ValidationMessage;
import org.pentaho.aggdes.model.mondrian.validate.AbstractMondrianSchemaValidator;

public class HierarchyPkValidator
extends AbstractMondrianSchemaValidator {
    private static final Log logger = LogFactory.getLog(HierarchyPkValidator.class);

    @Override
    public List<ValidationMessage> validateCube(MondrianDef.Schema schema, MondrianDef.Cube cube, Connection conn) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        HashMap<String, Boolean> checkedRelations = new HashMap<String, Boolean>();
        DatabaseMetaData meta = null;
        try {
            meta = conn.getMetaData();
        }
        catch (SQLException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"an exception occurred", (Throwable)e);
            }
            return this.fatal(e, messages);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("processing cube \"" + cube.name + "\""));
        }
        if (!(cube.fact instanceof MondrianDef.Table)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("cube \"" + cube.name + "\" contains unsupported fact type, " + cube.fact));
            }
            return messages;
        }
        String schemaName = ((MondrianDef.Table)cube.fact).schema;
        block6: for (MondrianDef.CubeDimension dim : cube.dimensions) {
            for (MondrianDef.Hierarchy hierarchy : dim.getDimension((MondrianDef.Schema)schema).hierarchies) {
                if (null == hierarchy.primaryKey) {
                    if (!logger.isDebugEnabled()) continue block6;
                    logger.debug((Object)"skipping primary key check as hierarchy table and fact table are the same");
                    continue block6;
                }
                String primaryKey = hierarchy.primaryKey;
                String primaryKeyTable = null != hierarchy.primaryKeyTable ? hierarchy.primaryKeyTable : (null != hierarchy.relation ? ((MondrianDef.Table)hierarchy.relation).name : ((MondrianDef.Table)cube.fact).name);
                if (checkedRelations.containsKey(primaryKeyTable)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("already checked that primary key exists on relation \"" + (null == schemaName ? "" : schemaName + ".") + primaryKeyTable + "\"; skipping"));
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("checking that primary key exists on relation \"" + (null == schemaName ? "" : schemaName + ".") + primaryKeyTable + "\""));
                }
                ResultSet rs2 = null;
                try {
                    rs2 = meta.getPrimaryKeys(null, schemaName, primaryKeyTable);
                }
                catch (SQLException e) {
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)"an exception occurred", (Throwable)e);
                    }
                    return this.fatal(e, messages);
                }
                boolean pkHierarchyFound = false;
                try {
                    if (rs2.next()) {
                        pkHierarchyFound = true;
                    }
                }
                catch (SQLException e) {
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)"an exception occurred", (Throwable)e);
                    }
                    return this.fatal(e, messages);
                }
                if (!pkHierarchyFound) {
                    this.append(messages, ValidationMessage.Type.ERROR, "ERROR_HIERARCHY_TABLE_PK_CHECK", primaryKeyTable);
                } else {
                    this.append(messages, ValidationMessage.Type.OK, "OK_HIERARCHY_TABLE_PK_CHECK", primaryKeyTable);
                }
                checkedRelations.put(primaryKeyTable, true);
            }
        }
        return messages;
    }
}

