/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.output.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.pentaho.aggdes.algorithm.Result;
import org.pentaho.aggdes.algorithm.impl.AlgorithmImpl;
import org.pentaho.aggdes.model.Parameter;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.output.Output;
import org.pentaho.aggdes.output.ResultHandler;
import org.pentaho.aggdes.output.impl.AbstractGenerator;
import org.pentaho.aggdes.output.impl.AggregateTableOutputFactory;
import org.pentaho.aggdes.output.impl.CreateTableGenerator;
import org.pentaho.aggdes.output.impl.MondrianSchemaGenerator;
import org.pentaho.aggdes.output.impl.PopulateTableGenerator;

public class ResultHandlerImpl
implements ResultHandler {
    public static final String NL = System.getProperty("line.separator");
    private final List<Parameter> parameterList = new ArrayList<ParameterEnum>(Arrays.asList(ParameterEnum.values()));

    @Override
    public List<Parameter> getParameters() {
        return this.parameterList;
    }

    @Override
    public String getName() {
        return AlgorithmImpl.getBaseName(this.getClass());
    }

    private PrintWriter getPrintWriter(String outputFileName) {
        PrintWriter pw;
        if (outputFileName != null) {
            try {
                File outputFile = new File(outputFileName);
                File parentFile = outputFile.getCanonicalFile().getParentFile();
                if (parentFile != null && parentFile.mkdirs()) {
                    System.out.println("Created folder " + parentFile);
                }
                FileWriter writer = new FileWriter(outputFile);
                pw = new PrintWriter(writer);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while opening output file " + outputFileName, e);
            }
        } else {
            pw = new PrintWriter(System.out);
        }
        return pw;
    }

    private void closePrintWriter(String outputFileName, PrintWriter pw) {
        if (outputFileName != null) {
            pw.close();
        }
    }

    @Override
    public void handle(Map<Parameter, Object> parameterValues, Schema schema, Result result) {
        PrintWriter pw;
        AbstractGenerator generator;
        boolean doTables = parameterValues.get(ParameterEnum.tables) != null && (Boolean)parameterValues.get(ParameterEnum.tables) != false;
        boolean doIndexes = parameterValues.get(ParameterEnum.indexes) != null && (Boolean)parameterValues.get(ParameterEnum.indexes) != false;
        boolean doPopulate = parameterValues.get(ParameterEnum.populate) != null && (Boolean)parameterValues.get(ParameterEnum.populate) != false;
        boolean doMondrianSchema = parameterValues.get(ParameterEnum.mondrianSchema) != null && (Boolean)parameterValues.get(ParameterEnum.mondrianSchema) != false;
        AggregateTableOutputFactory outputFactory = new AggregateTableOutputFactory();
        List<Output> outputs = outputFactory.createOutputs(schema, result.getAggregates());
        if (doTables) {
            String tableOutput = (String)parameterValues.get(ParameterEnum.tableOutput);
            generator = new CreateTableGenerator();
            pw = this.getPrintWriter(tableOutput);
            pw.println(generator.generateFull(schema, outputs));
            pw.flush();
            this.closePrintWriter(tableOutput, pw);
        }
        if (doPopulate) {
            String populateOutput = (String)parameterValues.get(ParameterEnum.populateOutput);
            generator = new PopulateTableGenerator();
            pw = this.getPrintWriter(populateOutput);
            pw.println(generator.generateFull(schema, outputs));
            pw.flush();
            this.closePrintWriter(populateOutput, pw);
        }
        if (doMondrianSchema) {
            String mondrianOutput = (String)parameterValues.get(ParameterEnum.mondrianOutput);
            generator = new MondrianSchemaGenerator();
            pw = this.getPrintWriter(mondrianOutput);
            pw.println(((MondrianSchemaGenerator)generator).generateFull(schema, outputs));
            pw.flush();
            this.closePrintWriter(mondrianOutput, pw);
        }
    }

    static enum ParameterEnum implements Parameter
    {
        tables("Whether to output CREATE TABLE statements.", false, Parameter.Type.BOOLEAN),
        tableOutput("File to write table output, defaults to system output", false, Parameter.Type.STRING),
        indexes("Whether to output CREATE INDEX statements.", false, Parameter.Type.BOOLEAN),
        indexOutput("File to write table output, defaults to system output", false, Parameter.Type.STRING),
        populate("Whether to output INSERT INTO ... SELECT statements.", false, Parameter.Type.BOOLEAN),
        populateOutput("File to write dml output, defaults to system output", false, Parameter.Type.STRING),
        mondrianSchema("Whether to output AggName elements within the Mondrian Schema", false, Parameter.Type.BOOLEAN),
        mondrianOutput("File to write dml output, defaults to mondrian.xml", false, Parameter.Type.STRING);

        private final String description;
        private final boolean required;
        private final Parameter.Type type;

        private ParameterEnum(String description, boolean required, Parameter.Type type) {
            this.description = description;
            this.required = required;
            this.type = type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public Parameter.Type getType() {
            return this.type;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getName() {
            return this.name();
        }
    }
}

